/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAnalysisResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, UpdateAnalysisResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateAnalysisResponse.getter(UpdateAnalysisResponse::arn)).setter(UpdateAnalysisResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisId").getter(UpdateAnalysisResponse.getter(UpdateAnalysisResponse::analysisId)).setter(UpdateAnalysisResponse.setter(Builder::analysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisId").build()}).build();
    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateStatus").getter(UpdateAnalysisResponse.getter(UpdateAnalysisResponse::updateStatusAsString)).setter(UpdateAnalysisResponse.setter(Builder::updateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(UpdateAnalysisResponse.getter(UpdateAnalysisResponse::status)).setter(UpdateAnalysisResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(UpdateAnalysisResponse.getter(UpdateAnalysisResponse::requestId)).setter(UpdateAnalysisResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ANALYSIS_ID_FIELD, UPDATE_STATUS_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAnalysisResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String analysisId;
    private final String updateStatus;
    private final Integer status;
    private final String requestId;

    private UpdateAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.analysisId = builder.analysisId;
        this.updateStatus = builder.updateStatus;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String analysisId() {
        return this.analysisId;
    }

    public final ResourceStatus updateStatus() {
        return ResourceStatus.fromValue(this.updateStatus);
    }

    public final String updateStatusAsString() {
        return this.updateStatus;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnalysisResponse)) {
            return false;
        }
        UpdateAnalysisResponse other = (UpdateAnalysisResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.analysisId(), other.analysisId()) && Objects.equals(this.updateStatusAsString(), other.updateStatusAsString()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAnalysisResponse").add("Arn", (Object)this.arn()).add("AnalysisId", (Object)this.analysisId()).add("UpdateStatus", (Object)this.updateStatusAsString()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AnalysisId": {
                return Optional.ofNullable(clazz.cast(this.analysisId()));
            }
            case "UpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.updateStatusAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("AnalysisId", ANALYSIS_ID_FIELD);
        map.put("UpdateStatus", UPDATE_STATUS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnalysisResponse, T> g) {
        return obj -> g.apply((UpdateAnalysisResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String analysisId;
        private String updateStatus;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnalysisResponse model) {
            super(model);
            this.arn(model.arn);
            this.analysisId(model.analysisId);
            this.updateStatus(model.updateStatus);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAnalysisId() {
            return this.analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final String getUpdateStatus() {
            return this.updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(ResourceStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public UpdateAnalysisResponse build() {
            return new UpdateAnalysisResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAnalysisResponse> {
        public Builder arn(String var1);

        public Builder analysisId(String var1);

        public Builder updateStatus(String var1);

        public Builder updateStatus(ResourceStatus var1);

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

