/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDirection;
import software.amazon.awssdk.services.quicksight.model.ContributionAnalysisFactor;
import software.amazon.awssdk.services.quicksight.model.ContributionAnalysisFactorsListCopier;
import software.amazon.awssdk.services.quicksight.model.ContributionAnalysisSortType;
import software.amazon.awssdk.services.quicksight.model.ContributionAnalysisTimeRanges;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicIRContributionAnalysis
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicIRContributionAnalysis> {
    private static final SdkField<List<ContributionAnalysisFactor>> FACTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Factors").getter(TopicIRContributionAnalysis.getter(TopicIRContributionAnalysis::factors)).setter(TopicIRContributionAnalysis.setter(Builder::factors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Factors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContributionAnalysisFactor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ContributionAnalysisTimeRanges> TIME_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeRanges").getter(TopicIRContributionAnalysis.getter(TopicIRContributionAnalysis::timeRanges)).setter(TopicIRContributionAnalysis.setter(Builder::timeRanges)).constructor(ContributionAnalysisTimeRanges::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRanges").build()}).build();
    private static final SdkField<String> DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Direction").getter(TopicIRContributionAnalysis.getter(TopicIRContributionAnalysis::directionAsString)).setter(TopicIRContributionAnalysis.setter(Builder::direction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()}).build();
    private static final SdkField<String> SORT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortType").getter(TopicIRContributionAnalysis.getter(TopicIRContributionAnalysis::sortTypeAsString)).setter(TopicIRContributionAnalysis.setter(Builder::sortType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACTORS_FIELD, TIME_RANGES_FIELD, DIRECTION_FIELD, SORT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TopicIRContributionAnalysis.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ContributionAnalysisFactor> factors;
    private final ContributionAnalysisTimeRanges timeRanges;
    private final String direction;
    private final String sortType;

    private TopicIRContributionAnalysis(BuilderImpl builder) {
        this.factors = builder.factors;
        this.timeRanges = builder.timeRanges;
        this.direction = builder.direction;
        this.sortType = builder.sortType;
    }

    public final boolean hasFactors() {
        return this.factors != null && !(this.factors instanceof SdkAutoConstructList);
    }

    public final List<ContributionAnalysisFactor> factors() {
        return this.factors;
    }

    public final ContributionAnalysisTimeRanges timeRanges() {
        return this.timeRanges;
    }

    public final ContributionAnalysisDirection direction() {
        return ContributionAnalysisDirection.fromValue(this.direction);
    }

    public final String directionAsString() {
        return this.direction;
    }

    public final ContributionAnalysisSortType sortType() {
        return ContributionAnalysisSortType.fromValue(this.sortType);
    }

    public final String sortTypeAsString() {
        return this.sortType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFactors() ? this.factors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicIRContributionAnalysis)) {
            return false;
        }
        TopicIRContributionAnalysis other = (TopicIRContributionAnalysis)obj;
        return this.hasFactors() == other.hasFactors() && Objects.equals(this.factors(), other.factors()) && Objects.equals(this.timeRanges(), other.timeRanges()) && Objects.equals(this.directionAsString(), other.directionAsString()) && Objects.equals(this.sortTypeAsString(), other.sortTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TopicIRContributionAnalysis").add("Factors", this.hasFactors() ? this.factors() : null).add("TimeRanges", (Object)this.timeRanges()).add("Direction", (Object)this.directionAsString()).add("SortType", (Object)this.sortTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Factors": {
                return Optional.ofNullable(clazz.cast(this.factors()));
            }
            case "TimeRanges": {
                return Optional.ofNullable(clazz.cast(this.timeRanges()));
            }
            case "Direction": {
                return Optional.ofNullable(clazz.cast(this.directionAsString()));
            }
            case "SortType": {
                return Optional.ofNullable(clazz.cast(this.sortTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Factors", FACTORS_FIELD);
        map.put("TimeRanges", TIME_RANGES_FIELD);
        map.put("Direction", DIRECTION_FIELD);
        map.put("SortType", SORT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicIRContributionAnalysis, T> g) {
        return obj -> g.apply((TopicIRContributionAnalysis)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ContributionAnalysisFactor> factors = DefaultSdkAutoConstructList.getInstance();
        private ContributionAnalysisTimeRanges timeRanges;
        private String direction;
        private String sortType;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicIRContributionAnalysis model) {
            this.factors(model.factors);
            this.timeRanges(model.timeRanges);
            this.direction(model.direction);
            this.sortType(model.sortType);
        }

        public final List<ContributionAnalysisFactor.Builder> getFactors() {
            List<ContributionAnalysisFactor.Builder> result = ContributionAnalysisFactorsListCopier.copyToBuilder(this.factors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFactors(Collection<ContributionAnalysisFactor.BuilderImpl> factors) {
            this.factors = ContributionAnalysisFactorsListCopier.copyFromBuilder(factors);
        }

        @Override
        public final Builder factors(Collection<ContributionAnalysisFactor> factors) {
            this.factors = ContributionAnalysisFactorsListCopier.copy(factors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder factors(ContributionAnalysisFactor ... factors) {
            this.factors(Arrays.asList(factors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder factors(Consumer<ContributionAnalysisFactor.Builder> ... factors) {
            this.factors(Stream.of(factors).map(c -> (ContributionAnalysisFactor)((ContributionAnalysisFactor.Builder)ContributionAnalysisFactor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ContributionAnalysisTimeRanges.Builder getTimeRanges() {
            return this.timeRanges != null ? this.timeRanges.toBuilder() : null;
        }

        public final void setTimeRanges(ContributionAnalysisTimeRanges.BuilderImpl timeRanges) {
            this.timeRanges = timeRanges != null ? timeRanges.build() : null;
        }

        @Override
        public final Builder timeRanges(ContributionAnalysisTimeRanges timeRanges) {
            this.timeRanges = timeRanges;
            return this;
        }

        public final String getDirection() {
            return this.direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(ContributionAnalysisDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final String getSortType() {
            return this.sortType;
        }

        public final void setSortType(String sortType) {
            this.sortType = sortType;
        }

        @Override
        public final Builder sortType(String sortType) {
            this.sortType = sortType;
            return this;
        }

        @Override
        public final Builder sortType(ContributionAnalysisSortType sortType) {
            this.sortType(sortType == null ? null : sortType.toString());
            return this;
        }

        public TopicIRContributionAnalysis build() {
            return new TopicIRContributionAnalysis(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicIRContributionAnalysis> {
        public Builder factors(Collection<ContributionAnalysisFactor> var1);

        public Builder factors(ContributionAnalysisFactor ... var1);

        public Builder factors(Consumer<ContributionAnalysisFactor.Builder> ... var1);

        public Builder timeRanges(ContributionAnalysisTimeRanges var1);

        default public Builder timeRanges(Consumer<ContributionAnalysisTimeRanges.Builder> timeRanges) {
            return this.timeRanges((ContributionAnalysisTimeRanges)((ContributionAnalysisTimeRanges.Builder)ContributionAnalysisTimeRanges.builder().applyMutation(timeRanges)).build());
        }

        public Builder direction(String var1);

        public Builder direction(ContributionAnalysisDirection var1);

        public Builder sortType(String var1);

        public Builder sortType(ContributionAnalysisSortType var1);
    }
}

