/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.BrandSummary;
import software.amazon.awssdk.services.quicksight.model.ListBrandsRequest;
import software.amazon.awssdk.services.quicksight.model.ListBrandsResponse;

public class ListBrandsIterable
implements SdkIterable<ListBrandsResponse> {
    private final QuickSightClient client;
    private final ListBrandsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBrandsIterable(QuickSightClient client, ListBrandsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBrandsResponseFetcher();
    }

    public Iterator<ListBrandsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BrandSummary> brands() {
        Function<ListBrandsResponse, Iterator> getIterator = response -> {
            if (response != null && response.brands() != null) {
                return response.brands().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBrandsResponseFetcher
    implements SyncPageFetcher<ListBrandsResponse> {
        private ListBrandsResponseFetcher() {
        }

        public boolean hasNextPage(ListBrandsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBrandsResponse nextPage(ListBrandsResponse previousPage) {
            if (previousPage == null) {
                return ListBrandsIterable.this.client.listBrands(ListBrandsIterable.this.firstRequest);
            }
            return ListBrandsIterable.this.client.listBrands((ListBrandsRequest)((Object)ListBrandsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

