/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CustomFilterConfiguration;
import software.amazon.awssdk.services.quicksight.model.CustomFilterListConfiguration;
import software.amazon.awssdk.services.quicksight.model.FilterListConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CategoryFilterConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CategoryFilterConfiguration> {
    private static final SdkField<FilterListConfiguration> FILTER_LIST_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterListConfiguration").getter(CategoryFilterConfiguration.getter(CategoryFilterConfiguration::filterListConfiguration)).setter(CategoryFilterConfiguration.setter(Builder::filterListConfiguration)).constructor(FilterListConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterListConfiguration").build()}).build();
    private static final SdkField<CustomFilterListConfiguration> CUSTOM_FILTER_LIST_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomFilterListConfiguration").getter(CategoryFilterConfiguration.getter(CategoryFilterConfiguration::customFilterListConfiguration)).setter(CategoryFilterConfiguration.setter(Builder::customFilterListConfiguration)).constructor(CustomFilterListConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomFilterListConfiguration").build()}).build();
    private static final SdkField<CustomFilterConfiguration> CUSTOM_FILTER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomFilterConfiguration").getter(CategoryFilterConfiguration.getter(CategoryFilterConfiguration::customFilterConfiguration)).setter(CategoryFilterConfiguration.setter(Builder::customFilterConfiguration)).constructor(CustomFilterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomFilterConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_LIST_CONFIGURATION_FIELD, CUSTOM_FILTER_LIST_CONFIGURATION_FIELD, CUSTOM_FILTER_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CategoryFilterConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FilterListConfiguration filterListConfiguration;
    private final CustomFilterListConfiguration customFilterListConfiguration;
    private final CustomFilterConfiguration customFilterConfiguration;

    private CategoryFilterConfiguration(BuilderImpl builder) {
        this.filterListConfiguration = builder.filterListConfiguration;
        this.customFilterListConfiguration = builder.customFilterListConfiguration;
        this.customFilterConfiguration = builder.customFilterConfiguration;
    }

    public final FilterListConfiguration filterListConfiguration() {
        return this.filterListConfiguration;
    }

    public final CustomFilterListConfiguration customFilterListConfiguration() {
        return this.customFilterListConfiguration;
    }

    public final CustomFilterConfiguration customFilterConfiguration() {
        return this.customFilterConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterListConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customFilterListConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customFilterConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryFilterConfiguration)) {
            return false;
        }
        CategoryFilterConfiguration other = (CategoryFilterConfiguration)obj;
        return Objects.equals(this.filterListConfiguration(), other.filterListConfiguration()) && Objects.equals(this.customFilterListConfiguration(), other.customFilterListConfiguration()) && Objects.equals(this.customFilterConfiguration(), other.customFilterConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CategoryFilterConfiguration").add("FilterListConfiguration", (Object)this.filterListConfiguration()).add("CustomFilterListConfiguration", (Object)this.customFilterListConfiguration()).add("CustomFilterConfiguration", (Object)this.customFilterConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterListConfiguration": {
                return Optional.ofNullable(clazz.cast(this.filterListConfiguration()));
            }
            case "CustomFilterListConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customFilterListConfiguration()));
            }
            case "CustomFilterConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customFilterConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FilterListConfiguration", FILTER_LIST_CONFIGURATION_FIELD);
        map.put("CustomFilterListConfiguration", CUSTOM_FILTER_LIST_CONFIGURATION_FIELD);
        map.put("CustomFilterConfiguration", CUSTOM_FILTER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CategoryFilterConfiguration, T> g) {
        return obj -> g.apply((CategoryFilterConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FilterListConfiguration filterListConfiguration;
        private CustomFilterListConfiguration customFilterListConfiguration;
        private CustomFilterConfiguration customFilterConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CategoryFilterConfiguration model) {
            this.filterListConfiguration(model.filterListConfiguration);
            this.customFilterListConfiguration(model.customFilterListConfiguration);
            this.customFilterConfiguration(model.customFilterConfiguration);
        }

        public final FilterListConfiguration.Builder getFilterListConfiguration() {
            return this.filterListConfiguration != null ? this.filterListConfiguration.toBuilder() : null;
        }

        public final void setFilterListConfiguration(FilterListConfiguration.BuilderImpl filterListConfiguration) {
            this.filterListConfiguration = filterListConfiguration != null ? filterListConfiguration.build() : null;
        }

        @Override
        public final Builder filterListConfiguration(FilterListConfiguration filterListConfiguration) {
            this.filterListConfiguration = filterListConfiguration;
            return this;
        }

        public final CustomFilterListConfiguration.Builder getCustomFilterListConfiguration() {
            return this.customFilterListConfiguration != null ? this.customFilterListConfiguration.toBuilder() : null;
        }

        public final void setCustomFilterListConfiguration(CustomFilterListConfiguration.BuilderImpl customFilterListConfiguration) {
            this.customFilterListConfiguration = customFilterListConfiguration != null ? customFilterListConfiguration.build() : null;
        }

        @Override
        public final Builder customFilterListConfiguration(CustomFilterListConfiguration customFilterListConfiguration) {
            this.customFilterListConfiguration = customFilterListConfiguration;
            return this;
        }

        public final CustomFilterConfiguration.Builder getCustomFilterConfiguration() {
            return this.customFilterConfiguration != null ? this.customFilterConfiguration.toBuilder() : null;
        }

        public final void setCustomFilterConfiguration(CustomFilterConfiguration.BuilderImpl customFilterConfiguration) {
            this.customFilterConfiguration = customFilterConfiguration != null ? customFilterConfiguration.build() : null;
        }

        @Override
        public final Builder customFilterConfiguration(CustomFilterConfiguration customFilterConfiguration) {
            this.customFilterConfiguration = customFilterConfiguration;
            return this;
        }

        public CategoryFilterConfiguration build() {
            return new CategoryFilterConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CategoryFilterConfiguration> {
        public Builder filterListConfiguration(FilterListConfiguration var1);

        default public Builder filterListConfiguration(Consumer<FilterListConfiguration.Builder> filterListConfiguration) {
            return this.filterListConfiguration((FilterListConfiguration)((FilterListConfiguration.Builder)FilterListConfiguration.builder().applyMutation(filterListConfiguration)).build());
        }

        public Builder customFilterListConfiguration(CustomFilterListConfiguration var1);

        default public Builder customFilterListConfiguration(Consumer<CustomFilterListConfiguration.Builder> customFilterListConfiguration) {
            return this.customFilterListConfiguration((CustomFilterListConfiguration)((CustomFilterListConfiguration.Builder)CustomFilterListConfiguration.builder().applyMutation(customFilterListConfiguration)).build());
        }

        public Builder customFilterConfiguration(CustomFilterConfiguration var1);

        default public Builder customFilterConfiguration(Consumer<CustomFilterConfiguration.Builder> customFilterConfiguration) {
            return this.customFilterConfiguration((CustomFilterConfiguration)((CustomFilterConfiguration.Builder)CustomFilterConfiguration.builder().applyMutation(customFilterConfiguration)).build());
        }
    }
}

