/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that are available for a single Y axis in a chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class YAxisOptions implements SdkPojo, Serializable, ToCopyableBuilder<YAxisOptions.Builder, YAxisOptions> {
    private static final SdkField<String> Y_AXIS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("YAxis")
            .getter(getter(YAxisOptions::yAxisAsString)).setter(setter(Builder::yAxis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YAxis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(Y_AXIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String yAxis;

    private YAxisOptions(BuilderImpl builder) {
        this.yAxis = builder.yAxis;
    }

    /**
     * <p>
     * The Y axis type to be used in the chart.
     * </p>
     * <p>
     * If you choose <code>PRIMARY_Y_AXIS</code>, the primary Y Axis is located on the leftmost vertical axis of the
     * chart.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #yAxis} will return
     * {@link SingleYAxisOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #yAxisAsString}.
     * </p>
     * 
     * @return The Y axis type to be used in the chart.</p>
     *         <p>
     *         If you choose <code>PRIMARY_Y_AXIS</code>, the primary Y Axis is located on the leftmost vertical axis of
     *         the chart.
     * @see SingleYAxisOption
     */
    public final SingleYAxisOption yAxis() {
        return SingleYAxisOption.fromValue(yAxis);
    }

    /**
     * <p>
     * The Y axis type to be used in the chart.
     * </p>
     * <p>
     * If you choose <code>PRIMARY_Y_AXIS</code>, the primary Y Axis is located on the leftmost vertical axis of the
     * chart.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #yAxis} will return
     * {@link SingleYAxisOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #yAxisAsString}.
     * </p>
     * 
     * @return The Y axis type to be used in the chart.</p>
     *         <p>
     *         If you choose <code>PRIMARY_Y_AXIS</code>, the primary Y Axis is located on the leftmost vertical axis of
     *         the chart.
     * @see SingleYAxisOption
     */
    public final String yAxisAsString() {
        return yAxis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(yAxisAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof YAxisOptions)) {
            return false;
        }
        YAxisOptions other = (YAxisOptions) obj;
        return Objects.equals(yAxisAsString(), other.yAxisAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("YAxisOptions").add("YAxis", yAxisAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "YAxis":
            return Optional.ofNullable(clazz.cast(yAxisAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("YAxis", Y_AXIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<YAxisOptions, T> g) {
        return obj -> g.apply((YAxisOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, YAxisOptions> {
        /**
         * <p>
         * The Y axis type to be used in the chart.
         * </p>
         * <p>
         * If you choose <code>PRIMARY_Y_AXIS</code>, the primary Y Axis is located on the leftmost vertical axis of the
         * chart.
         * </p>
         * 
         * @param yAxis
         *        The Y axis type to be used in the chart.</p>
         *        <p>
         *        If you choose <code>PRIMARY_Y_AXIS</code>, the primary Y Axis is located on the leftmost vertical axis
         *        of the chart.
         * @see SingleYAxisOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SingleYAxisOption
         */
        Builder yAxis(String yAxis);

        /**
         * <p>
         * The Y axis type to be used in the chart.
         * </p>
         * <p>
         * If you choose <code>PRIMARY_Y_AXIS</code>, the primary Y Axis is located on the leftmost vertical axis of the
         * chart.
         * </p>
         * 
         * @param yAxis
         *        The Y axis type to be used in the chart.</p>
         *        <p>
         *        If you choose <code>PRIMARY_Y_AXIS</code>, the primary Y Axis is located on the leftmost vertical axis
         *        of the chart.
         * @see SingleYAxisOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SingleYAxisOption
         */
        Builder yAxis(SingleYAxisOption yAxis);
    }

    static final class BuilderImpl implements Builder {
        private String yAxis;

        private BuilderImpl() {
        }

        private BuilderImpl(YAxisOptions model) {
            yAxis(model.yAxis);
        }

        public final String getYAxis() {
            return yAxis;
        }

        public final void setYAxis(String yAxis) {
            this.yAxis = yAxis;
        }

        @Override
        public final Builder yAxis(String yAxis) {
            this.yAxis = yAxis;
            return this;
        }

        @Override
        public final Builder yAxis(SingleYAxisOption yAxis) {
            this.yAxis(yAxis == null ? null : yAxis.toString());
            return this;
        }

        @Override
        public YAxisOptions build() {
            return new YAxisOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
