/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVpcConnectionResponse extends QuickSightResponse implements
        ToCopyableBuilder<UpdateVpcConnectionResponse.Builder, UpdateVpcConnectionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateVpcConnectionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> VPC_CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VPCConnectionId").getter(getter(UpdateVpcConnectionResponse::vpcConnectionId))
            .setter(setter(Builder::vpcConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCConnectionId").build()).build();

    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateStatus").getter(getter(UpdateVpcConnectionResponse::updateStatusAsString))
            .setter(setter(Builder::updateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()).build();

    private static final SdkField<String> AVAILABILITY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityStatus").getter(getter(UpdateVpcConnectionResponse::availabilityStatusAsString))
            .setter(setter(Builder::availabilityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityStatus").build())
            .build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(UpdateVpcConnectionResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(UpdateVpcConnectionResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            VPC_CONNECTION_ID_FIELD, UPDATE_STATUS_FIELD, AVAILABILITY_STATUS_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String vpcConnectionId;

    private final String updateStatus;

    private final String availabilityStatus;

    private final String requestId;

    private final Integer status;

    private UpdateVpcConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.vpcConnectionId = builder.vpcConnectionId;
        this.updateStatus = builder.updateStatus;
        this.availabilityStatus = builder.availabilityStatus;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the VPC connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the VPC connection.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the VPC connection that you are updating. This ID is a unique identifier for each Amazon Web Services
     * Region in anAmazon Web Services account.
     * </p>
     * 
     * @return The ID of the VPC connection that you are updating. This ID is a unique identifier for each Amazon Web
     *         Services Region in anAmazon Web Services account.
     */
    public final String vpcConnectionId() {
        return vpcConnectionId;
    }

    /**
     * <p>
     * The update status of the VPC connection's last update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link VPCConnectionResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #updateStatusAsString}.
     * </p>
     * 
     * @return The update status of the VPC connection's last update.
     * @see VPCConnectionResourceStatus
     */
    public final VPCConnectionResourceStatus updateStatus() {
        return VPCConnectionResourceStatus.fromValue(updateStatus);
    }

    /**
     * <p>
     * The update status of the VPC connection's last update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link VPCConnectionResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #updateStatusAsString}.
     * </p>
     * 
     * @return The update status of the VPC connection's last update.
     * @see VPCConnectionResourceStatus
     */
    public final String updateStatusAsString() {
        return updateStatus;
    }

    /**
     * <p>
     * The availability status of the VPC connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #availabilityStatus} will return {@link VPCConnectionAvailabilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #availabilityStatusAsString}.
     * </p>
     * 
     * @return The availability status of the VPC connection.
     * @see VPCConnectionAvailabilityStatus
     */
    public final VPCConnectionAvailabilityStatus availabilityStatus() {
        return VPCConnectionAvailabilityStatus.fromValue(availabilityStatus);
    }

    /**
     * <p>
     * The availability status of the VPC connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #availabilityStatus} will return {@link VPCConnectionAvailabilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #availabilityStatusAsString}.
     * </p>
     * 
     * @return The availability status of the VPC connection.
     * @see VPCConnectionAvailabilityStatus
     */
    public final String availabilityStatusAsString() {
        return availabilityStatus;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(updateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcConnectionResponse)) {
            return false;
        }
        UpdateVpcConnectionResponse other = (UpdateVpcConnectionResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(vpcConnectionId(), other.vpcConnectionId())
                && Objects.equals(updateStatusAsString(), other.updateStatusAsString())
                && Objects.equals(availabilityStatusAsString(), other.availabilityStatusAsString())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVpcConnectionResponse").add("Arn", arn()).add("VPCConnectionId", vpcConnectionId())
                .add("UpdateStatus", updateStatusAsString()).add("AvailabilityStatus", availabilityStatusAsString())
                .add("RequestId", requestId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "VPCConnectionId":
            return Optional.ofNullable(clazz.cast(vpcConnectionId()));
        case "UpdateStatus":
            return Optional.ofNullable(clazz.cast(updateStatusAsString()));
        case "AvailabilityStatus":
            return Optional.ofNullable(clazz.cast(availabilityStatusAsString()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("VPCConnectionId", VPC_CONNECTION_ID_FIELD);
        map.put("UpdateStatus", UPDATE_STATUS_FIELD);
        map.put("AvailabilityStatus", AVAILABILITY_STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcConnectionResponse, T> g) {
        return obj -> g.apply((UpdateVpcConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVpcConnectionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the VPC connection.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the VPC connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the VPC connection that you are updating. This ID is a unique identifier for each Amazon Web
         * Services Region in anAmazon Web Services account.
         * </p>
         * 
         * @param vpcConnectionId
         *        The ID of the VPC connection that you are updating. This ID is a unique identifier for each Amazon Web
         *        Services Region in anAmazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectionId(String vpcConnectionId);

        /**
         * <p>
         * The update status of the VPC connection's last update.
         * </p>
         * 
         * @param updateStatus
         *        The update status of the VPC connection's last update.
         * @see VPCConnectionResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VPCConnectionResourceStatus
         */
        Builder updateStatus(String updateStatus);

        /**
         * <p>
         * The update status of the VPC connection's last update.
         * </p>
         * 
         * @param updateStatus
         *        The update status of the VPC connection's last update.
         * @see VPCConnectionResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VPCConnectionResourceStatus
         */
        Builder updateStatus(VPCConnectionResourceStatus updateStatus);

        /**
         * <p>
         * The availability status of the VPC connection.
         * </p>
         * 
         * @param availabilityStatus
         *        The availability status of the VPC connection.
         * @see VPCConnectionAvailabilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VPCConnectionAvailabilityStatus
         */
        Builder availabilityStatus(String availabilityStatus);

        /**
         * <p>
         * The availability status of the VPC connection.
         * </p>
         * 
         * @param availabilityStatus
         *        The availability status of the VPC connection.
         * @see VPCConnectionAvailabilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VPCConnectionAvailabilityStatus
         */
        Builder availabilityStatus(VPCConnectionAvailabilityStatus availabilityStatus);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String arn;

        private String vpcConnectionId;

        private String updateStatus;

        private String availabilityStatus;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcConnectionResponse model) {
            super(model);
            arn(model.arn);
            vpcConnectionId(model.vpcConnectionId);
            updateStatus(model.updateStatus);
            availabilityStatus(model.availabilityStatus);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getVpcConnectionId() {
            return vpcConnectionId;
        }

        public final void setVpcConnectionId(String vpcConnectionId) {
            this.vpcConnectionId = vpcConnectionId;
        }

        @Override
        public final Builder vpcConnectionId(String vpcConnectionId) {
            this.vpcConnectionId = vpcConnectionId;
            return this;
        }

        public final String getUpdateStatus() {
            return updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(VPCConnectionResourceStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public final String getAvailabilityStatus() {
            return availabilityStatus;
        }

        public final void setAvailabilityStatus(String availabilityStatus) {
            this.availabilityStatus = availabilityStatus;
        }

        @Override
        public final Builder availabilityStatus(String availabilityStatus) {
            this.availabilityStatus = availabilityStatus;
            return this;
        }

        @Override
        public final Builder availabilityStatus(VPCConnectionAvailabilityStatus availabilityStatus) {
            this.availabilityStatus(availabilityStatus == null ? null : availabilityStatus.toString());
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public UpdateVpcConnectionResponse build() {
            return new UpdateVpcConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
