/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for a <code>TopicIRGroupBy</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicIRGroupBy implements SdkPojo, Serializable, ToCopyableBuilder<TopicIRGroupBy.Builder, TopicIRGroupBy> {
    private static final SdkField<Identifier> FIELD_NAME_FIELD = SdkField.<Identifier> builder(MarshallingType.SDK_POJO)
            .memberName("FieldName").getter(getter(TopicIRGroupBy::fieldName)).setter(setter(Builder::fieldName))
            .constructor(Identifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeGranularity").getter(getter(TopicIRGroupBy::timeGranularityAsString))
            .setter(setter(Builder::timeGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()).build();

    private static final SdkField<TopicSortClause> SORT_FIELD = SdkField.<TopicSortClause> builder(MarshallingType.SDK_POJO)
            .memberName("Sort").getter(getter(TopicIRGroupBy::sort)).setter(setter(Builder::sort))
            .constructor(TopicSortClause::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()).build();

    private static final SdkField<String> DISPLAY_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayFormat").getter(getter(TopicIRGroupBy::displayFormatAsString))
            .setter(setter(Builder::displayFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayFormat").build()).build();

    private static final SdkField<DisplayFormatOptions> DISPLAY_FORMAT_OPTIONS_FIELD = SdkField
            .<DisplayFormatOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayFormatOptions")
            .getter(getter(TopicIRGroupBy::displayFormatOptions)).setter(setter(Builder::displayFormatOptions))
            .constructor(DisplayFormatOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayFormatOptions").build())
            .build();

    private static final SdkField<NamedEntityRef> NAMED_ENTITY_FIELD = SdkField
            .<NamedEntityRef> builder(MarshallingType.SDK_POJO).memberName("NamedEntity")
            .getter(getter(TopicIRGroupBy::namedEntity)).setter(setter(Builder::namedEntity))
            .constructor(NamedEntityRef::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedEntity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD,
            TIME_GRANULARITY_FIELD, SORT_FIELD, DISPLAY_FORMAT_FIELD, DISPLAY_FORMAT_OPTIONS_FIELD, NAMED_ENTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Identifier fieldName;

    private final String timeGranularity;

    private final TopicSortClause sort;

    private final String displayFormat;

    private final DisplayFormatOptions displayFormatOptions;

    private final NamedEntityRef namedEntity;

    private TopicIRGroupBy(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.timeGranularity = builder.timeGranularity;
        this.sort = builder.sort;
        this.displayFormat = builder.displayFormat;
        this.displayFormatOptions = builder.displayFormatOptions;
        this.namedEntity = builder.namedEntity;
    }

    /**
     * <p>
     * The field name for the <code>TopicIRGroupBy</code>.
     * </p>
     * 
     * @return The field name for the <code>TopicIRGroupBy</code>.
     */
    public final Identifier fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * The time granularity for the <code>TopicIRGroupBy</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TopicTimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The time granularity for the <code>TopicIRGroupBy</code>.
     * @see TopicTimeGranularity
     */
    public final TopicTimeGranularity timeGranularity() {
        return TopicTimeGranularity.fromValue(timeGranularity);
    }

    /**
     * <p>
     * The time granularity for the <code>TopicIRGroupBy</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TopicTimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The time granularity for the <code>TopicIRGroupBy</code>.
     * @see TopicTimeGranularity
     */
    public final String timeGranularityAsString() {
        return timeGranularity;
    }

    /**
     * <p>
     * The sort for the <code>TopicIRGroupBy</code>.
     * </p>
     * 
     * @return The sort for the <code>TopicIRGroupBy</code>.
     */
    public final TopicSortClause sort() {
        return sort;
    }

    /**
     * <p>
     * The display format for the <code>TopicIRGroupBy</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #displayFormat}
     * will return {@link DisplayFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #displayFormatAsString}.
     * </p>
     * 
     * @return The display format for the <code>TopicIRGroupBy</code>.
     * @see DisplayFormat
     */
    public final DisplayFormat displayFormat() {
        return DisplayFormat.fromValue(displayFormat);
    }

    /**
     * <p>
     * The display format for the <code>TopicIRGroupBy</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #displayFormat}
     * will return {@link DisplayFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #displayFormatAsString}.
     * </p>
     * 
     * @return The display format for the <code>TopicIRGroupBy</code>.
     * @see DisplayFormat
     */
    public final String displayFormatAsString() {
        return displayFormat;
    }

    /**
     * Returns the value of the DisplayFormatOptions property for this object.
     * 
     * @return The value of the DisplayFormatOptions property for this object.
     */
    public final DisplayFormatOptions displayFormatOptions() {
        return displayFormatOptions;
    }

    /**
     * <p>
     * The named entity for the <code>TopicIRGroupBy</code>.
     * </p>
     * 
     * @return The named entity for the <code>TopicIRGroupBy</code>.
     */
    public final NamedEntityRef namedEntity() {
        return namedEntity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        hashCode = 31 * hashCode + Objects.hashCode(displayFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayFormatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(namedEntity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicIRGroupBy)) {
            return false;
        }
        TopicIRGroupBy other = (TopicIRGroupBy) obj;
        return Objects.equals(fieldName(), other.fieldName())
                && Objects.equals(timeGranularityAsString(), other.timeGranularityAsString())
                && Objects.equals(sort(), other.sort()) && Objects.equals(displayFormatAsString(), other.displayFormatAsString())
                && Objects.equals(displayFormatOptions(), other.displayFormatOptions())
                && Objects.equals(namedEntity(), other.namedEntity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicIRGroupBy").add("FieldName", fieldName()).add("TimeGranularity", timeGranularityAsString())
                .add("Sort", sort()).add("DisplayFormat", displayFormatAsString())
                .add("DisplayFormatOptions", displayFormatOptions()).add("NamedEntity", namedEntity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "TimeGranularity":
            return Optional.ofNullable(clazz.cast(timeGranularityAsString()));
        case "Sort":
            return Optional.ofNullable(clazz.cast(sort()));
        case "DisplayFormat":
            return Optional.ofNullable(clazz.cast(displayFormatAsString()));
        case "DisplayFormatOptions":
            return Optional.ofNullable(clazz.cast(displayFormatOptions()));
        case "NamedEntity":
            return Optional.ofNullable(clazz.cast(namedEntity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("TimeGranularity", TIME_GRANULARITY_FIELD);
        map.put("Sort", SORT_FIELD);
        map.put("DisplayFormat", DISPLAY_FORMAT_FIELD);
        map.put("DisplayFormatOptions", DISPLAY_FORMAT_OPTIONS_FIELD);
        map.put("NamedEntity", NAMED_ENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicIRGroupBy, T> g) {
        return obj -> g.apply((TopicIRGroupBy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicIRGroupBy> {
        /**
         * <p>
         * The field name for the <code>TopicIRGroupBy</code>.
         * </p>
         * 
         * @param fieldName
         *        The field name for the <code>TopicIRGroupBy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(Identifier fieldName);

        /**
         * <p>
         * The field name for the <code>TopicIRGroupBy</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Identifier.Builder} avoiding the need to
         * create one manually via {@link Identifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Identifier.Builder#build()} is called immediately and its result
         * is passed to {@link #fieldName(Identifier)}.
         * 
         * @param fieldName
         *        a consumer that will call methods on {@link Identifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldName(Identifier)
         */
        default Builder fieldName(Consumer<Identifier.Builder> fieldName) {
            return fieldName(Identifier.builder().applyMutation(fieldName).build());
        }

        /**
         * <p>
         * The time granularity for the <code>TopicIRGroupBy</code>.
         * </p>
         * 
         * @param timeGranularity
         *        The time granularity for the <code>TopicIRGroupBy</code>.
         * @see TopicTimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicTimeGranularity
         */
        Builder timeGranularity(String timeGranularity);

        /**
         * <p>
         * The time granularity for the <code>TopicIRGroupBy</code>.
         * </p>
         * 
         * @param timeGranularity
         *        The time granularity for the <code>TopicIRGroupBy</code>.
         * @see TopicTimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicTimeGranularity
         */
        Builder timeGranularity(TopicTimeGranularity timeGranularity);

        /**
         * <p>
         * The sort for the <code>TopicIRGroupBy</code>.
         * </p>
         * 
         * @param sort
         *        The sort for the <code>TopicIRGroupBy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(TopicSortClause sort);

        /**
         * <p>
         * The sort for the <code>TopicIRGroupBy</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicSortClause.Builder} avoiding the
         * need to create one manually via {@link TopicSortClause#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicSortClause.Builder#build()} is called immediately and its
         * result is passed to {@link #sort(TopicSortClause)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link TopicSortClause.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(TopicSortClause)
         */
        default Builder sort(Consumer<TopicSortClause.Builder> sort) {
            return sort(TopicSortClause.builder().applyMutation(sort).build());
        }

        /**
         * <p>
         * The display format for the <code>TopicIRGroupBy</code>.
         * </p>
         * 
         * @param displayFormat
         *        The display format for the <code>TopicIRGroupBy</code>.
         * @see DisplayFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisplayFormat
         */
        Builder displayFormat(String displayFormat);

        /**
         * <p>
         * The display format for the <code>TopicIRGroupBy</code>.
         * </p>
         * 
         * @param displayFormat
         *        The display format for the <code>TopicIRGroupBy</code>.
         * @see DisplayFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisplayFormat
         */
        Builder displayFormat(DisplayFormat displayFormat);

        /**
         * Sets the value of the DisplayFormatOptions property for this object.
         *
         * @param displayFormatOptions
         *        The new value for the DisplayFormatOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayFormatOptions(DisplayFormatOptions displayFormatOptions);

        /**
         * Sets the value of the DisplayFormatOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DisplayFormatOptions.Builder} avoiding
         * the need to create one manually via {@link DisplayFormatOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DisplayFormatOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #displayFormatOptions(DisplayFormatOptions)}.
         * 
         * @param displayFormatOptions
         *        a consumer that will call methods on {@link DisplayFormatOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayFormatOptions(DisplayFormatOptions)
         */
        default Builder displayFormatOptions(Consumer<DisplayFormatOptions.Builder> displayFormatOptions) {
            return displayFormatOptions(DisplayFormatOptions.builder().applyMutation(displayFormatOptions).build());
        }

        /**
         * <p>
         * The named entity for the <code>TopicIRGroupBy</code>.
         * </p>
         * 
         * @param namedEntity
         *        The named entity for the <code>TopicIRGroupBy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedEntity(NamedEntityRef namedEntity);

        /**
         * <p>
         * The named entity for the <code>TopicIRGroupBy</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link NamedEntityRef.Builder} avoiding the need
         * to create one manually via {@link NamedEntityRef#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NamedEntityRef.Builder#build()} is called immediately and its
         * result is passed to {@link #namedEntity(NamedEntityRef)}.
         * 
         * @param namedEntity
         *        a consumer that will call methods on {@link NamedEntityRef.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #namedEntity(NamedEntityRef)
         */
        default Builder namedEntity(Consumer<NamedEntityRef.Builder> namedEntity) {
            return namedEntity(NamedEntityRef.builder().applyMutation(namedEntity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Identifier fieldName;

        private String timeGranularity;

        private TopicSortClause sort;

        private String displayFormat;

        private DisplayFormatOptions displayFormatOptions;

        private NamedEntityRef namedEntity;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicIRGroupBy model) {
            fieldName(model.fieldName);
            timeGranularity(model.timeGranularity);
            sort(model.sort);
            displayFormat(model.displayFormat);
            displayFormatOptions(model.displayFormatOptions);
            namedEntity(model.namedEntity);
        }

        public final Identifier.Builder getFieldName() {
            return fieldName != null ? fieldName.toBuilder() : null;
        }

        public final void setFieldName(Identifier.BuilderImpl fieldName) {
            this.fieldName = fieldName != null ? fieldName.build() : null;
        }

        @Override
        public final Builder fieldName(Identifier fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getTimeGranularity() {
            return timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TopicTimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final TopicSortClause.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(TopicSortClause.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(TopicSortClause sort) {
            this.sort = sort;
            return this;
        }

        public final String getDisplayFormat() {
            return displayFormat;
        }

        public final void setDisplayFormat(String displayFormat) {
            this.displayFormat = displayFormat;
        }

        @Override
        public final Builder displayFormat(String displayFormat) {
            this.displayFormat = displayFormat;
            return this;
        }

        @Override
        public final Builder displayFormat(DisplayFormat displayFormat) {
            this.displayFormat(displayFormat == null ? null : displayFormat.toString());
            return this;
        }

        public final DisplayFormatOptions.Builder getDisplayFormatOptions() {
            return displayFormatOptions != null ? displayFormatOptions.toBuilder() : null;
        }

        public final void setDisplayFormatOptions(DisplayFormatOptions.BuilderImpl displayFormatOptions) {
            this.displayFormatOptions = displayFormatOptions != null ? displayFormatOptions.build() : null;
        }

        @Override
        public final Builder displayFormatOptions(DisplayFormatOptions displayFormatOptions) {
            this.displayFormatOptions = displayFormatOptions;
            return this;
        }

        public final NamedEntityRef.Builder getNamedEntity() {
            return namedEntity != null ? namedEntity.toBuilder() : null;
        }

        public final void setNamedEntity(NamedEntityRef.BuilderImpl namedEntity) {
            this.namedEntity = namedEntity != null ? namedEntity.build() : null;
        }

        @Override
        public final Builder namedEntity(NamedEntityRef namedEntity) {
            this.namedEntity = namedEntity;
            return this;
        }

        @Override
        public TopicIRGroupBy build() {
            return new TopicIRGroupBy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
