/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The forecast properties setup of a forecast in the line chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeBasedForecastProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeBasedForecastProperties.Builder, TimeBasedForecastProperties> {
    private static final SdkField<Integer> PERIODS_FORWARD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeriodsForward").getter(getter(TimeBasedForecastProperties::periodsForward))
            .setter(setter(Builder::periodsForward))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodsForward").build()).build();

    private static final SdkField<Integer> PERIODS_BACKWARD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeriodsBackward").getter(getter(TimeBasedForecastProperties::periodsBackward))
            .setter(setter(Builder::periodsBackward))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodsBackward").build()).build();

    private static final SdkField<Double> UPPER_BOUNDARY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("UpperBoundary").getter(getter(TimeBasedForecastProperties::upperBoundary))
            .setter(setter(Builder::upperBoundary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpperBoundary").build()).build();

    private static final SdkField<Double> LOWER_BOUNDARY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LowerBoundary").getter(getter(TimeBasedForecastProperties::lowerBoundary))
            .setter(setter(Builder::lowerBoundary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowerBoundary").build()).build();

    private static final SdkField<Integer> PREDICTION_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PredictionInterval").getter(getter(TimeBasedForecastProperties::predictionInterval))
            .setter(setter(Builder::predictionInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionInterval").build())
            .build();

    private static final SdkField<Integer> SEASONALITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Seasonality").getter(getter(TimeBasedForecastProperties::seasonality))
            .setter(setter(Builder::seasonality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Seasonality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERIODS_FORWARD_FIELD,
            PERIODS_BACKWARD_FIELD, UPPER_BOUNDARY_FIELD, LOWER_BOUNDARY_FIELD, PREDICTION_INTERVAL_FIELD, SEASONALITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer periodsForward;

    private final Integer periodsBackward;

    private final Double upperBoundary;

    private final Double lowerBoundary;

    private final Integer predictionInterval;

    private final Integer seasonality;

    private TimeBasedForecastProperties(BuilderImpl builder) {
        this.periodsForward = builder.periodsForward;
        this.periodsBackward = builder.periodsBackward;
        this.upperBoundary = builder.upperBoundary;
        this.lowerBoundary = builder.lowerBoundary;
        this.predictionInterval = builder.predictionInterval;
        this.seasonality = builder.seasonality;
    }

    /**
     * <p>
     * The periods forward setup of a forecast computation.
     * </p>
     * 
     * @return The periods forward setup of a forecast computation.
     */
    public final Integer periodsForward() {
        return periodsForward;
    }

    /**
     * <p>
     * The periods backward setup of a forecast computation.
     * </p>
     * 
     * @return The periods backward setup of a forecast computation.
     */
    public final Integer periodsBackward() {
        return periodsBackward;
    }

    /**
     * <p>
     * The upper boundary setup of a forecast computation.
     * </p>
     * 
     * @return The upper boundary setup of a forecast computation.
     */
    public final Double upperBoundary() {
        return upperBoundary;
    }

    /**
     * <p>
     * The lower boundary setup of a forecast computation.
     * </p>
     * 
     * @return The lower boundary setup of a forecast computation.
     */
    public final Double lowerBoundary() {
        return lowerBoundary;
    }

    /**
     * <p>
     * The prediction interval setup of a forecast computation.
     * </p>
     * 
     * @return The prediction interval setup of a forecast computation.
     */
    public final Integer predictionInterval() {
        return predictionInterval;
    }

    /**
     * <p>
     * The seasonality setup of a forecast computation. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NULL</code>: The input is set to <code>NULL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_NULL</code>: The input is set to a custom value.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The seasonality setup of a forecast computation. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NULL</code>: The input is set to <code>NULL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_NULL</code>: The input is set to a custom value.
     *         </p>
     *         </li>
     */
    public final Integer seasonality() {
        return seasonality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(periodsForward());
        hashCode = 31 * hashCode + Objects.hashCode(periodsBackward());
        hashCode = 31 * hashCode + Objects.hashCode(upperBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(lowerBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(predictionInterval());
        hashCode = 31 * hashCode + Objects.hashCode(seasonality());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeBasedForecastProperties)) {
            return false;
        }
        TimeBasedForecastProperties other = (TimeBasedForecastProperties) obj;
        return Objects.equals(periodsForward(), other.periodsForward())
                && Objects.equals(periodsBackward(), other.periodsBackward())
                && Objects.equals(upperBoundary(), other.upperBoundary())
                && Objects.equals(lowerBoundary(), other.lowerBoundary())
                && Objects.equals(predictionInterval(), other.predictionInterval())
                && Objects.equals(seasonality(), other.seasonality());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeBasedForecastProperties").add("PeriodsForward", periodsForward())
                .add("PeriodsBackward", periodsBackward()).add("UpperBoundary", upperBoundary())
                .add("LowerBoundary", lowerBoundary()).add("PredictionInterval", predictionInterval())
                .add("Seasonality", seasonality()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PeriodsForward":
            return Optional.ofNullable(clazz.cast(periodsForward()));
        case "PeriodsBackward":
            return Optional.ofNullable(clazz.cast(periodsBackward()));
        case "UpperBoundary":
            return Optional.ofNullable(clazz.cast(upperBoundary()));
        case "LowerBoundary":
            return Optional.ofNullable(clazz.cast(lowerBoundary()));
        case "PredictionInterval":
            return Optional.ofNullable(clazz.cast(predictionInterval()));
        case "Seasonality":
            return Optional.ofNullable(clazz.cast(seasonality()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PeriodsForward", PERIODS_FORWARD_FIELD);
        map.put("PeriodsBackward", PERIODS_BACKWARD_FIELD);
        map.put("UpperBoundary", UPPER_BOUNDARY_FIELD);
        map.put("LowerBoundary", LOWER_BOUNDARY_FIELD);
        map.put("PredictionInterval", PREDICTION_INTERVAL_FIELD);
        map.put("Seasonality", SEASONALITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeBasedForecastProperties, T> g) {
        return obj -> g.apply((TimeBasedForecastProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeBasedForecastProperties> {
        /**
         * <p>
         * The periods forward setup of a forecast computation.
         * </p>
         * 
         * @param periodsForward
         *        The periods forward setup of a forecast computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodsForward(Integer periodsForward);

        /**
         * <p>
         * The periods backward setup of a forecast computation.
         * </p>
         * 
         * @param periodsBackward
         *        The periods backward setup of a forecast computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodsBackward(Integer periodsBackward);

        /**
         * <p>
         * The upper boundary setup of a forecast computation.
         * </p>
         * 
         * @param upperBoundary
         *        The upper boundary setup of a forecast computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upperBoundary(Double upperBoundary);

        /**
         * <p>
         * The lower boundary setup of a forecast computation.
         * </p>
         * 
         * @param lowerBoundary
         *        The lower boundary setup of a forecast computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowerBoundary(Double lowerBoundary);

        /**
         * <p>
         * The prediction interval setup of a forecast computation.
         * </p>
         * 
         * @param predictionInterval
         *        The prediction interval setup of a forecast computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionInterval(Integer predictionInterval);

        /**
         * <p>
         * The seasonality setup of a forecast computation. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NULL</code>: The input is set to <code>NULL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_NULL</code>: The input is set to a custom value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param seasonality
         *        The seasonality setup of a forecast computation. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NULL</code>: The input is set to <code>NULL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_NULL</code>: The input is set to a custom value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seasonality(Integer seasonality);
    }

    static final class BuilderImpl implements Builder {
        private Integer periodsForward;

        private Integer periodsBackward;

        private Double upperBoundary;

        private Double lowerBoundary;

        private Integer predictionInterval;

        private Integer seasonality;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeBasedForecastProperties model) {
            periodsForward(model.periodsForward);
            periodsBackward(model.periodsBackward);
            upperBoundary(model.upperBoundary);
            lowerBoundary(model.lowerBoundary);
            predictionInterval(model.predictionInterval);
            seasonality(model.seasonality);
        }

        public final Integer getPeriodsForward() {
            return periodsForward;
        }

        public final void setPeriodsForward(Integer periodsForward) {
            this.periodsForward = periodsForward;
        }

        @Override
        public final Builder periodsForward(Integer periodsForward) {
            this.periodsForward = periodsForward;
            return this;
        }

        public final Integer getPeriodsBackward() {
            return periodsBackward;
        }

        public final void setPeriodsBackward(Integer periodsBackward) {
            this.periodsBackward = periodsBackward;
        }

        @Override
        public final Builder periodsBackward(Integer periodsBackward) {
            this.periodsBackward = periodsBackward;
            return this;
        }

        public final Double getUpperBoundary() {
            return upperBoundary;
        }

        public final void setUpperBoundary(Double upperBoundary) {
            this.upperBoundary = upperBoundary;
        }

        @Override
        public final Builder upperBoundary(Double upperBoundary) {
            this.upperBoundary = upperBoundary;
            return this;
        }

        public final Double getLowerBoundary() {
            return lowerBoundary;
        }

        public final void setLowerBoundary(Double lowerBoundary) {
            this.lowerBoundary = lowerBoundary;
        }

        @Override
        public final Builder lowerBoundary(Double lowerBoundary) {
            this.lowerBoundary = lowerBoundary;
            return this;
        }

        public final Integer getPredictionInterval() {
            return predictionInterval;
        }

        public final void setPredictionInterval(Integer predictionInterval) {
            this.predictionInterval = predictionInterval;
        }

        @Override
        public final Builder predictionInterval(Integer predictionInterval) {
            this.predictionInterval = predictionInterval;
            return this;
        }

        public final Integer getSeasonality() {
            return seasonality;
        }

        public final void setSeasonality(Integer seasonality) {
            this.seasonality = seasonality;
        }

        @Override
        public final Builder seasonality(Integer seasonality) {
            this.seasonality = seasonality;
            return this;
        }

        @Override
        public TimeBasedForecastProperties build() {
            return new TimeBasedForecastProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
