/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An alias for a theme.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThemeAlias implements SdkPojo, Serializable, ToCopyableBuilder<ThemeAlias.Builder, ThemeAlias> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ThemeAlias::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasName").getter(getter(ThemeAlias::aliasName)).setter(setter(Builder::aliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasName").build()).build();

    private static final SdkField<Long> THEME_VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ThemeVersionNumber").getter(getter(ThemeAlias::themeVersionNumber))
            .setter(setter(Builder::themeVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeVersionNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ALIAS_NAME_FIELD,
            THEME_VERSION_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String aliasName;

    private final Long themeVersionNumber;

    private ThemeAlias(BuilderImpl builder) {
        this.arn = builder.arn;
        this.aliasName = builder.aliasName;
        this.themeVersionNumber = builder.themeVersionNumber;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the theme alias.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the theme alias.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The display name of the theme alias.
     * </p>
     * 
     * @return The display name of the theme alias.
     */
    public final String aliasName() {
        return aliasName;
    }

    /**
     * <p>
     * The version number of the theme alias.
     * </p>
     * 
     * @return The version number of the theme alias.
     */
    public final Long themeVersionNumber() {
        return themeVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(themeVersionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThemeAlias)) {
            return false;
        }
        ThemeAlias other = (ThemeAlias) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(aliasName(), other.aliasName())
                && Objects.equals(themeVersionNumber(), other.themeVersionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThemeAlias").add("Arn", arn()).add("AliasName", aliasName())
                .add("ThemeVersionNumber", themeVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AliasName":
            return Optional.ofNullable(clazz.cast(aliasName()));
        case "ThemeVersionNumber":
            return Optional.ofNullable(clazz.cast(themeVersionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("AliasName", ALIAS_NAME_FIELD);
        map.put("ThemeVersionNumber", THEME_VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThemeAlias, T> g) {
        return obj -> g.apply((ThemeAlias) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThemeAlias> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the theme alias.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the theme alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The display name of the theme alias.
         * </p>
         * 
         * @param aliasName
         *        The display name of the theme alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasName(String aliasName);

        /**
         * <p>
         * The version number of the theme alias.
         * </p>
         * 
         * @param themeVersionNumber
         *        The version number of the theme alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeVersionNumber(Long themeVersionNumber);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String aliasName;

        private Long themeVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(ThemeAlias model) {
            arn(model.arn);
            aliasName(model.aliasName);
            themeVersionNumber(model.themeVersionNumber);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAliasName() {
            return aliasName;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final Long getThemeVersionNumber() {
            return themeVersionNumber;
        }

        public final void setThemeVersionNumber(Long themeVersionNumber) {
            this.themeVersionNumber = themeVersionNumber;
        }

        @Override
        public final Builder themeVersionNumber(Long themeVersionNumber) {
            this.themeVersionNumber = themeVersionNumber;
            return this;
        }

        @Override
        public ThemeAlias build() {
            return new ThemeAlias(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
