/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The table style target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableStyleTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<TableStyleTarget.Builder, TableStyleTarget> {
    private static final SdkField<String> CELL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CellType").getter(getter(TableStyleTarget::cellTypeAsString)).setter(setter(Builder::cellType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELL_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cellType;

    private TableStyleTarget(BuilderImpl builder) {
        this.cellType = builder.cellType;
    }

    /**
     * <p>
     * The cell type of the table style target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cellType} will
     * return {@link StyledCellType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cellTypeAsString}.
     * </p>
     * 
     * @return The cell type of the table style target.
     * @see StyledCellType
     */
    public final StyledCellType cellType() {
        return StyledCellType.fromValue(cellType);
    }

    /**
     * <p>
     * The cell type of the table style target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cellType} will
     * return {@link StyledCellType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cellTypeAsString}.
     * </p>
     * 
     * @return The cell type of the table style target.
     * @see StyledCellType
     */
    public final String cellTypeAsString() {
        return cellType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cellTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableStyleTarget)) {
            return false;
        }
        TableStyleTarget other = (TableStyleTarget) obj;
        return Objects.equals(cellTypeAsString(), other.cellTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableStyleTarget").add("CellType", cellTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CellType":
            return Optional.ofNullable(clazz.cast(cellTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CellType", CELL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableStyleTarget, T> g) {
        return obj -> g.apply((TableStyleTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableStyleTarget> {
        /**
         * <p>
         * The cell type of the table style target.
         * </p>
         * 
         * @param cellType
         *        The cell type of the table style target.
         * @see StyledCellType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StyledCellType
         */
        Builder cellType(String cellType);

        /**
         * <p>
         * The cell type of the table style target.
         * </p>
         * 
         * @param cellType
         *        The cell type of the table style target.
         * @see StyledCellType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StyledCellType
         */
        Builder cellType(StyledCellType cellType);
    }

    static final class BuilderImpl implements Builder {
        private String cellType;

        private BuilderImpl() {
        }

        private BuilderImpl(TableStyleTarget model) {
            cellType(model.cellType);
        }

        public final String getCellType() {
            return cellType;
        }

        public final void setCellType(String cellType) {
            this.cellType = cellType;
        }

        @Override
        public final Builder cellType(String cellType) {
            this.cellType = cellType;
            return this;
        }

        @Override
        public final Builder cellType(StyledCellType cellType) {
            this.cellType(cellType == null ? null : cellType.toString());
            return this;
        }

        @Override
        public TableStyleTarget build() {
            return new TableStyleTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
