/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The conditional formatting of a table row.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableRowConditionalFormatting implements SdkPojo, Serializable,
        ToCopyableBuilder<TableRowConditionalFormatting.Builder, TableRowConditionalFormatting> {
    private static final SdkField<ConditionalFormattingColor> BACKGROUND_COLOR_FIELD = SdkField
            .<ConditionalFormattingColor> builder(MarshallingType.SDK_POJO).memberName("BackgroundColor")
            .getter(getter(TableRowConditionalFormatting::backgroundColor)).setter(setter(Builder::backgroundColor))
            .constructor(ConditionalFormattingColor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundColor").build()).build();

    private static final SdkField<ConditionalFormattingColor> TEXT_COLOR_FIELD = SdkField
            .<ConditionalFormattingColor> builder(MarshallingType.SDK_POJO).memberName("TextColor")
            .getter(getter(TableRowConditionalFormatting::textColor)).setter(setter(Builder::textColor))
            .constructor(ConditionalFormattingColor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextColor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKGROUND_COLOR_FIELD,
            TEXT_COLOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConditionalFormattingColor backgroundColor;

    private final ConditionalFormattingColor textColor;

    private TableRowConditionalFormatting(BuilderImpl builder) {
        this.backgroundColor = builder.backgroundColor;
        this.textColor = builder.textColor;
    }

    /**
     * <p>
     * The conditional formatting color (solid, gradient) of the background for a table row.
     * </p>
     * 
     * @return The conditional formatting color (solid, gradient) of the background for a table row.
     */
    public final ConditionalFormattingColor backgroundColor() {
        return backgroundColor;
    }

    /**
     * <p>
     * The conditional formatting color (solid, gradient) of the text for a table row.
     * </p>
     * 
     * @return The conditional formatting color (solid, gradient) of the text for a table row.
     */
    public final ConditionalFormattingColor textColor() {
        return textColor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backgroundColor());
        hashCode = 31 * hashCode + Objects.hashCode(textColor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableRowConditionalFormatting)) {
            return false;
        }
        TableRowConditionalFormatting other = (TableRowConditionalFormatting) obj;
        return Objects.equals(backgroundColor(), other.backgroundColor()) && Objects.equals(textColor(), other.textColor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableRowConditionalFormatting").add("BackgroundColor", backgroundColor())
                .add("TextColor", textColor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackgroundColor":
            return Optional.ofNullable(clazz.cast(backgroundColor()));
        case "TextColor":
            return Optional.ofNullable(clazz.cast(textColor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackgroundColor", BACKGROUND_COLOR_FIELD);
        map.put("TextColor", TEXT_COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableRowConditionalFormatting, T> g) {
        return obj -> g.apply((TableRowConditionalFormatting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableRowConditionalFormatting> {
        /**
         * <p>
         * The conditional formatting color (solid, gradient) of the background for a table row.
         * </p>
         * 
         * @param backgroundColor
         *        The conditional formatting color (solid, gradient) of the background for a table row.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backgroundColor(ConditionalFormattingColor backgroundColor);

        /**
         * <p>
         * The conditional formatting color (solid, gradient) of the background for a table row.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionalFormattingColor.Builder}
         * avoiding the need to create one manually via {@link ConditionalFormattingColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalFormattingColor.Builder#build()} is called immediately
         * and its result is passed to {@link #backgroundColor(ConditionalFormattingColor)}.
         * 
         * @param backgroundColor
         *        a consumer that will call methods on {@link ConditionalFormattingColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backgroundColor(ConditionalFormattingColor)
         */
        default Builder backgroundColor(Consumer<ConditionalFormattingColor.Builder> backgroundColor) {
            return backgroundColor(ConditionalFormattingColor.builder().applyMutation(backgroundColor).build());
        }

        /**
         * <p>
         * The conditional formatting color (solid, gradient) of the text for a table row.
         * </p>
         * 
         * @param textColor
         *        The conditional formatting color (solid, gradient) of the text for a table row.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textColor(ConditionalFormattingColor textColor);

        /**
         * <p>
         * The conditional formatting color (solid, gradient) of the text for a table row.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionalFormattingColor.Builder}
         * avoiding the need to create one manually via {@link ConditionalFormattingColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalFormattingColor.Builder#build()} is called immediately
         * and its result is passed to {@link #textColor(ConditionalFormattingColor)}.
         * 
         * @param textColor
         *        a consumer that will call methods on {@link ConditionalFormattingColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textColor(ConditionalFormattingColor)
         */
        default Builder textColor(Consumer<ConditionalFormattingColor.Builder> textColor) {
            return textColor(ConditionalFormattingColor.builder().applyMutation(textColor).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConditionalFormattingColor backgroundColor;

        private ConditionalFormattingColor textColor;

        private BuilderImpl() {
        }

        private BuilderImpl(TableRowConditionalFormatting model) {
            backgroundColor(model.backgroundColor);
            textColor(model.textColor);
        }

        public final ConditionalFormattingColor.Builder getBackgroundColor() {
            return backgroundColor != null ? backgroundColor.toBuilder() : null;
        }

        public final void setBackgroundColor(ConditionalFormattingColor.BuilderImpl backgroundColor) {
            this.backgroundColor = backgroundColor != null ? backgroundColor.build() : null;
        }

        @Override
        public final Builder backgroundColor(ConditionalFormattingColor backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public final ConditionalFormattingColor.Builder getTextColor() {
            return textColor != null ? textColor.toBuilder() : null;
        }

        public final void setTextColor(ConditionalFormattingColor.BuilderImpl textColor) {
            this.textColor = textColor != null ? textColor.build() : null;
        }

        @Override
        public final Builder textColor(ConditionalFormattingColor textColor) {
            this.textColor = textColor;
            return this;
        }

        @Override
        public TableRowConditionalFormatting build() {
            return new TableRowConditionalFormatting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
