/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for a table field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableFieldOption implements SdkPojo, Serializable,
        ToCopyableBuilder<TableFieldOption.Builder, TableFieldOption> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldId").getter(getter(TableFieldOption::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()).build();

    private static final SdkField<String> WIDTH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Width")
            .getter(getter(TableFieldOption::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()).build();

    private static final SdkField<String> CUSTOM_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomLabel").getter(getter(TableFieldOption::customLabel)).setter(setter(Builder::customLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabel").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(TableFieldOption::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<TableFieldURLConfiguration> URL_STYLING_FIELD = SdkField
            .<TableFieldURLConfiguration> builder(MarshallingType.SDK_POJO).memberName("URLStyling")
            .getter(getter(TableFieldOption::urlStyling)).setter(setter(Builder::urlStyling))
            .constructor(TableFieldURLConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URLStyling").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD, WIDTH_FIELD,
            CUSTOM_LABEL_FIELD, VISIBILITY_FIELD, URL_STYLING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldId;

    private final String width;

    private final String customLabel;

    private final String visibility;

    private final TableFieldURLConfiguration urlStyling;

    private TableFieldOption(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.width = builder.width;
        this.customLabel = builder.customLabel;
        this.visibility = builder.visibility;
        this.urlStyling = builder.urlStyling;
    }

    /**
     * <p>
     * The field ID for a table field.
     * </p>
     * 
     * @return The field ID for a table field.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * <p>
     * The width for a table field.
     * </p>
     * 
     * @return The width for a table field.
     */
    public final String width() {
        return width;
    }

    /**
     * <p>
     * The custom label for a table field.
     * </p>
     * 
     * @return The custom label for a table field.
     */
    public final String customLabel() {
        return customLabel;
    }

    /**
     * <p>
     * The visibility of a table field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of a table field.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility of a table field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of a table field.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The URL configuration for a table field.
     * </p>
     * 
     * @return The URL configuration for a table field.
     */
    public final TableFieldURLConfiguration urlStyling() {
        return urlStyling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        hashCode = 31 * hashCode + Objects.hashCode(customLabel());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(urlStyling());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableFieldOption)) {
            return false;
        }
        TableFieldOption other = (TableFieldOption) obj;
        return Objects.equals(fieldId(), other.fieldId()) && Objects.equals(width(), other.width())
                && Objects.equals(customLabel(), other.customLabel())
                && Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(urlStyling(), other.urlStyling());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableFieldOption").add("FieldId", fieldId()).add("Width", width())
                .add("CustomLabel", customLabel()).add("Visibility", visibilityAsString()).add("URLStyling", urlStyling())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        case "CustomLabel":
            return Optional.ofNullable(clazz.cast(customLabel()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "URLStyling":
            return Optional.ofNullable(clazz.cast(urlStyling()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldId", FIELD_ID_FIELD);
        map.put("Width", WIDTH_FIELD);
        map.put("CustomLabel", CUSTOM_LABEL_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("URLStyling", URL_STYLING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableFieldOption, T> g) {
        return obj -> g.apply((TableFieldOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableFieldOption> {
        /**
         * <p>
         * The field ID for a table field.
         * </p>
         * 
         * @param fieldId
         *        The field ID for a table field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * The width for a table field.
         * </p>
         * 
         * @param width
         *        The width for a table field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(String width);

        /**
         * <p>
         * The custom label for a table field.
         * </p>
         * 
         * @param customLabel
         *        The custom label for a table field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLabel(String customLabel);

        /**
         * <p>
         * The visibility of a table field.
         * </p>
         * 
         * @param visibility
         *        The visibility of a table field.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of a table field.
         * </p>
         * 
         * @param visibility
         *        The visibility of a table field.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The URL configuration for a table field.
         * </p>
         * 
         * @param urlStyling
         *        The URL configuration for a table field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlStyling(TableFieldURLConfiguration urlStyling);

        /**
         * <p>
         * The URL configuration for a table field.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableFieldURLConfiguration.Builder}
         * avoiding the need to create one manually via {@link TableFieldURLConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableFieldURLConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #urlStyling(TableFieldURLConfiguration)}.
         * 
         * @param urlStyling
         *        a consumer that will call methods on {@link TableFieldURLConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #urlStyling(TableFieldURLConfiguration)
         */
        default Builder urlStyling(Consumer<TableFieldURLConfiguration.Builder> urlStyling) {
            return urlStyling(TableFieldURLConfiguration.builder().applyMutation(urlStyling).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fieldId;

        private String width;

        private String customLabel;

        private String visibility;

        private TableFieldURLConfiguration urlStyling;

        private BuilderImpl() {
        }

        private BuilderImpl(TableFieldOption model) {
            fieldId(model.fieldId);
            width(model.width);
            customLabel(model.customLabel);
            visibility(model.visibility);
            urlStyling(model.urlStyling);
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getWidth() {
            return width;
        }

        public final void setWidth(String width) {
            this.width = width;
        }

        @Override
        public final Builder width(String width) {
            this.width = width;
            return this;
        }

        public final String getCustomLabel() {
            return customLabel;
        }

        public final void setCustomLabel(String customLabel) {
            this.customLabel = customLabel;
        }

        @Override
        public final Builder customLabel(String customLabel) {
            this.customLabel = customLabel;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final TableFieldURLConfiguration.Builder getUrlStyling() {
            return urlStyling != null ? urlStyling.toBuilder() : null;
        }

        public final void setUrlStyling(TableFieldURLConfiguration.BuilderImpl urlStyling) {
            this.urlStyling = urlStyling != null ? urlStyling.build() : null;
        }

        @Override
        public final Builder urlStyling(TableFieldURLConfiguration urlStyling) {
            this.urlStyling = urlStyling;
            return this;
        }

        @Override
        public TableFieldOption build() {
            return new TableFieldOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
