/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The subtotal options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubtotalOptions implements SdkPojo, Serializable, ToCopyableBuilder<SubtotalOptions.Builder, SubtotalOptions> {
    private static final SdkField<String> TOTALS_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TotalsVisibility").getter(getter(SubtotalOptions::totalsVisibilityAsString))
            .setter(setter(Builder::totalsVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalsVisibility").build()).build();

    private static final SdkField<String> CUSTOM_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomLabel").getter(getter(SubtotalOptions::customLabel)).setter(setter(Builder::customLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabel").build()).build();

    private static final SdkField<String> FIELD_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldLevel").getter(getter(SubtotalOptions::fieldLevelAsString)).setter(setter(Builder::fieldLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevel").build()).build();

    private static final SdkField<List<PivotTableFieldSubtotalOptions>> FIELD_LEVEL_OPTIONS_FIELD = SdkField
            .<List<PivotTableFieldSubtotalOptions>> builder(MarshallingType.LIST)
            .memberName("FieldLevelOptions")
            .getter(getter(SubtotalOptions::fieldLevelOptions))
            .setter(setter(Builder::fieldLevelOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PivotTableFieldSubtotalOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(PivotTableFieldSubtotalOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TableCellStyle> TOTAL_CELL_STYLE_FIELD = SdkField
            .<TableCellStyle> builder(MarshallingType.SDK_POJO).memberName("TotalCellStyle")
            .getter(getter(SubtotalOptions::totalCellStyle)).setter(setter(Builder::totalCellStyle))
            .constructor(TableCellStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCellStyle").build()).build();

    private static final SdkField<TableCellStyle> VALUE_CELL_STYLE_FIELD = SdkField
            .<TableCellStyle> builder(MarshallingType.SDK_POJO).memberName("ValueCellStyle")
            .getter(getter(SubtotalOptions::valueCellStyle)).setter(setter(Builder::valueCellStyle))
            .constructor(TableCellStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueCellStyle").build()).build();

    private static final SdkField<TableCellStyle> METRIC_HEADER_CELL_STYLE_FIELD = SdkField
            .<TableCellStyle> builder(MarshallingType.SDK_POJO).memberName("MetricHeaderCellStyle")
            .getter(getter(SubtotalOptions::metricHeaderCellStyle)).setter(setter(Builder::metricHeaderCellStyle))
            .constructor(TableCellStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricHeaderCellStyle").build())
            .build();

    private static final SdkField<List<TableStyleTarget>> STYLE_TARGETS_FIELD = SdkField
            .<List<TableStyleTarget>> builder(MarshallingType.LIST)
            .memberName("StyleTargets")
            .getter(getter(SubtotalOptions::styleTargets))
            .setter(setter(Builder::styleTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StyleTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableStyleTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableStyleTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTALS_VISIBILITY_FIELD,
            CUSTOM_LABEL_FIELD, FIELD_LEVEL_FIELD, FIELD_LEVEL_OPTIONS_FIELD, TOTAL_CELL_STYLE_FIELD, VALUE_CELL_STYLE_FIELD,
            METRIC_HEADER_CELL_STYLE_FIELD, STYLE_TARGETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String totalsVisibility;

    private final String customLabel;

    private final String fieldLevel;

    private final List<PivotTableFieldSubtotalOptions> fieldLevelOptions;

    private final TableCellStyle totalCellStyle;

    private final TableCellStyle valueCellStyle;

    private final TableCellStyle metricHeaderCellStyle;

    private final List<TableStyleTarget> styleTargets;

    private SubtotalOptions(BuilderImpl builder) {
        this.totalsVisibility = builder.totalsVisibility;
        this.customLabel = builder.customLabel;
        this.fieldLevel = builder.fieldLevel;
        this.fieldLevelOptions = builder.fieldLevelOptions;
        this.totalCellStyle = builder.totalCellStyle;
        this.valueCellStyle = builder.valueCellStyle;
        this.metricHeaderCellStyle = builder.metricHeaderCellStyle;
        this.styleTargets = builder.styleTargets;
    }

    /**
     * <p>
     * The visibility configuration for the subtotal cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #totalsVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #totalsVisibilityAsString}.
     * </p>
     * 
     * @return The visibility configuration for the subtotal cells.
     * @see Visibility
     */
    public final Visibility totalsVisibility() {
        return Visibility.fromValue(totalsVisibility);
    }

    /**
     * <p>
     * The visibility configuration for the subtotal cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #totalsVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #totalsVisibilityAsString}.
     * </p>
     * 
     * @return The visibility configuration for the subtotal cells.
     * @see Visibility
     */
    public final String totalsVisibilityAsString() {
        return totalsVisibility;
    }

    /**
     * <p>
     * The custom label string for the subtotal cells.
     * </p>
     * 
     * @return The custom label string for the subtotal cells.
     */
    public final String customLabel() {
        return customLabel;
    }

    /**
     * <p>
     * The field level (all, custom, last) for the subtotal cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldLevel} will
     * return {@link PivotTableSubtotalLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fieldLevelAsString}.
     * </p>
     * 
     * @return The field level (all, custom, last) for the subtotal cells.
     * @see PivotTableSubtotalLevel
     */
    public final PivotTableSubtotalLevel fieldLevel() {
        return PivotTableSubtotalLevel.fromValue(fieldLevel);
    }

    /**
     * <p>
     * The field level (all, custom, last) for the subtotal cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldLevel} will
     * return {@link PivotTableSubtotalLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fieldLevelAsString}.
     * </p>
     * 
     * @return The field level (all, custom, last) for the subtotal cells.
     * @see PivotTableSubtotalLevel
     */
    public final String fieldLevelAsString() {
        return fieldLevel;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldLevelOptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldLevelOptions() {
        return fieldLevelOptions != null && !(fieldLevelOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The optional configuration of subtotal cells.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldLevelOptions} method.
     * </p>
     * 
     * @return The optional configuration of subtotal cells.
     */
    public final List<PivotTableFieldSubtotalOptions> fieldLevelOptions() {
        return fieldLevelOptions;
    }

    /**
     * <p>
     * The cell styling options for the subtotal cells.
     * </p>
     * 
     * @return The cell styling options for the subtotal cells.
     */
    public final TableCellStyle totalCellStyle() {
        return totalCellStyle;
    }

    /**
     * <p>
     * The cell styling options for the subtotals of value cells.
     * </p>
     * 
     * @return The cell styling options for the subtotals of value cells.
     */
    public final TableCellStyle valueCellStyle() {
        return valueCellStyle;
    }

    /**
     * <p>
     * The cell styling options for the subtotals of header cells.
     * </p>
     * 
     * @return The cell styling options for the subtotals of header cells.
     */
    public final TableCellStyle metricHeaderCellStyle() {
        return metricHeaderCellStyle;
    }

    /**
     * For responses, this returns true if the service returned a value for the StyleTargets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStyleTargets() {
        return styleTargets != null && !(styleTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The style targets options for subtotals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStyleTargets} method.
     * </p>
     * 
     * @return The style targets options for subtotals.
     */
    public final List<TableStyleTarget> styleTargets() {
        return styleTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalsVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customLabel());
        hashCode = 31 * hashCode + Objects.hashCode(fieldLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldLevelOptions() ? fieldLevelOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalCellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(valueCellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(metricHeaderCellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(hasStyleTargets() ? styleTargets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubtotalOptions)) {
            return false;
        }
        SubtotalOptions other = (SubtotalOptions) obj;
        return Objects.equals(totalsVisibilityAsString(), other.totalsVisibilityAsString())
                && Objects.equals(customLabel(), other.customLabel())
                && Objects.equals(fieldLevelAsString(), other.fieldLevelAsString())
                && hasFieldLevelOptions() == other.hasFieldLevelOptions()
                && Objects.equals(fieldLevelOptions(), other.fieldLevelOptions())
                && Objects.equals(totalCellStyle(), other.totalCellStyle())
                && Objects.equals(valueCellStyle(), other.valueCellStyle())
                && Objects.equals(metricHeaderCellStyle(), other.metricHeaderCellStyle())
                && hasStyleTargets() == other.hasStyleTargets() && Objects.equals(styleTargets(), other.styleTargets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubtotalOptions").add("TotalsVisibility", totalsVisibilityAsString())
                .add("CustomLabel", customLabel()).add("FieldLevel", fieldLevelAsString())
                .add("FieldLevelOptions", hasFieldLevelOptions() ? fieldLevelOptions() : null)
                .add("TotalCellStyle", totalCellStyle()).add("ValueCellStyle", valueCellStyle())
                .add("MetricHeaderCellStyle", metricHeaderCellStyle())
                .add("StyleTargets", hasStyleTargets() ? styleTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalsVisibility":
            return Optional.ofNullable(clazz.cast(totalsVisibilityAsString()));
        case "CustomLabel":
            return Optional.ofNullable(clazz.cast(customLabel()));
        case "FieldLevel":
            return Optional.ofNullable(clazz.cast(fieldLevelAsString()));
        case "FieldLevelOptions":
            return Optional.ofNullable(clazz.cast(fieldLevelOptions()));
        case "TotalCellStyle":
            return Optional.ofNullable(clazz.cast(totalCellStyle()));
        case "ValueCellStyle":
            return Optional.ofNullable(clazz.cast(valueCellStyle()));
        case "MetricHeaderCellStyle":
            return Optional.ofNullable(clazz.cast(metricHeaderCellStyle()));
        case "StyleTargets":
            return Optional.ofNullable(clazz.cast(styleTargets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TotalsVisibility", TOTALS_VISIBILITY_FIELD);
        map.put("CustomLabel", CUSTOM_LABEL_FIELD);
        map.put("FieldLevel", FIELD_LEVEL_FIELD);
        map.put("FieldLevelOptions", FIELD_LEVEL_OPTIONS_FIELD);
        map.put("TotalCellStyle", TOTAL_CELL_STYLE_FIELD);
        map.put("ValueCellStyle", VALUE_CELL_STYLE_FIELD);
        map.put("MetricHeaderCellStyle", METRIC_HEADER_CELL_STYLE_FIELD);
        map.put("StyleTargets", STYLE_TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubtotalOptions, T> g) {
        return obj -> g.apply((SubtotalOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubtotalOptions> {
        /**
         * <p>
         * The visibility configuration for the subtotal cells.
         * </p>
         * 
         * @param totalsVisibility
         *        The visibility configuration for the subtotal cells.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder totalsVisibility(String totalsVisibility);

        /**
         * <p>
         * The visibility configuration for the subtotal cells.
         * </p>
         * 
         * @param totalsVisibility
         *        The visibility configuration for the subtotal cells.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder totalsVisibility(Visibility totalsVisibility);

        /**
         * <p>
         * The custom label string for the subtotal cells.
         * </p>
         * 
         * @param customLabel
         *        The custom label string for the subtotal cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLabel(String customLabel);

        /**
         * <p>
         * The field level (all, custom, last) for the subtotal cells.
         * </p>
         * 
         * @param fieldLevel
         *        The field level (all, custom, last) for the subtotal cells.
         * @see PivotTableSubtotalLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PivotTableSubtotalLevel
         */
        Builder fieldLevel(String fieldLevel);

        /**
         * <p>
         * The field level (all, custom, last) for the subtotal cells.
         * </p>
         * 
         * @param fieldLevel
         *        The field level (all, custom, last) for the subtotal cells.
         * @see PivotTableSubtotalLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PivotTableSubtotalLevel
         */
        Builder fieldLevel(PivotTableSubtotalLevel fieldLevel);

        /**
         * <p>
         * The optional configuration of subtotal cells.
         * </p>
         * 
         * @param fieldLevelOptions
         *        The optional configuration of subtotal cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLevelOptions(Collection<PivotTableFieldSubtotalOptions> fieldLevelOptions);

        /**
         * <p>
         * The optional configuration of subtotal cells.
         * </p>
         * 
         * @param fieldLevelOptions
         *        The optional configuration of subtotal cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLevelOptions(PivotTableFieldSubtotalOptions... fieldLevelOptions);

        /**
         * <p>
         * The optional configuration of subtotal cells.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.PivotTableFieldSubtotalOptions.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.PivotTableFieldSubtotalOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.PivotTableFieldSubtotalOptions.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #fieldLevelOptions(List<PivotTableFieldSubtotalOptions>)}.
         * 
         * @param fieldLevelOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.PivotTableFieldSubtotalOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldLevelOptions(java.util.Collection<PivotTableFieldSubtotalOptions>)
         */
        Builder fieldLevelOptions(Consumer<PivotTableFieldSubtotalOptions.Builder>... fieldLevelOptions);

        /**
         * <p>
         * The cell styling options for the subtotal cells.
         * </p>
         * 
         * @param totalCellStyle
         *        The cell styling options for the subtotal cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCellStyle(TableCellStyle totalCellStyle);

        /**
         * <p>
         * The cell styling options for the subtotal cells.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCellStyle.Builder} avoiding the need
         * to create one manually via {@link TableCellStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCellStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #totalCellStyle(TableCellStyle)}.
         * 
         * @param totalCellStyle
         *        a consumer that will call methods on {@link TableCellStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #totalCellStyle(TableCellStyle)
         */
        default Builder totalCellStyle(Consumer<TableCellStyle.Builder> totalCellStyle) {
            return totalCellStyle(TableCellStyle.builder().applyMutation(totalCellStyle).build());
        }

        /**
         * <p>
         * The cell styling options for the subtotals of value cells.
         * </p>
         * 
         * @param valueCellStyle
         *        The cell styling options for the subtotals of value cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueCellStyle(TableCellStyle valueCellStyle);

        /**
         * <p>
         * The cell styling options for the subtotals of value cells.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCellStyle.Builder} avoiding the need
         * to create one manually via {@link TableCellStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCellStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #valueCellStyle(TableCellStyle)}.
         * 
         * @param valueCellStyle
         *        a consumer that will call methods on {@link TableCellStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueCellStyle(TableCellStyle)
         */
        default Builder valueCellStyle(Consumer<TableCellStyle.Builder> valueCellStyle) {
            return valueCellStyle(TableCellStyle.builder().applyMutation(valueCellStyle).build());
        }

        /**
         * <p>
         * The cell styling options for the subtotals of header cells.
         * </p>
         * 
         * @param metricHeaderCellStyle
         *        The cell styling options for the subtotals of header cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricHeaderCellStyle(TableCellStyle metricHeaderCellStyle);

        /**
         * <p>
         * The cell styling options for the subtotals of header cells.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCellStyle.Builder} avoiding the need
         * to create one manually via {@link TableCellStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCellStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #metricHeaderCellStyle(TableCellStyle)}.
         * 
         * @param metricHeaderCellStyle
         *        a consumer that will call methods on {@link TableCellStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricHeaderCellStyle(TableCellStyle)
         */
        default Builder metricHeaderCellStyle(Consumer<TableCellStyle.Builder> metricHeaderCellStyle) {
            return metricHeaderCellStyle(TableCellStyle.builder().applyMutation(metricHeaderCellStyle).build());
        }

        /**
         * <p>
         * The style targets options for subtotals.
         * </p>
         * 
         * @param styleTargets
         *        The style targets options for subtotals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder styleTargets(Collection<TableStyleTarget> styleTargets);

        /**
         * <p>
         * The style targets options for subtotals.
         * </p>
         * 
         * @param styleTargets
         *        The style targets options for subtotals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder styleTargets(TableStyleTarget... styleTargets);

        /**
         * <p>
         * The style targets options for subtotals.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TableStyleTarget.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.TableStyleTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TableStyleTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #styleTargets(List<TableStyleTarget>)}.
         * 
         * @param styleTargets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TableStyleTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #styleTargets(java.util.Collection<TableStyleTarget>)
         */
        Builder styleTargets(Consumer<TableStyleTarget.Builder>... styleTargets);
    }

    static final class BuilderImpl implements Builder {
        private String totalsVisibility;

        private String customLabel;

        private String fieldLevel;

        private List<PivotTableFieldSubtotalOptions> fieldLevelOptions = DefaultSdkAutoConstructList.getInstance();

        private TableCellStyle totalCellStyle;

        private TableCellStyle valueCellStyle;

        private TableCellStyle metricHeaderCellStyle;

        private List<TableStyleTarget> styleTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubtotalOptions model) {
            totalsVisibility(model.totalsVisibility);
            customLabel(model.customLabel);
            fieldLevel(model.fieldLevel);
            fieldLevelOptions(model.fieldLevelOptions);
            totalCellStyle(model.totalCellStyle);
            valueCellStyle(model.valueCellStyle);
            metricHeaderCellStyle(model.metricHeaderCellStyle);
            styleTargets(model.styleTargets);
        }

        public final String getTotalsVisibility() {
            return totalsVisibility;
        }

        public final void setTotalsVisibility(String totalsVisibility) {
            this.totalsVisibility = totalsVisibility;
        }

        @Override
        public final Builder totalsVisibility(String totalsVisibility) {
            this.totalsVisibility = totalsVisibility;
            return this;
        }

        @Override
        public final Builder totalsVisibility(Visibility totalsVisibility) {
            this.totalsVisibility(totalsVisibility == null ? null : totalsVisibility.toString());
            return this;
        }

        public final String getCustomLabel() {
            return customLabel;
        }

        public final void setCustomLabel(String customLabel) {
            this.customLabel = customLabel;
        }

        @Override
        public final Builder customLabel(String customLabel) {
            this.customLabel = customLabel;
            return this;
        }

        public final String getFieldLevel() {
            return fieldLevel;
        }

        public final void setFieldLevel(String fieldLevel) {
            this.fieldLevel = fieldLevel;
        }

        @Override
        public final Builder fieldLevel(String fieldLevel) {
            this.fieldLevel = fieldLevel;
            return this;
        }

        @Override
        public final Builder fieldLevel(PivotTableSubtotalLevel fieldLevel) {
            this.fieldLevel(fieldLevel == null ? null : fieldLevel.toString());
            return this;
        }

        public final List<PivotTableFieldSubtotalOptions.Builder> getFieldLevelOptions() {
            List<PivotTableFieldSubtotalOptions.Builder> result = PivotTableFieldSubtotalOptionsListCopier
                    .copyToBuilder(this.fieldLevelOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldLevelOptions(Collection<PivotTableFieldSubtotalOptions.BuilderImpl> fieldLevelOptions) {
            this.fieldLevelOptions = PivotTableFieldSubtotalOptionsListCopier.copyFromBuilder(fieldLevelOptions);
        }

        @Override
        public final Builder fieldLevelOptions(Collection<PivotTableFieldSubtotalOptions> fieldLevelOptions) {
            this.fieldLevelOptions = PivotTableFieldSubtotalOptionsListCopier.copy(fieldLevelOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldLevelOptions(PivotTableFieldSubtotalOptions... fieldLevelOptions) {
            fieldLevelOptions(Arrays.asList(fieldLevelOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldLevelOptions(Consumer<PivotTableFieldSubtotalOptions.Builder>... fieldLevelOptions) {
            fieldLevelOptions(Stream.of(fieldLevelOptions)
                    .map(c -> PivotTableFieldSubtotalOptions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TableCellStyle.Builder getTotalCellStyle() {
            return totalCellStyle != null ? totalCellStyle.toBuilder() : null;
        }

        public final void setTotalCellStyle(TableCellStyle.BuilderImpl totalCellStyle) {
            this.totalCellStyle = totalCellStyle != null ? totalCellStyle.build() : null;
        }

        @Override
        public final Builder totalCellStyle(TableCellStyle totalCellStyle) {
            this.totalCellStyle = totalCellStyle;
            return this;
        }

        public final TableCellStyle.Builder getValueCellStyle() {
            return valueCellStyle != null ? valueCellStyle.toBuilder() : null;
        }

        public final void setValueCellStyle(TableCellStyle.BuilderImpl valueCellStyle) {
            this.valueCellStyle = valueCellStyle != null ? valueCellStyle.build() : null;
        }

        @Override
        public final Builder valueCellStyle(TableCellStyle valueCellStyle) {
            this.valueCellStyle = valueCellStyle;
            return this;
        }

        public final TableCellStyle.Builder getMetricHeaderCellStyle() {
            return metricHeaderCellStyle != null ? metricHeaderCellStyle.toBuilder() : null;
        }

        public final void setMetricHeaderCellStyle(TableCellStyle.BuilderImpl metricHeaderCellStyle) {
            this.metricHeaderCellStyle = metricHeaderCellStyle != null ? metricHeaderCellStyle.build() : null;
        }

        @Override
        public final Builder metricHeaderCellStyle(TableCellStyle metricHeaderCellStyle) {
            this.metricHeaderCellStyle = metricHeaderCellStyle;
            return this;
        }

        public final List<TableStyleTarget.Builder> getStyleTargets() {
            List<TableStyleTarget.Builder> result = TableStyleTargetListCopier.copyToBuilder(this.styleTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStyleTargets(Collection<TableStyleTarget.BuilderImpl> styleTargets) {
            this.styleTargets = TableStyleTargetListCopier.copyFromBuilder(styleTargets);
        }

        @Override
        public final Builder styleTargets(Collection<TableStyleTarget> styleTargets) {
            this.styleTargets = TableStyleTargetListCopier.copy(styleTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder styleTargets(TableStyleTarget... styleTargets) {
            styleTargets(Arrays.asList(styleTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder styleTargets(Consumer<TableStyleTarget.Builder>... styleTargets) {
            styleTargets(Stream.of(styleTargets).map(c -> TableStyleTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SubtotalOptions build() {
            return new SubtotalOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
