/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that defines the default value of a <code>String</code> parameter when a value has not been set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StringValueWhenUnsetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StringValueWhenUnsetConfiguration.Builder, StringValueWhenUnsetConfiguration> {
    private static final SdkField<String> VALUE_WHEN_UNSET_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueWhenUnsetOption").getter(getter(StringValueWhenUnsetConfiguration::valueWhenUnsetOptionAsString))
            .setter(setter(Builder::valueWhenUnsetOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueWhenUnsetOption").build())
            .build();

    private static final SdkField<String> CUSTOM_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomValue").getter(getter(StringValueWhenUnsetConfiguration::customValue))
            .setter(setter(Builder::customValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_WHEN_UNSET_OPTION_FIELD,
            CUSTOM_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String valueWhenUnsetOption;

    private final String customValue;

    private StringValueWhenUnsetConfiguration(BuilderImpl builder) {
        this.valueWhenUnsetOption = builder.valueWhenUnsetOption;
        this.customValue = builder.customValue;
    }

    /**
     * <p>
     * The built-in options for default values. The value can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RECOMMENDED</code>: The recommended value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NULL</code>: The <code>NULL</code> value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #valueWhenUnsetOption} will return {@link ValueWhenUnsetOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #valueWhenUnsetOptionAsString}.
     * </p>
     * 
     * @return The built-in options for default values. The value can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RECOMMENDED</code>: The recommended value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NULL</code>: The <code>NULL</code> value.
     *         </p>
     *         </li>
     * @see ValueWhenUnsetOption
     */
    public final ValueWhenUnsetOption valueWhenUnsetOption() {
        return ValueWhenUnsetOption.fromValue(valueWhenUnsetOption);
    }

    /**
     * <p>
     * The built-in options for default values. The value can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RECOMMENDED</code>: The recommended value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NULL</code>: The <code>NULL</code> value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #valueWhenUnsetOption} will return {@link ValueWhenUnsetOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #valueWhenUnsetOptionAsString}.
     * </p>
     * 
     * @return The built-in options for default values. The value can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RECOMMENDED</code>: The recommended value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NULL</code>: The <code>NULL</code> value.
     *         </p>
     *         </li>
     * @see ValueWhenUnsetOption
     */
    public final String valueWhenUnsetOptionAsString() {
        return valueWhenUnsetOption;
    }

    /**
     * <p>
     * A custom value that's used when the value of a parameter isn't set.
     * </p>
     * 
     * @return A custom value that's used when the value of a parameter isn't set.
     */
    public final String customValue() {
        return customValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(valueWhenUnsetOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringValueWhenUnsetConfiguration)) {
            return false;
        }
        StringValueWhenUnsetConfiguration other = (StringValueWhenUnsetConfiguration) obj;
        return Objects.equals(valueWhenUnsetOptionAsString(), other.valueWhenUnsetOptionAsString())
                && Objects.equals(customValue(), other.customValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StringValueWhenUnsetConfiguration").add("ValueWhenUnsetOption", valueWhenUnsetOptionAsString())
                .add("CustomValue", customValue() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ValueWhenUnsetOption":
            return Optional.ofNullable(clazz.cast(valueWhenUnsetOptionAsString()));
        case "CustomValue":
            return Optional.ofNullable(clazz.cast(customValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ValueWhenUnsetOption", VALUE_WHEN_UNSET_OPTION_FIELD);
        map.put("CustomValue", CUSTOM_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StringValueWhenUnsetConfiguration, T> g) {
        return obj -> g.apply((StringValueWhenUnsetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StringValueWhenUnsetConfiguration> {
        /**
         * <p>
         * The built-in options for default values. The value can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RECOMMENDED</code>: The recommended value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NULL</code>: The <code>NULL</code> value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param valueWhenUnsetOption
         *        The built-in options for default values. The value can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RECOMMENDED</code>: The recommended value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NULL</code>: The <code>NULL</code> value.
         *        </p>
         *        </li>
         * @see ValueWhenUnsetOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValueWhenUnsetOption
         */
        Builder valueWhenUnsetOption(String valueWhenUnsetOption);

        /**
         * <p>
         * The built-in options for default values. The value can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RECOMMENDED</code>: The recommended value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NULL</code>: The <code>NULL</code> value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param valueWhenUnsetOption
         *        The built-in options for default values. The value can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RECOMMENDED</code>: The recommended value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NULL</code>: The <code>NULL</code> value.
         *        </p>
         *        </li>
         * @see ValueWhenUnsetOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValueWhenUnsetOption
         */
        Builder valueWhenUnsetOption(ValueWhenUnsetOption valueWhenUnsetOption);

        /**
         * <p>
         * A custom value that's used when the value of a parameter isn't set.
         * </p>
         * 
         * @param customValue
         *        A custom value that's used when the value of a parameter isn't set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customValue(String customValue);
    }

    static final class BuilderImpl implements Builder {
        private String valueWhenUnsetOption;

        private String customValue;

        private BuilderImpl() {
        }

        private BuilderImpl(StringValueWhenUnsetConfiguration model) {
            valueWhenUnsetOption(model.valueWhenUnsetOption);
            customValue(model.customValue);
        }

        public final String getValueWhenUnsetOption() {
            return valueWhenUnsetOption;
        }

        public final void setValueWhenUnsetOption(String valueWhenUnsetOption) {
            this.valueWhenUnsetOption = valueWhenUnsetOption;
        }

        @Override
        public final Builder valueWhenUnsetOption(String valueWhenUnsetOption) {
            this.valueWhenUnsetOption = valueWhenUnsetOption;
            return this;
        }

        @Override
        public final Builder valueWhenUnsetOption(ValueWhenUnsetOption valueWhenUnsetOption) {
            this.valueWhenUnsetOption(valueWhenUnsetOption == null ? null : valueWhenUnsetOption.toString());
            return this;
        }

        public final String getCustomValue() {
            return customValue;
        }

        public final void setCustomValue(String customValue) {
            this.customValue = customValue;
        }

        @Override
        public final Builder customValue(String customValue) {
            this.customValue = customValue;
            return this;
        }

        @Override
        public StringValueWhenUnsetConfiguration build() {
            return new StringValueWhenUnsetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
