/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter that is applied to the options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SheetVisualScopingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SheetVisualScopingConfiguration.Builder, SheetVisualScopingConfiguration> {
    private static final SdkField<String> SHEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SheetId").getter(getter(SheetVisualScopingConfiguration::sheetId)).setter(setter(Builder::sheetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetId").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(SheetVisualScopingConfiguration::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<List<String>> VISUAL_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VisualIds")
            .getter(getter(SheetVisualScopingConfiguration::visualIds))
            .setter(setter(Builder::visualIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHEET_ID_FIELD, SCOPE_FIELD,
            VISUAL_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sheetId;

    private final String scope;

    private final List<String> visualIds;

    private SheetVisualScopingConfiguration(BuilderImpl builder) {
        this.sheetId = builder.sheetId;
        this.scope = builder.scope;
        this.visualIds = builder.visualIds;
    }

    /**
     * <p>
     * The selected sheet that the filter is applied to.
     * </p>
     * 
     * @return The selected sheet that the filter is applied to.
     */
    public final String sheetId() {
        return sheetId;
    }

    /**
     * <p>
     * The scope of the applied entities. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VISUALS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SELECTED_VISUALS</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link FilterVisualScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of the applied entities. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VISUALS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SELECTED_VISUALS</code>
     *         </p>
     *         </li>
     * @see FilterVisualScope
     */
    public final FilterVisualScope scope() {
        return FilterVisualScope.fromValue(scope);
    }

    /**
     * <p>
     * The scope of the applied entities. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VISUALS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SELECTED_VISUALS</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link FilterVisualScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of the applied entities. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VISUALS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SELECTED_VISUALS</code>
     *         </p>
     *         </li>
     * @see FilterVisualScope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * For responses, this returns true if the service returned a value for the VisualIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVisualIds() {
        return visualIds != null && !(visualIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The selected visuals that the filter is applied to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVisualIds} method.
     * </p>
     * 
     * @return The selected visuals that the filter is applied to.
     */
    public final List<String> visualIds() {
        return visualIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sheetId());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasVisualIds() ? visualIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetVisualScopingConfiguration)) {
            return false;
        }
        SheetVisualScopingConfiguration other = (SheetVisualScopingConfiguration) obj;
        return Objects.equals(sheetId(), other.sheetId()) && Objects.equals(scopeAsString(), other.scopeAsString())
                && hasVisualIds() == other.hasVisualIds() && Objects.equals(visualIds(), other.visualIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SheetVisualScopingConfiguration").add("SheetId", sheetId()).add("Scope", scopeAsString())
                .add("VisualIds", hasVisualIds() ? visualIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SheetId":
            return Optional.ofNullable(clazz.cast(sheetId()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "VisualIds":
            return Optional.ofNullable(clazz.cast(visualIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SheetId", SHEET_ID_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("VisualIds", VISUAL_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SheetVisualScopingConfiguration, T> g) {
        return obj -> g.apply((SheetVisualScopingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SheetVisualScopingConfiguration> {
        /**
         * <p>
         * The selected sheet that the filter is applied to.
         * </p>
         * 
         * @param sheetId
         *        The selected sheet that the filter is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetId(String sheetId);

        /**
         * <p>
         * The scope of the applied entities. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VISUALS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SELECTED_VISUALS</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        The scope of the applied entities. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VISUALS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SELECTED_VISUALS</code>
         *        </p>
         *        </li>
         * @see FilterVisualScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterVisualScope
         */
        Builder scope(String scope);

        /**
         * <p>
         * The scope of the applied entities. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VISUALS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SELECTED_VISUALS</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        The scope of the applied entities. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VISUALS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SELECTED_VISUALS</code>
         *        </p>
         *        </li>
         * @see FilterVisualScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterVisualScope
         */
        Builder scope(FilterVisualScope scope);

        /**
         * <p>
         * The selected visuals that the filter is applied to.
         * </p>
         * 
         * @param visualIds
         *        The selected visuals that the filter is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualIds(Collection<String> visualIds);

        /**
         * <p>
         * The selected visuals that the filter is applied to.
         * </p>
         * 
         * @param visualIds
         *        The selected visuals that the filter is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualIds(String... visualIds);
    }

    static final class BuilderImpl implements Builder {
        private String sheetId;

        private String scope;

        private List<String> visualIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SheetVisualScopingConfiguration model) {
            sheetId(model.sheetId);
            scope(model.scope);
            visualIds(model.visualIds);
        }

        public final String getSheetId() {
            return sheetId;
        }

        public final void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        @Override
        public final Builder sheetId(String sheetId) {
            this.sheetId = sheetId;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(FilterVisualScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final Collection<String> getVisualIds() {
            if (visualIds instanceof SdkAutoConstructList) {
                return null;
            }
            return visualIds;
        }

        public final void setVisualIds(Collection<String> visualIds) {
            this.visualIds = FilteredVisualsListCopier.copy(visualIds);
        }

        @Override
        public final Builder visualIds(Collection<String> visualIds) {
            this.visualIds = FilteredVisualsListCopier.copy(visualIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder visualIds(String... visualIds) {
            visualIds(Arrays.asList(visualIds));
            return this;
        }

        @Override
        public SheetVisualScopingConfiguration build() {
            return new SheetVisualScopingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
