/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source of the image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SheetImageSource implements SdkPojo, Serializable,
        ToCopyableBuilder<SheetImageSource.Builder, SheetImageSource> {
    private static final SdkField<SheetImageStaticFileSource> SHEET_IMAGE_STATIC_FILE_SOURCE_FIELD = SdkField
            .<SheetImageStaticFileSource> builder(MarshallingType.SDK_POJO)
            .memberName("SheetImageStaticFileSource")
            .getter(getter(SheetImageSource::sheetImageStaticFileSource))
            .setter(setter(Builder::sheetImageStaticFileSource))
            .constructor(SheetImageStaticFileSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetImageStaticFileSource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SHEET_IMAGE_STATIC_FILE_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SheetImageStaticFileSource sheetImageStaticFileSource;

    private SheetImageSource(BuilderImpl builder) {
        this.sheetImageStaticFileSource = builder.sheetImageStaticFileSource;
    }

    /**
     * <p>
     * The source of the static file that contains the image.
     * </p>
     * 
     * @return The source of the static file that contains the image.
     */
    public final SheetImageStaticFileSource sheetImageStaticFileSource() {
        return sheetImageStaticFileSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sheetImageStaticFileSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetImageSource)) {
            return false;
        }
        SheetImageSource other = (SheetImageSource) obj;
        return Objects.equals(sheetImageStaticFileSource(), other.sheetImageStaticFileSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SheetImageSource").add("SheetImageStaticFileSource", sheetImageStaticFileSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SheetImageStaticFileSource":
            return Optional.ofNullable(clazz.cast(sheetImageStaticFileSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SheetImageStaticFileSource", SHEET_IMAGE_STATIC_FILE_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SheetImageSource, T> g) {
        return obj -> g.apply((SheetImageSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SheetImageSource> {
        /**
         * <p>
         * The source of the static file that contains the image.
         * </p>
         * 
         * @param sheetImageStaticFileSource
         *        The source of the static file that contains the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetImageStaticFileSource(SheetImageStaticFileSource sheetImageStaticFileSource);

        /**
         * <p>
         * The source of the static file that contains the image.
         * </p>
         * This is a convenience method that creates an instance of the {@link SheetImageStaticFileSource.Builder}
         * avoiding the need to create one manually via {@link SheetImageStaticFileSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SheetImageStaticFileSource.Builder#build()} is called immediately
         * and its result is passed to {@link #sheetImageStaticFileSource(SheetImageStaticFileSource)}.
         * 
         * @param sheetImageStaticFileSource
         *        a consumer that will call methods on {@link SheetImageStaticFileSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sheetImageStaticFileSource(SheetImageStaticFileSource)
         */
        default Builder sheetImageStaticFileSource(Consumer<SheetImageStaticFileSource.Builder> sheetImageStaticFileSource) {
            return sheetImageStaticFileSource(SheetImageStaticFileSource.builder().applyMutation(sheetImageStaticFileSource)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SheetImageStaticFileSource sheetImageStaticFileSource;

        private BuilderImpl() {
        }

        private BuilderImpl(SheetImageSource model) {
            sheetImageStaticFileSource(model.sheetImageStaticFileSource);
        }

        public final SheetImageStaticFileSource.Builder getSheetImageStaticFileSource() {
            return sheetImageStaticFileSource != null ? sheetImageStaticFileSource.toBuilder() : null;
        }

        public final void setSheetImageStaticFileSource(SheetImageStaticFileSource.BuilderImpl sheetImageStaticFileSource) {
            this.sheetImageStaticFileSource = sheetImageStaticFileSource != null ? sheetImageStaticFileSource.build() : null;
        }

        @Override
        public final Builder sheetImageStaticFileSource(SheetImageStaticFileSource sheetImageStaticFileSource) {
            this.sheetImageStaticFileSource = sheetImageStaticFileSource;
            return this;
        }

        @Override
        public SheetImageSource build() {
            return new SheetImageSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
