/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The layout configuration of a section.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SectionLayoutConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SectionLayoutConfiguration.Builder, SectionLayoutConfiguration> {
    private static final SdkField<FreeFormSectionLayoutConfiguration> FREE_FORM_LAYOUT_FIELD = SdkField
            .<FreeFormSectionLayoutConfiguration> builder(MarshallingType.SDK_POJO).memberName("FreeFormLayout")
            .getter(getter(SectionLayoutConfiguration::freeFormLayout)).setter(setter(Builder::freeFormLayout))
            .constructor(FreeFormSectionLayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FreeFormLayout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREE_FORM_LAYOUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FreeFormSectionLayoutConfiguration freeFormLayout;

    private SectionLayoutConfiguration(BuilderImpl builder) {
        this.freeFormLayout = builder.freeFormLayout;
    }

    /**
     * <p>
     * The free-form layout configuration of a section.
     * </p>
     * 
     * @return The free-form layout configuration of a section.
     */
    public final FreeFormSectionLayoutConfiguration freeFormLayout() {
        return freeFormLayout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(freeFormLayout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SectionLayoutConfiguration)) {
            return false;
        }
        SectionLayoutConfiguration other = (SectionLayoutConfiguration) obj;
        return Objects.equals(freeFormLayout(), other.freeFormLayout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SectionLayoutConfiguration").add("FreeFormLayout", freeFormLayout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FreeFormLayout":
            return Optional.ofNullable(clazz.cast(freeFormLayout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FreeFormLayout", FREE_FORM_LAYOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SectionLayoutConfiguration, T> g) {
        return obj -> g.apply((SectionLayoutConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SectionLayoutConfiguration> {
        /**
         * <p>
         * The free-form layout configuration of a section.
         * </p>
         * 
         * @param freeFormLayout
         *        The free-form layout configuration of a section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freeFormLayout(FreeFormSectionLayoutConfiguration freeFormLayout);

        /**
         * <p>
         * The free-form layout configuration of a section.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FreeFormSectionLayoutConfiguration.Builder} avoiding the need to create one manually via
         * {@link FreeFormSectionLayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FreeFormSectionLayoutConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #freeFormLayout(FreeFormSectionLayoutConfiguration)}.
         * 
         * @param freeFormLayout
         *        a consumer that will call methods on {@link FreeFormSectionLayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #freeFormLayout(FreeFormSectionLayoutConfiguration)
         */
        default Builder freeFormLayout(Consumer<FreeFormSectionLayoutConfiguration.Builder> freeFormLayout) {
            return freeFormLayout(FreeFormSectionLayoutConfiguration.builder().applyMutation(freeFormLayout).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FreeFormSectionLayoutConfiguration freeFormLayout;

        private BuilderImpl() {
        }

        private BuilderImpl(SectionLayoutConfiguration model) {
            freeFormLayout(model.freeFormLayout);
        }

        public final FreeFormSectionLayoutConfiguration.Builder getFreeFormLayout() {
            return freeFormLayout != null ? freeFormLayout.toBuilder() : null;
        }

        public final void setFreeFormLayout(FreeFormSectionLayoutConfiguration.BuilderImpl freeFormLayout) {
            this.freeFormLayout = freeFormLayout != null ? freeFormLayout.build() : null;
        }

        @Override
        public final Builder freeFormLayout(FreeFormSectionLayoutConfiguration freeFormLayout) {
            this.freeFormLayout = freeFormLayout;
            return this;
        }

        @Override
        public SectionLayoutConfiguration build() {
            return new SectionLayoutConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
