/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The refresh on entity for weekly or monthly schedules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleRefreshOnEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduleRefreshOnEntity.Builder, ScheduleRefreshOnEntity> {
    private static final SdkField<String> DAY_OF_WEEK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DayOfWeek").getter(getter(ScheduleRefreshOnEntity::dayOfWeekAsString))
            .setter(setter(Builder::dayOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfWeek").build()).build();

    private static final SdkField<String> DAY_OF_MONTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DayOfMonth").getter(getter(ScheduleRefreshOnEntity::dayOfMonth)).setter(setter(Builder::dayOfMonth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfMonth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_OF_WEEK_FIELD,
            DAY_OF_MONTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dayOfWeek;

    private final String dayOfMonth;

    private ScheduleRefreshOnEntity(BuilderImpl builder) {
        this.dayOfWeek = builder.dayOfWeek;
        this.dayOfMonth = builder.dayOfMonth;
    }

    /**
     * <p>
     * The day of the week that you want to schedule a refresh on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return The day of the week that you want to schedule a refresh on.
     * @see DayOfWeek
     */
    public final DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(dayOfWeek);
    }

    /**
     * <p>
     * The day of the week that you want to schedule a refresh on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return The day of the week that you want to schedule a refresh on.
     * @see DayOfWeek
     */
    public final String dayOfWeekAsString() {
        return dayOfWeek;
    }

    /**
     * <p>
     * The day of the month that you want to schedule refresh on.
     * </p>
     * 
     * @return The day of the month that you want to schedule refresh on.
     */
    public final String dayOfMonth() {
        return dayOfMonth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dayOfWeekAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfMonth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRefreshOnEntity)) {
            return false;
        }
        ScheduleRefreshOnEntity other = (ScheduleRefreshOnEntity) obj;
        return Objects.equals(dayOfWeekAsString(), other.dayOfWeekAsString()) && Objects.equals(dayOfMonth(), other.dayOfMonth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleRefreshOnEntity").add("DayOfWeek", dayOfWeekAsString()).add("DayOfMonth", dayOfMonth())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DayOfWeek":
            return Optional.ofNullable(clazz.cast(dayOfWeekAsString()));
        case "DayOfMonth":
            return Optional.ofNullable(clazz.cast(dayOfMonth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DayOfWeek", DAY_OF_WEEK_FIELD);
        map.put("DayOfMonth", DAY_OF_MONTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduleRefreshOnEntity, T> g) {
        return obj -> g.apply((ScheduleRefreshOnEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleRefreshOnEntity> {
        /**
         * <p>
         * The day of the week that you want to schedule a refresh on.
         * </p>
         * 
         * @param dayOfWeek
         *        The day of the week that you want to schedule a refresh on.
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(String dayOfWeek);

        /**
         * <p>
         * The day of the week that you want to schedule a refresh on.
         * </p>
         * 
         * @param dayOfWeek
         *        The day of the week that you want to schedule a refresh on.
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(DayOfWeek dayOfWeek);

        /**
         * <p>
         * The day of the month that you want to schedule refresh on.
         * </p>
         * 
         * @param dayOfMonth
         *        The day of the month that you want to schedule refresh on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfMonth(String dayOfMonth);
    }

    static final class BuilderImpl implements Builder {
        private String dayOfWeek;

        private String dayOfMonth;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRefreshOnEntity model) {
            dayOfWeek(model.dayOfWeek);
            dayOfMonth(model.dayOfMonth);
        }

        public final String getDayOfWeek() {
            return dayOfWeek;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek == null ? null : dayOfWeek.toString());
            return this;
        }

        public final String getDayOfMonth() {
            return dayOfMonth;
        }

        public final void setDayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        @Override
        public ScheduleRefreshOnEntity build() {
            return new ScheduleRefreshOnEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
