/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field well configuration of a sankey diagram.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SankeyDiagramAggregatedFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<SankeyDiagramAggregatedFieldWells.Builder, SankeyDiagramAggregatedFieldWells> {
    private static final SdkField<List<DimensionField>> SOURCE_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Source")
            .getter(getter(SankeyDiagramAggregatedFieldWells::source))
            .setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DimensionField>> DESTINATION_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Destination")
            .getter(getter(SankeyDiagramAggregatedFieldWells::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MeasureField>> WEIGHT_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("Weight")
            .getter(getter(SankeyDiagramAggregatedFieldWells::weight))
            .setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            DESTINATION_FIELD, WEIGHT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DimensionField> source;

    private final List<DimensionField> destination;

    private final List<MeasureField> weight;

    private SankeyDiagramAggregatedFieldWells(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.weight = builder.weight;
    }

    /**
     * For responses, this returns true if the service returned a value for the Source property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSource() {
        return source != null && !(source instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source field wells of a sankey diagram.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSource} method.
     * </p>
     * 
     * @return The source field wells of a sankey diagram.
     */
    public final List<DimensionField> source() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destination property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestination() {
        return destination != null && !(destination instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination field wells of a sankey diagram.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestination} method.
     * </p>
     * 
     * @return The destination field wells of a sankey diagram.
     */
    public final List<DimensionField> destination() {
        return destination;
    }

    /**
     * For responses, this returns true if the service returned a value for the Weight property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWeight() {
        return weight != null && !(weight instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The weight field wells of a sankey diagram.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWeight} method.
     * </p>
     * 
     * @return The weight field wells of a sankey diagram.
     */
    public final List<MeasureField> weight() {
        return weight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSource() ? source() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestination() ? destination() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWeight() ? weight() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SankeyDiagramAggregatedFieldWells)) {
            return false;
        }
        SankeyDiagramAggregatedFieldWells other = (SankeyDiagramAggregatedFieldWells) obj;
        return hasSource() == other.hasSource() && Objects.equals(source(), other.source())
                && hasDestination() == other.hasDestination() && Objects.equals(destination(), other.destination())
                && hasWeight() == other.hasWeight() && Objects.equals(weight(), other.weight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SankeyDiagramAggregatedFieldWells").add("Source", hasSource() ? source() : null)
                .add("Destination", hasDestination() ? destination() : null).add("Weight", hasWeight() ? weight() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Weight":
            return Optional.ofNullable(clazz.cast(weight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Source", SOURCE_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("Weight", WEIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SankeyDiagramAggregatedFieldWells, T> g) {
        return obj -> g.apply((SankeyDiagramAggregatedFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SankeyDiagramAggregatedFieldWells> {
        /**
         * <p>
         * The source field wells of a sankey diagram.
         * </p>
         * 
         * @param source
         *        The source field wells of a sankey diagram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Collection<DimensionField> source);

        /**
         * <p>
         * The source field wells of a sankey diagram.
         * </p>
         * 
         * @param source
         *        The source field wells of a sankey diagram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(DimensionField... source);

        /**
         * <p>
         * The source field wells of a sankey diagram.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #source(List<DimensionField>)}.
         * 
         * @param source
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(java.util.Collection<DimensionField>)
         */
        Builder source(Consumer<DimensionField.Builder>... source);

        /**
         * <p>
         * The destination field wells of a sankey diagram.
         * </p>
         * 
         * @param destination
         *        The destination field wells of a sankey diagram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Collection<DimensionField> destination);

        /**
         * <p>
         * The destination field wells of a sankey diagram.
         * </p>
         * 
         * @param destination
         *        The destination field wells of a sankey diagram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(DimensionField... destination);

        /**
         * <p>
         * The destination field wells of a sankey diagram.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #destination(List<DimensionField>)}.
         * 
         * @param destination
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(java.util.Collection<DimensionField>)
         */
        Builder destination(Consumer<DimensionField.Builder>... destination);

        /**
         * <p>
         * The weight field wells of a sankey diagram.
         * </p>
         * 
         * @param weight
         *        The weight field wells of a sankey diagram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Collection<MeasureField> weight);

        /**
         * <p>
         * The weight field wells of a sankey diagram.
         * </p>
         * 
         * @param weight
         *        The weight field wells of a sankey diagram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(MeasureField... weight);

        /**
         * <p>
         * The weight field wells of a sankey diagram.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #weight(List<MeasureField>)}.
         * 
         * @param weight
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #weight(java.util.Collection<MeasureField>)
         */
        Builder weight(Consumer<MeasureField.Builder>... weight);
    }

    static final class BuilderImpl implements Builder {
        private List<DimensionField> source = DefaultSdkAutoConstructList.getInstance();

        private List<DimensionField> destination = DefaultSdkAutoConstructList.getInstance();

        private List<MeasureField> weight = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SankeyDiagramAggregatedFieldWells model) {
            source(model.source);
            destination(model.destination);
            weight(model.weight);
        }

        public final List<DimensionField.Builder> getSource() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.source);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSource(Collection<DimensionField.BuilderImpl> source) {
            this.source = DimensionFieldListCopier.copyFromBuilder(source);
        }

        @Override
        public final Builder source(Collection<DimensionField> source) {
            this.source = DimensionFieldListCopier.copy(source);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder source(DimensionField... source) {
            source(Arrays.asList(source));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder source(Consumer<DimensionField.Builder>... source) {
            source(Stream.of(source).map(c -> DimensionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionField.Builder> getDestination() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.destination);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestination(Collection<DimensionField.BuilderImpl> destination) {
            this.destination = DimensionFieldListCopier.copyFromBuilder(destination);
        }

        @Override
        public final Builder destination(Collection<DimensionField> destination) {
            this.destination = DimensionFieldListCopier.copy(destination);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destination(DimensionField... destination) {
            destination(Arrays.asList(destination));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destination(Consumer<DimensionField.Builder>... destination) {
            destination(Stream.of(destination).map(c -> DimensionField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getWeight() {
            List<MeasureField.Builder> result = MeasureFieldListCopier.copyToBuilder(this.weight);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWeight(Collection<MeasureField.BuilderImpl> weight) {
            this.weight = MeasureFieldListCopier.copyFromBuilder(weight);
        }

        @Override
        public final Builder weight(Collection<MeasureField> weight) {
            this.weight = MeasureFieldListCopier.copy(weight);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weight(MeasureField... weight) {
            weight(Arrays.asList(weight));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weight(Consumer<MeasureField.Builder>... weight) {
            weight(Stream.of(weight).map(c -> MeasureField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SankeyDiagramAggregatedFieldWells build() {
            return new SankeyDiagramAggregatedFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
