/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the interval between each scheduled refresh of a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshFrequency implements SdkPojo, Serializable,
        ToCopyableBuilder<RefreshFrequency.Builder, RefreshFrequency> {
    private static final SdkField<String> INTERVAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Interval").getter(getter(RefreshFrequency::intervalAsString)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final SdkField<ScheduleRefreshOnEntity> REFRESH_ON_DAY_FIELD = SdkField
            .<ScheduleRefreshOnEntity> builder(MarshallingType.SDK_POJO).memberName("RefreshOnDay")
            .getter(getter(RefreshFrequency::refreshOnDay)).setter(setter(Builder::refreshOnDay))
            .constructor(ScheduleRefreshOnEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshOnDay").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(RefreshFrequency::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<String> TIME_OF_THE_DAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeOfTheDay").getter(getter(RefreshFrequency::timeOfTheDay)).setter(setter(Builder::timeOfTheDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeOfTheDay").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERVAL_FIELD,
            REFRESH_ON_DAY_FIELD, TIMEZONE_FIELD, TIME_OF_THE_DAY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String interval;

    private final ScheduleRefreshOnEntity refreshOnDay;

    private final String timezone;

    private final String timeOfTheDay;

    private RefreshFrequency(BuilderImpl builder) {
        this.interval = builder.interval;
        this.refreshOnDay = builder.refreshOnDay;
        this.timezone = builder.timezone;
        this.timeOfTheDay = builder.timeOfTheDay;
    }

    /**
     * <p>
     * The interval between scheduled refreshes. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MINUTE15</code>: The dataset refreshes every 15 minutes. This value is only supported for incremental
     * refreshes. This interval can only be used for one schedule per dataset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MINUTE30</code>:The dataset refreshes every 30 minutes. This value is only supported for incremental
     * refreshes. This interval can only be used for one schedule per dataset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOURLY</code>: The dataset refreshes every hour. This interval can only be used for one schedule per
     * dataset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DAILY</code>: The dataset refreshes every day.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WEEKLY</code>: The dataset refreshes every week.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MONTHLY</code>: The dataset refreshes every month.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interval} will
     * return {@link RefreshInterval#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #intervalAsString}.
     * </p>
     * 
     * @return The interval between scheduled refreshes. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MINUTE15</code>: The dataset refreshes every 15 minutes. This value is only supported for
     *         incremental refreshes. This interval can only be used for one schedule per dataset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MINUTE30</code>:The dataset refreshes every 30 minutes. This value is only supported for
     *         incremental refreshes. This interval can only be used for one schedule per dataset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOURLY</code>: The dataset refreshes every hour. This interval can only be used for one schedule
     *         per dataset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DAILY</code>: The dataset refreshes every day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WEEKLY</code>: The dataset refreshes every week.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MONTHLY</code>: The dataset refreshes every month.
     *         </p>
     *         </li>
     * @see RefreshInterval
     */
    public final RefreshInterval interval() {
        return RefreshInterval.fromValue(interval);
    }

    /**
     * <p>
     * The interval between scheduled refreshes. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MINUTE15</code>: The dataset refreshes every 15 minutes. This value is only supported for incremental
     * refreshes. This interval can only be used for one schedule per dataset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MINUTE30</code>:The dataset refreshes every 30 minutes. This value is only supported for incremental
     * refreshes. This interval can only be used for one schedule per dataset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOURLY</code>: The dataset refreshes every hour. This interval can only be used for one schedule per
     * dataset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DAILY</code>: The dataset refreshes every day.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WEEKLY</code>: The dataset refreshes every week.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MONTHLY</code>: The dataset refreshes every month.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interval} will
     * return {@link RefreshInterval#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #intervalAsString}.
     * </p>
     * 
     * @return The interval between scheduled refreshes. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MINUTE15</code>: The dataset refreshes every 15 minutes. This value is only supported for
     *         incremental refreshes. This interval can only be used for one schedule per dataset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MINUTE30</code>:The dataset refreshes every 30 minutes. This value is only supported for
     *         incremental refreshes. This interval can only be used for one schedule per dataset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOURLY</code>: The dataset refreshes every hour. This interval can only be used for one schedule
     *         per dataset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DAILY</code>: The dataset refreshes every day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WEEKLY</code>: The dataset refreshes every week.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MONTHLY</code>: The dataset refreshes every month.
     *         </p>
     *         </li>
     * @see RefreshInterval
     */
    public final String intervalAsString() {
        return interval;
    }

    /**
     * <p>
     * The day of the week that you want to schedule the refresh on. This value is required for weekly and monthly
     * refresh intervals.
     * </p>
     * 
     * @return The day of the week that you want to schedule the refresh on. This value is required for weekly and
     *         monthly refresh intervals.
     */
    public final ScheduleRefreshOnEntity refreshOnDay() {
        return refreshOnDay;
    }

    /**
     * <p>
     * The timezone that you want the refresh schedule to use. The timezone ID must match a corresponding ID found on
     * <code>java.util.time.getAvailableIDs()</code>.
     * </p>
     * 
     * @return The timezone that you want the refresh schedule to use. The timezone ID must match a corresponding ID
     *         found on <code>java.util.time.getAvailableIDs()</code>.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * The time of day that you want the datset to refresh. This value is expressed in HH:MM format. This field is not
     * required for schedules that refresh hourly.
     * </p>
     * 
     * @return The time of day that you want the datset to refresh. This value is expressed in HH:MM format. This field
     *         is not required for schedules that refresh hourly.
     */
    public final String timeOfTheDay() {
        return timeOfTheDay;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(refreshOnDay());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(timeOfTheDay());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshFrequency)) {
            return false;
        }
        RefreshFrequency other = (RefreshFrequency) obj;
        return Objects.equals(intervalAsString(), other.intervalAsString())
                && Objects.equals(refreshOnDay(), other.refreshOnDay()) && Objects.equals(timezone(), other.timezone())
                && Objects.equals(timeOfTheDay(), other.timeOfTheDay());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RefreshFrequency").add("Interval", intervalAsString()).add("RefreshOnDay", refreshOnDay())
                .add("Timezone", timezone()).add("TimeOfTheDay", timeOfTheDay()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Interval":
            return Optional.ofNullable(clazz.cast(intervalAsString()));
        case "RefreshOnDay":
            return Optional.ofNullable(clazz.cast(refreshOnDay()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "TimeOfTheDay":
            return Optional.ofNullable(clazz.cast(timeOfTheDay()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Interval", INTERVAL_FIELD);
        map.put("RefreshOnDay", REFRESH_ON_DAY_FIELD);
        map.put("Timezone", TIMEZONE_FIELD);
        map.put("TimeOfTheDay", TIME_OF_THE_DAY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RefreshFrequency, T> g) {
        return obj -> g.apply((RefreshFrequency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RefreshFrequency> {
        /**
         * <p>
         * The interval between scheduled refreshes. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MINUTE15</code>: The dataset refreshes every 15 minutes. This value is only supported for incremental
         * refreshes. This interval can only be used for one schedule per dataset.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MINUTE30</code>:The dataset refreshes every 30 minutes. This value is only supported for incremental
         * refreshes. This interval can only be used for one schedule per dataset.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOURLY</code>: The dataset refreshes every hour. This interval can only be used for one schedule per
         * dataset.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DAILY</code>: The dataset refreshes every day.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WEEKLY</code>: The dataset refreshes every week.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MONTHLY</code>: The dataset refreshes every month.
         * </p>
         * </li>
         * </ul>
         * 
         * @param interval
         *        The interval between scheduled refreshes. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MINUTE15</code>: The dataset refreshes every 15 minutes. This value is only supported for
         *        incremental refreshes. This interval can only be used for one schedule per dataset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MINUTE30</code>:The dataset refreshes every 30 minutes. This value is only supported for
         *        incremental refreshes. This interval can only be used for one schedule per dataset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOURLY</code>: The dataset refreshes every hour. This interval can only be used for one schedule
         *        per dataset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DAILY</code>: The dataset refreshes every day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WEEKLY</code>: The dataset refreshes every week.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MONTHLY</code>: The dataset refreshes every month.
         *        </p>
         *        </li>
         * @see RefreshInterval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RefreshInterval
         */
        Builder interval(String interval);

        /**
         * <p>
         * The interval between scheduled refreshes. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MINUTE15</code>: The dataset refreshes every 15 minutes. This value is only supported for incremental
         * refreshes. This interval can only be used for one schedule per dataset.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MINUTE30</code>:The dataset refreshes every 30 minutes. This value is only supported for incremental
         * refreshes. This interval can only be used for one schedule per dataset.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOURLY</code>: The dataset refreshes every hour. This interval can only be used for one schedule per
         * dataset.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DAILY</code>: The dataset refreshes every day.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WEEKLY</code>: The dataset refreshes every week.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MONTHLY</code>: The dataset refreshes every month.
         * </p>
         * </li>
         * </ul>
         * 
         * @param interval
         *        The interval between scheduled refreshes. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MINUTE15</code>: The dataset refreshes every 15 minutes. This value is only supported for
         *        incremental refreshes. This interval can only be used for one schedule per dataset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MINUTE30</code>:The dataset refreshes every 30 minutes. This value is only supported for
         *        incremental refreshes. This interval can only be used for one schedule per dataset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOURLY</code>: The dataset refreshes every hour. This interval can only be used for one schedule
         *        per dataset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DAILY</code>: The dataset refreshes every day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WEEKLY</code>: The dataset refreshes every week.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MONTHLY</code>: The dataset refreshes every month.
         *        </p>
         *        </li>
         * @see RefreshInterval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RefreshInterval
         */
        Builder interval(RefreshInterval interval);

        /**
         * <p>
         * The day of the week that you want to schedule the refresh on. This value is required for weekly and monthly
         * refresh intervals.
         * </p>
         * 
         * @param refreshOnDay
         *        The day of the week that you want to schedule the refresh on. This value is required for weekly and
         *        monthly refresh intervals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshOnDay(ScheduleRefreshOnEntity refreshOnDay);

        /**
         * <p>
         * The day of the week that you want to schedule the refresh on. This value is required for weekly and monthly
         * refresh intervals.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduleRefreshOnEntity.Builder} avoiding
         * the need to create one manually via {@link ScheduleRefreshOnEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleRefreshOnEntity.Builder#build()} is called immediately
         * and its result is passed to {@link #refreshOnDay(ScheduleRefreshOnEntity)}.
         * 
         * @param refreshOnDay
         *        a consumer that will call methods on {@link ScheduleRefreshOnEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshOnDay(ScheduleRefreshOnEntity)
         */
        default Builder refreshOnDay(Consumer<ScheduleRefreshOnEntity.Builder> refreshOnDay) {
            return refreshOnDay(ScheduleRefreshOnEntity.builder().applyMutation(refreshOnDay).build());
        }

        /**
         * <p>
         * The timezone that you want the refresh schedule to use. The timezone ID must match a corresponding ID found
         * on <code>java.util.time.getAvailableIDs()</code>.
         * </p>
         * 
         * @param timezone
         *        The timezone that you want the refresh schedule to use. The timezone ID must match a corresponding ID
         *        found on <code>java.util.time.getAvailableIDs()</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * The time of day that you want the datset to refresh. This value is expressed in HH:MM format. This field is
         * not required for schedules that refresh hourly.
         * </p>
         * 
         * @param timeOfTheDay
         *        The time of day that you want the datset to refresh. This value is expressed in HH:MM format. This
         *        field is not required for schedules that refresh hourly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeOfTheDay(String timeOfTheDay);
    }

    static final class BuilderImpl implements Builder {
        private String interval;

        private ScheduleRefreshOnEntity refreshOnDay;

        private String timezone;

        private String timeOfTheDay;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshFrequency model) {
            interval(model.interval);
            refreshOnDay(model.refreshOnDay);
            timezone(model.timezone);
            timeOfTheDay(model.timeOfTheDay);
        }

        public final String getInterval() {
            return interval;
        }

        public final void setInterval(String interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(String interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public final Builder interval(RefreshInterval interval) {
            this.interval(interval == null ? null : interval.toString());
            return this;
        }

        public final ScheduleRefreshOnEntity.Builder getRefreshOnDay() {
            return refreshOnDay != null ? refreshOnDay.toBuilder() : null;
        }

        public final void setRefreshOnDay(ScheduleRefreshOnEntity.BuilderImpl refreshOnDay) {
            this.refreshOnDay = refreshOnDay != null ? refreshOnDay.build() : null;
        }

        @Override
        public final Builder refreshOnDay(ScheduleRefreshOnEntity refreshOnDay) {
            this.refreshOnDay = refreshOnDay;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final String getTimeOfTheDay() {
            return timeOfTheDay;
        }

        public final void setTimeOfTheDay(String timeOfTheDay) {
            this.timeOfTheDay = timeOfTheDay;
        }

        @Override
        public final Builder timeOfTheDay(String timeOfTheDay) {
            this.timeOfTheDay = timeOfTheDay;
            return this;
        }

        @Override
        public RefreshFrequency build() {
            return new RefreshFrequency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
