/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The table query sorting options for the plugin visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PluginVisualTableQuerySort implements SdkPojo, Serializable,
        ToCopyableBuilder<PluginVisualTableQuerySort.Builder, PluginVisualTableQuerySort> {
    private static final SdkField<List<FieldSortOptions>> ROW_SORT_FIELD = SdkField
            .<List<FieldSortOptions>> builder(MarshallingType.LIST)
            .memberName("RowSort")
            .getter(getter(PluginVisualTableQuerySort::rowSort))
            .setter(setter(Builder::rowSort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowSort").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldSortOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldSortOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PluginVisualItemsLimitConfiguration> ITEMS_LIMIT_CONFIGURATION_FIELD = SdkField
            .<PluginVisualItemsLimitConfiguration> builder(MarshallingType.SDK_POJO).memberName("ItemsLimitConfiguration")
            .getter(getter(PluginVisualTableQuerySort::itemsLimitConfiguration)).setter(setter(Builder::itemsLimitConfiguration))
            .constructor(PluginVisualItemsLimitConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemsLimitConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROW_SORT_FIELD,
            ITEMS_LIMIT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FieldSortOptions> rowSort;

    private final PluginVisualItemsLimitConfiguration itemsLimitConfiguration;

    private PluginVisualTableQuerySort(BuilderImpl builder) {
        this.rowSort = builder.rowSort;
        this.itemsLimitConfiguration = builder.itemsLimitConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the RowSort property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRowSort() {
        return rowSort != null && !(rowSort instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Determines how data is sorted in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRowSort} method.
     * </p>
     * 
     * @return Determines how data is sorted in the response.
     */
    public final List<FieldSortOptions> rowSort() {
        return rowSort;
    }

    /**
     * <p>
     * The maximum amount of data to be returned by a query.
     * </p>
     * 
     * @return The maximum amount of data to be returned by a query.
     */
    public final PluginVisualItemsLimitConfiguration itemsLimitConfiguration() {
        return itemsLimitConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRowSort() ? rowSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(itemsLimitConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginVisualTableQuerySort)) {
            return false;
        }
        PluginVisualTableQuerySort other = (PluginVisualTableQuerySort) obj;
        return hasRowSort() == other.hasRowSort() && Objects.equals(rowSort(), other.rowSort())
                && Objects.equals(itemsLimitConfiguration(), other.itemsLimitConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PluginVisualTableQuerySort").add("RowSort", hasRowSort() ? rowSort() : null)
                .add("ItemsLimitConfiguration", itemsLimitConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RowSort":
            return Optional.ofNullable(clazz.cast(rowSort()));
        case "ItemsLimitConfiguration":
            return Optional.ofNullable(clazz.cast(itemsLimitConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RowSort", ROW_SORT_FIELD);
        map.put("ItemsLimitConfiguration", ITEMS_LIMIT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PluginVisualTableQuerySort, T> g) {
        return obj -> g.apply((PluginVisualTableQuerySort) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PluginVisualTableQuerySort> {
        /**
         * <p>
         * Determines how data is sorted in the response.
         * </p>
         * 
         * @param rowSort
         *        Determines how data is sorted in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowSort(Collection<FieldSortOptions> rowSort);

        /**
         * <p>
         * Determines how data is sorted in the response.
         * </p>
         * 
         * @param rowSort
         *        Determines how data is sorted in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowSort(FieldSortOptions... rowSort);

        /**
         * <p>
         * Determines how data is sorted in the response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #rowSort(List<FieldSortOptions>)}.
         * 
         * @param rowSort
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowSort(java.util.Collection<FieldSortOptions>)
         */
        Builder rowSort(Consumer<FieldSortOptions.Builder>... rowSort);

        /**
         * <p>
         * The maximum amount of data to be returned by a query.
         * </p>
         * 
         * @param itemsLimitConfiguration
         *        The maximum amount of data to be returned by a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemsLimitConfiguration(PluginVisualItemsLimitConfiguration itemsLimitConfiguration);

        /**
         * <p>
         * The maximum amount of data to be returned by a query.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PluginVisualItemsLimitConfiguration.Builder} avoiding the need to create one manually via
         * {@link PluginVisualItemsLimitConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PluginVisualItemsLimitConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #itemsLimitConfiguration(PluginVisualItemsLimitConfiguration)}.
         * 
         * @param itemsLimitConfiguration
         *        a consumer that will call methods on {@link PluginVisualItemsLimitConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #itemsLimitConfiguration(PluginVisualItemsLimitConfiguration)
         */
        default Builder itemsLimitConfiguration(Consumer<PluginVisualItemsLimitConfiguration.Builder> itemsLimitConfiguration) {
            return itemsLimitConfiguration(PluginVisualItemsLimitConfiguration.builder().applyMutation(itemsLimitConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<FieldSortOptions> rowSort = DefaultSdkAutoConstructList.getInstance();

        private PluginVisualItemsLimitConfiguration itemsLimitConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PluginVisualTableQuerySort model) {
            rowSort(model.rowSort);
            itemsLimitConfiguration(model.itemsLimitConfiguration);
        }

        public final List<FieldSortOptions.Builder> getRowSort() {
            List<FieldSortOptions.Builder> result = RowSortListCopier.copyToBuilder(this.rowSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRowSort(Collection<FieldSortOptions.BuilderImpl> rowSort) {
            this.rowSort = RowSortListCopier.copyFromBuilder(rowSort);
        }

        @Override
        public final Builder rowSort(Collection<FieldSortOptions> rowSort) {
            this.rowSort = RowSortListCopier.copy(rowSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowSort(FieldSortOptions... rowSort) {
            rowSort(Arrays.asList(rowSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowSort(Consumer<FieldSortOptions.Builder>... rowSort) {
            rowSort(Stream.of(rowSort).map(c -> FieldSortOptions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final PluginVisualItemsLimitConfiguration.Builder getItemsLimitConfiguration() {
            return itemsLimitConfiguration != null ? itemsLimitConfiguration.toBuilder() : null;
        }

        public final void setItemsLimitConfiguration(PluginVisualItemsLimitConfiguration.BuilderImpl itemsLimitConfiguration) {
            this.itemsLimitConfiguration = itemsLimitConfiguration != null ? itemsLimitConfiguration.build() : null;
        }

        @Override
        public final Builder itemsLimitConfiguration(PluginVisualItemsLimitConfiguration itemsLimitConfiguration) {
            this.itemsLimitConfiguration = itemsLimitConfiguration;
            return this;
        }

        @Override
        public PluginVisualTableQuerySort build() {
            return new PluginVisualTableQuerySort(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
