/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Marker styles options for a line series in <code>LineChartVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineChartMarkerStyleSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<LineChartMarkerStyleSettings.Builder, LineChartMarkerStyleSettings> {
    private static final SdkField<String> MARKER_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MarkerVisibility").getter(getter(LineChartMarkerStyleSettings::markerVisibilityAsString))
            .setter(setter(Builder::markerVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarkerVisibility").build()).build();

    private static final SdkField<String> MARKER_SHAPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MarkerShape").getter(getter(LineChartMarkerStyleSettings::markerShapeAsString))
            .setter(setter(Builder::markerShape))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarkerShape").build()).build();

    private static final SdkField<String> MARKER_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MarkerSize").getter(getter(LineChartMarkerStyleSettings::markerSize))
            .setter(setter(Builder::markerSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarkerSize").build()).build();

    private static final SdkField<String> MARKER_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MarkerColor").getter(getter(LineChartMarkerStyleSettings::markerColor))
            .setter(setter(Builder::markerColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarkerColor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_VISIBILITY_FIELD,
            MARKER_SHAPE_FIELD, MARKER_SIZE_FIELD, MARKER_COLOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String markerVisibility;

    private final String markerShape;

    private final String markerSize;

    private final String markerColor;

    private LineChartMarkerStyleSettings(BuilderImpl builder) {
        this.markerVisibility = builder.markerVisibility;
        this.markerShape = builder.markerShape;
        this.markerSize = builder.markerSize;
        this.markerColor = builder.markerColor;
    }

    /**
     * <p>
     * Configuration option that determines whether to show the markers in the series.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #markerVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #markerVisibilityAsString}.
     * </p>
     * 
     * @return Configuration option that determines whether to show the markers in the series.
     * @see Visibility
     */
    public final Visibility markerVisibility() {
        return Visibility.fromValue(markerVisibility);
    }

    /**
     * <p>
     * Configuration option that determines whether to show the markers in the series.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #markerVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #markerVisibilityAsString}.
     * </p>
     * 
     * @return Configuration option that determines whether to show the markers in the series.
     * @see Visibility
     */
    public final String markerVisibilityAsString() {
        return markerVisibility;
    }

    /**
     * <p>
     * Shape option for markers in the series.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CIRCLE</code>: Show marker as a circle.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRIANGLE</code>: Show marker as a triangle.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SQUARE</code>: Show marker as a square.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DIAMOND</code>: Show marker as a diamond.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROUNDED_SQUARE</code>: Show marker as a rounded square.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #markerShape} will
     * return {@link LineChartMarkerShape#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #markerShapeAsString}.
     * </p>
     * 
     * @return Shape option for markers in the series.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CIRCLE</code>: Show marker as a circle.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRIANGLE</code>: Show marker as a triangle.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SQUARE</code>: Show marker as a square.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DIAMOND</code>: Show marker as a diamond.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROUNDED_SQUARE</code>: Show marker as a rounded square.
     *         </p>
     *         </li>
     * @see LineChartMarkerShape
     */
    public final LineChartMarkerShape markerShape() {
        return LineChartMarkerShape.fromValue(markerShape);
    }

    /**
     * <p>
     * Shape option for markers in the series.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CIRCLE</code>: Show marker as a circle.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRIANGLE</code>: Show marker as a triangle.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SQUARE</code>: Show marker as a square.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DIAMOND</code>: Show marker as a diamond.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROUNDED_SQUARE</code>: Show marker as a rounded square.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #markerShape} will
     * return {@link LineChartMarkerShape#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #markerShapeAsString}.
     * </p>
     * 
     * @return Shape option for markers in the series.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CIRCLE</code>: Show marker as a circle.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRIANGLE</code>: Show marker as a triangle.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SQUARE</code>: Show marker as a square.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DIAMOND</code>: Show marker as a diamond.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROUNDED_SQUARE</code>: Show marker as a rounded square.
     *         </p>
     *         </li>
     * @see LineChartMarkerShape
     */
    public final String markerShapeAsString() {
        return markerShape;
    }

    /**
     * <p>
     * Size of marker in the series.
     * </p>
     * 
     * @return Size of marker in the series.
     */
    public final String markerSize() {
        return markerSize;
    }

    /**
     * <p>
     * Color of marker in the series.
     * </p>
     * 
     * @return Color of marker in the series.
     */
    public final String markerColor() {
        return markerColor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(markerVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(markerShapeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(markerSize());
        hashCode = 31 * hashCode + Objects.hashCode(markerColor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineChartMarkerStyleSettings)) {
            return false;
        }
        LineChartMarkerStyleSettings other = (LineChartMarkerStyleSettings) obj;
        return Objects.equals(markerVisibilityAsString(), other.markerVisibilityAsString())
                && Objects.equals(markerShapeAsString(), other.markerShapeAsString())
                && Objects.equals(markerSize(), other.markerSize()) && Objects.equals(markerColor(), other.markerColor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineChartMarkerStyleSettings").add("MarkerVisibility", markerVisibilityAsString())
                .add("MarkerShape", markerShapeAsString()).add("MarkerSize", markerSize()).add("MarkerColor", markerColor())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MarkerVisibility":
            return Optional.ofNullable(clazz.cast(markerVisibilityAsString()));
        case "MarkerShape":
            return Optional.ofNullable(clazz.cast(markerShapeAsString()));
        case "MarkerSize":
            return Optional.ofNullable(clazz.cast(markerSize()));
        case "MarkerColor":
            return Optional.ofNullable(clazz.cast(markerColor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MarkerVisibility", MARKER_VISIBILITY_FIELD);
        map.put("MarkerShape", MARKER_SHAPE_FIELD);
        map.put("MarkerSize", MARKER_SIZE_FIELD);
        map.put("MarkerColor", MARKER_COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineChartMarkerStyleSettings, T> g) {
        return obj -> g.apply((LineChartMarkerStyleSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineChartMarkerStyleSettings> {
        /**
         * <p>
         * Configuration option that determines whether to show the markers in the series.
         * </p>
         * 
         * @param markerVisibility
         *        Configuration option that determines whether to show the markers in the series.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder markerVisibility(String markerVisibility);

        /**
         * <p>
         * Configuration option that determines whether to show the markers in the series.
         * </p>
         * 
         * @param markerVisibility
         *        Configuration option that determines whether to show the markers in the series.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder markerVisibility(Visibility markerVisibility);

        /**
         * <p>
         * Shape option for markers in the series.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CIRCLE</code>: Show marker as a circle.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRIANGLE</code>: Show marker as a triangle.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SQUARE</code>: Show marker as a square.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DIAMOND</code>: Show marker as a diamond.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROUNDED_SQUARE</code>: Show marker as a rounded square.
         * </p>
         * </li>
         * </ul>
         * 
         * @param markerShape
         *        Shape option for markers in the series.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CIRCLE</code>: Show marker as a circle.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRIANGLE</code>: Show marker as a triangle.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SQUARE</code>: Show marker as a square.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DIAMOND</code>: Show marker as a diamond.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROUNDED_SQUARE</code>: Show marker as a rounded square.
         *        </p>
         *        </li>
         * @see LineChartMarkerShape
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineChartMarkerShape
         */
        Builder markerShape(String markerShape);

        /**
         * <p>
         * Shape option for markers in the series.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CIRCLE</code>: Show marker as a circle.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRIANGLE</code>: Show marker as a triangle.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SQUARE</code>: Show marker as a square.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DIAMOND</code>: Show marker as a diamond.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROUNDED_SQUARE</code>: Show marker as a rounded square.
         * </p>
         * </li>
         * </ul>
         * 
         * @param markerShape
         *        Shape option for markers in the series.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CIRCLE</code>: Show marker as a circle.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRIANGLE</code>: Show marker as a triangle.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SQUARE</code>: Show marker as a square.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DIAMOND</code>: Show marker as a diamond.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROUNDED_SQUARE</code>: Show marker as a rounded square.
         *        </p>
         *        </li>
         * @see LineChartMarkerShape
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineChartMarkerShape
         */
        Builder markerShape(LineChartMarkerShape markerShape);

        /**
         * <p>
         * Size of marker in the series.
         * </p>
         * 
         * @param markerSize
         *        Size of marker in the series.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder markerSize(String markerSize);

        /**
         * <p>
         * Color of marker in the series.
         * </p>
         * 
         * @param markerColor
         *        Color of marker in the series.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder markerColor(String markerColor);
    }

    static final class BuilderImpl implements Builder {
        private String markerVisibility;

        private String markerShape;

        private String markerSize;

        private String markerColor;

        private BuilderImpl() {
        }

        private BuilderImpl(LineChartMarkerStyleSettings model) {
            markerVisibility(model.markerVisibility);
            markerShape(model.markerShape);
            markerSize(model.markerSize);
            markerColor(model.markerColor);
        }

        public final String getMarkerVisibility() {
            return markerVisibility;
        }

        public final void setMarkerVisibility(String markerVisibility) {
            this.markerVisibility = markerVisibility;
        }

        @Override
        public final Builder markerVisibility(String markerVisibility) {
            this.markerVisibility = markerVisibility;
            return this;
        }

        @Override
        public final Builder markerVisibility(Visibility markerVisibility) {
            this.markerVisibility(markerVisibility == null ? null : markerVisibility.toString());
            return this;
        }

        public final String getMarkerShape() {
            return markerShape;
        }

        public final void setMarkerShape(String markerShape) {
            this.markerShape = markerShape;
        }

        @Override
        public final Builder markerShape(String markerShape) {
            this.markerShape = markerShape;
            return this;
        }

        @Override
        public final Builder markerShape(LineChartMarkerShape markerShape) {
            this.markerShape(markerShape == null ? null : markerShape.toString());
            return this;
        }

        public final String getMarkerSize() {
            return markerSize;
        }

        public final void setMarkerSize(String markerSize) {
            this.markerSize = markerSize;
        }

        @Override
        public final Builder markerSize(String markerSize) {
            this.markerSize = markerSize;
            return this;
        }

        public final String getMarkerColor() {
            return markerColor;
        }

        public final void setMarkerColor(String markerColor) {
            this.markerColor = markerColor;
        }

        @Override
        public final Builder markerColor(String markerColor) {
            this.markerColor = markerColor;
            return this;
        }

        @Override
        public LineChartMarkerStyleSettings build() {
            return new LineChartMarkerStyleSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
