/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field well configuration of a line chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineChartFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<LineChartFieldWells.Builder, LineChartFieldWells> {
    private static final SdkField<LineChartAggregatedFieldWells> LINE_CHART_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<LineChartAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("LineChartAggregatedFieldWells")
            .getter(getter(LineChartFieldWells::lineChartAggregatedFieldWells))
            .setter(setter(Builder::lineChartAggregatedFieldWells))
            .constructor(LineChartAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineChartAggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LINE_CHART_AGGREGATED_FIELD_WELLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LineChartAggregatedFieldWells lineChartAggregatedFieldWells;

    private LineChartFieldWells(BuilderImpl builder) {
        this.lineChartAggregatedFieldWells = builder.lineChartAggregatedFieldWells;
    }

    /**
     * <p>
     * The field well configuration of a line chart.
     * </p>
     * 
     * @return The field well configuration of a line chart.
     */
    public final LineChartAggregatedFieldWells lineChartAggregatedFieldWells() {
        return lineChartAggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lineChartAggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineChartFieldWells)) {
            return false;
        }
        LineChartFieldWells other = (LineChartFieldWells) obj;
        return Objects.equals(lineChartAggregatedFieldWells(), other.lineChartAggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineChartFieldWells").add("LineChartAggregatedFieldWells", lineChartAggregatedFieldWells())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LineChartAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(lineChartAggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LineChartAggregatedFieldWells", LINE_CHART_AGGREGATED_FIELD_WELLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineChartFieldWells, T> g) {
        return obj -> g.apply((LineChartFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineChartFieldWells> {
        /**
         * <p>
         * The field well configuration of a line chart.
         * </p>
         * 
         * @param lineChartAggregatedFieldWells
         *        The field well configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineChartAggregatedFieldWells(LineChartAggregatedFieldWells lineChartAggregatedFieldWells);

        /**
         * <p>
         * The field well configuration of a line chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link LineChartAggregatedFieldWells.Builder}
         * avoiding the need to create one manually via {@link LineChartAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LineChartAggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to {@link #lineChartAggregatedFieldWells(LineChartAggregatedFieldWells)}.
         * 
         * @param lineChartAggregatedFieldWells
         *        a consumer that will call methods on {@link LineChartAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineChartAggregatedFieldWells(LineChartAggregatedFieldWells)
         */
        default Builder lineChartAggregatedFieldWells(
                Consumer<LineChartAggregatedFieldWells.Builder> lineChartAggregatedFieldWells) {
            return lineChartAggregatedFieldWells(LineChartAggregatedFieldWells.builder()
                    .applyMutation(lineChartAggregatedFieldWells).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LineChartAggregatedFieldWells lineChartAggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(LineChartFieldWells model) {
            lineChartAggregatedFieldWells(model.lineChartAggregatedFieldWells);
        }

        public final LineChartAggregatedFieldWells.Builder getLineChartAggregatedFieldWells() {
            return lineChartAggregatedFieldWells != null ? lineChartAggregatedFieldWells.toBuilder() : null;
        }

        public final void setLineChartAggregatedFieldWells(LineChartAggregatedFieldWells.BuilderImpl lineChartAggregatedFieldWells) {
            this.lineChartAggregatedFieldWells = lineChartAggregatedFieldWells != null ? lineChartAggregatedFieldWells.build()
                    : null;
        }

        @Override
        public final Builder lineChartAggregatedFieldWells(LineChartAggregatedFieldWells lineChartAggregatedFieldWells) {
            this.lineChartAggregatedFieldWells = lineChartAggregatedFieldWells;
            return this;
        }

        @Override
        public LineChartFieldWells build() {
            return new LineChartFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
