/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The image set configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageSetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageSetConfiguration.Builder, ImageSetConfiguration> {
    private static final SdkField<ImageConfiguration> ORIGINAL_FIELD = SdkField
            .<ImageConfiguration> builder(MarshallingType.SDK_POJO).memberName("Original")
            .getter(getter(ImageSetConfiguration::original)).setter(setter(Builder::original))
            .constructor(ImageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Original").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGINAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ImageConfiguration original;

    private ImageSetConfiguration(BuilderImpl builder) {
        this.original = builder.original;
    }

    /**
     * <p>
     * The original image.
     * </p>
     * 
     * @return The original image.
     */
    public final ImageConfiguration original() {
        return original;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(original());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageSetConfiguration)) {
            return false;
        }
        ImageSetConfiguration other = (ImageSetConfiguration) obj;
        return Objects.equals(original(), other.original());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageSetConfiguration").add("Original", original()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Original":
            return Optional.ofNullable(clazz.cast(original()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Original", ORIGINAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageSetConfiguration, T> g) {
        return obj -> g.apply((ImageSetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageSetConfiguration> {
        /**
         * <p>
         * The original image.
         * </p>
         * 
         * @param original
         *        The original image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder original(ImageConfiguration original);

        /**
         * <p>
         * The original image.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageConfiguration.Builder} avoiding the
         * need to create one manually via {@link ImageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #original(ImageConfiguration)}.
         * 
         * @param original
         *        a consumer that will call methods on {@link ImageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #original(ImageConfiguration)
         */
        default Builder original(Consumer<ImageConfiguration.Builder> original) {
            return original(ImageConfiguration.builder().applyMutation(original).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImageConfiguration original;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageSetConfiguration model) {
            original(model.original);
        }

        public final ImageConfiguration.Builder getOriginal() {
            return original != null ? original.toBuilder() : null;
        }

        public final void setOriginal(ImageConfiguration.BuilderImpl original) {
            this.original = original != null ? original.build() : null;
        }

        @Override
        public final Builder original(ImageConfiguration original) {
            this.original = original;
            return this;
        }

        @Override
        public ImageSetConfiguration build() {
            return new ImageSetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
