/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The aggregated field wells of a heat map.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HeatMapAggregatedFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<HeatMapAggregatedFieldWells.Builder, HeatMapAggregatedFieldWells> {
    private static final SdkField<List<DimensionField>> ROWS_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Rows")
            .getter(getter(HeatMapAggregatedFieldWells::rows))
            .setter(setter(Builder::rows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DimensionField>> COLUMNS_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Columns")
            .getter(getter(HeatMapAggregatedFieldWells::columns))
            .setter(setter(Builder::columns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MeasureField>> VALUES_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(HeatMapAggregatedFieldWells::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROWS_FIELD, COLUMNS_FIELD,
            VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DimensionField> rows;

    private final List<DimensionField> columns;

    private final List<MeasureField> values;

    private HeatMapAggregatedFieldWells(BuilderImpl builder) {
        this.rows = builder.rows;
        this.columns = builder.columns;
        this.values = builder.values;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rows property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRows() {
        return rows != null && !(rows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rows field well of a heat map.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRows} method.
     * </p>
     * 
     * @return The rows field well of a heat map.
     */
    public final List<DimensionField> rows() {
        return rows;
    }

    /**
     * For responses, this returns true if the service returned a value for the Columns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColumns() {
        return columns != null && !(columns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The columns field well of a heat map.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumns} method.
     * </p>
     * 
     * @return The columns field well of a heat map.
     */
    public final List<DimensionField> columns() {
        return columns;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values field well of a heat map.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The values field well of a heat map.
     */
    public final List<MeasureField> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRows() ? rows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasColumns() ? columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeatMapAggregatedFieldWells)) {
            return false;
        }
        HeatMapAggregatedFieldWells other = (HeatMapAggregatedFieldWells) obj;
        return hasRows() == other.hasRows() && Objects.equals(rows(), other.rows()) && hasColumns() == other.hasColumns()
                && Objects.equals(columns(), other.columns()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HeatMapAggregatedFieldWells").add("Rows", hasRows() ? rows() : null)
                .add("Columns", hasColumns() ? columns() : null).add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rows":
            return Optional.ofNullable(clazz.cast(rows()));
        case "Columns":
            return Optional.ofNullable(clazz.cast(columns()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Rows", ROWS_FIELD);
        map.put("Columns", COLUMNS_FIELD);
        map.put("Values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HeatMapAggregatedFieldWells, T> g) {
        return obj -> g.apply((HeatMapAggregatedFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HeatMapAggregatedFieldWells> {
        /**
         * <p>
         * The rows field well of a heat map.
         * </p>
         * 
         * @param rows
         *        The rows field well of a heat map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Collection<DimensionField> rows);

        /**
         * <p>
         * The rows field well of a heat map.
         * </p>
         * 
         * @param rows
         *        The rows field well of a heat map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(DimensionField... rows);

        /**
         * <p>
         * The rows field well of a heat map.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #rows(List<DimensionField>)}.
         * 
         * @param rows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rows(java.util.Collection<DimensionField>)
         */
        Builder rows(Consumer<DimensionField.Builder>... rows);

        /**
         * <p>
         * The columns field well of a heat map.
         * </p>
         * 
         * @param columns
         *        The columns field well of a heat map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(Collection<DimensionField> columns);

        /**
         * <p>
         * The columns field well of a heat map.
         * </p>
         * 
         * @param columns
         *        The columns field well of a heat map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(DimensionField... columns);

        /**
         * <p>
         * The columns field well of a heat map.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #columns(List<DimensionField>)}.
         * 
         * @param columns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columns(java.util.Collection<DimensionField>)
         */
        Builder columns(Consumer<DimensionField.Builder>... columns);

        /**
         * <p>
         * The values field well of a heat map.
         * </p>
         * 
         * @param values
         *        The values field well of a heat map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<MeasureField> values);

        /**
         * <p>
         * The values field well of a heat map.
         * </p>
         * 
         * @param values
         *        The values field well of a heat map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(MeasureField... values);

        /**
         * <p>
         * The values field well of a heat map.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #values(List<MeasureField>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<MeasureField>)
         */
        Builder values(Consumer<MeasureField.Builder>... values);
    }

    static final class BuilderImpl implements Builder {
        private List<DimensionField> rows = DefaultSdkAutoConstructList.getInstance();

        private List<DimensionField> columns = DefaultSdkAutoConstructList.getInstance();

        private List<MeasureField> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HeatMapAggregatedFieldWells model) {
            rows(model.rows);
            columns(model.columns);
            values(model.values);
        }

        public final List<DimensionField.Builder> getRows() {
            List<DimensionField.Builder> result = HeatMapDimensionFieldListCopier.copyToBuilder(this.rows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRows(Collection<DimensionField.BuilderImpl> rows) {
            this.rows = HeatMapDimensionFieldListCopier.copyFromBuilder(rows);
        }

        @Override
        public final Builder rows(Collection<DimensionField> rows) {
            this.rows = HeatMapDimensionFieldListCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(DimensionField... rows) {
            rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<DimensionField.Builder>... rows) {
            rows(Stream.of(rows).map(c -> DimensionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionField.Builder> getColumns() {
            List<DimensionField.Builder> result = HeatMapDimensionFieldListCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<DimensionField.BuilderImpl> columns) {
            this.columns = HeatMapDimensionFieldListCopier.copyFromBuilder(columns);
        }

        @Override
        public final Builder columns(Collection<DimensionField> columns) {
            this.columns = HeatMapDimensionFieldListCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(DimensionField... columns) {
            columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<DimensionField.Builder>... columns) {
            columns(Stream.of(columns).map(c -> DimensionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getValues() {
            List<MeasureField.Builder> result = HeatMapMeasureFieldListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<MeasureField.BuilderImpl> values) {
            this.values = HeatMapMeasureFieldListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<MeasureField> values) {
            this.values = HeatMapMeasureFieldListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(MeasureField... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<MeasureField.Builder>... values) {
            values(Stream.of(values).map(c -> MeasureField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public HeatMapAggregatedFieldWells build() {
            return new HeatMapAggregatedFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
