/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field wells of a <code>GeospatialMapVisual</code>.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialMapFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialMapFieldWells.Builder, GeospatialMapFieldWells> {
    private static final SdkField<GeospatialMapAggregatedFieldWells> GEOSPATIAL_MAP_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<GeospatialMapAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("GeospatialMapAggregatedFieldWells")
            .getter(getter(GeospatialMapFieldWells::geospatialMapAggregatedFieldWells))
            .setter(setter(Builder::geospatialMapAggregatedFieldWells))
            .constructor(GeospatialMapAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeospatialMapAggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GEOSPATIAL_MAP_AGGREGATED_FIELD_WELLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeospatialMapAggregatedFieldWells geospatialMapAggregatedFieldWells;

    private GeospatialMapFieldWells(BuilderImpl builder) {
        this.geospatialMapAggregatedFieldWells = builder.geospatialMapAggregatedFieldWells;
    }

    /**
     * <p>
     * The aggregated field well for a geospatial map.
     * </p>
     * 
     * @return The aggregated field well for a geospatial map.
     */
    public final GeospatialMapAggregatedFieldWells geospatialMapAggregatedFieldWells() {
        return geospatialMapAggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(geospatialMapAggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialMapFieldWells)) {
            return false;
        }
        GeospatialMapFieldWells other = (GeospatialMapFieldWells) obj;
        return Objects.equals(geospatialMapAggregatedFieldWells(), other.geospatialMapAggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialMapFieldWells")
                .add("GeospatialMapAggregatedFieldWells", geospatialMapAggregatedFieldWells()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeospatialMapAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(geospatialMapAggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GeospatialMapAggregatedFieldWells", GEOSPATIAL_MAP_AGGREGATED_FIELD_WELLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialMapFieldWells, T> g) {
        return obj -> g.apply((GeospatialMapFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialMapFieldWells> {
        /**
         * <p>
         * The aggregated field well for a geospatial map.
         * </p>
         * 
         * @param geospatialMapAggregatedFieldWells
         *        The aggregated field well for a geospatial map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geospatialMapAggregatedFieldWells(GeospatialMapAggregatedFieldWells geospatialMapAggregatedFieldWells);

        /**
         * <p>
         * The aggregated field well for a geospatial map.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GeospatialMapAggregatedFieldWells.Builder} avoiding the need to create one manually via
         * {@link GeospatialMapAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialMapAggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #geospatialMapAggregatedFieldWells(GeospatialMapAggregatedFieldWells)}.
         * 
         * @param geospatialMapAggregatedFieldWells
         *        a consumer that will call methods on {@link GeospatialMapAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geospatialMapAggregatedFieldWells(GeospatialMapAggregatedFieldWells)
         */
        default Builder geospatialMapAggregatedFieldWells(
                Consumer<GeospatialMapAggregatedFieldWells.Builder> geospatialMapAggregatedFieldWells) {
            return geospatialMapAggregatedFieldWells(GeospatialMapAggregatedFieldWells.builder()
                    .applyMutation(geospatialMapAggregatedFieldWells).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeospatialMapAggregatedFieldWells geospatialMapAggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialMapFieldWells model) {
            geospatialMapAggregatedFieldWells(model.geospatialMapAggregatedFieldWells);
        }

        public final GeospatialMapAggregatedFieldWells.Builder getGeospatialMapAggregatedFieldWells() {
            return geospatialMapAggregatedFieldWells != null ? geospatialMapAggregatedFieldWells.toBuilder() : null;
        }

        public final void setGeospatialMapAggregatedFieldWells(
                GeospatialMapAggregatedFieldWells.BuilderImpl geospatialMapAggregatedFieldWells) {
            this.geospatialMapAggregatedFieldWells = geospatialMapAggregatedFieldWells != null ? geospatialMapAggregatedFieldWells
                    .build() : null;
        }

        @Override
        public final Builder geospatialMapAggregatedFieldWells(GeospatialMapAggregatedFieldWells geospatialMapAggregatedFieldWells) {
            this.geospatialMapAggregatedFieldWells = geospatialMapAggregatedFieldWells;
            return this;
        }

        @Override
        public GeospatialMapFieldWells build() {
            return new GeospatialMapFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
