/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The visualization properties for solid, gradient, and categorical colors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialColor implements SdkPojo, Serializable, ToCopyableBuilder<GeospatialColor.Builder, GeospatialColor> {
    private static final SdkField<GeospatialSolidColor> SOLID_FIELD = SdkField
            .<GeospatialSolidColor> builder(MarshallingType.SDK_POJO).memberName("Solid").getter(getter(GeospatialColor::solid))
            .setter(setter(Builder::solid)).constructor(GeospatialSolidColor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Solid").build()).build();

    private static final SdkField<GeospatialGradientColor> GRADIENT_FIELD = SdkField
            .<GeospatialGradientColor> builder(MarshallingType.SDK_POJO).memberName("Gradient")
            .getter(getter(GeospatialColor::gradient)).setter(setter(Builder::gradient))
            .constructor(GeospatialGradientColor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gradient").build()).build();

    private static final SdkField<GeospatialCategoricalColor> CATEGORICAL_FIELD = SdkField
            .<GeospatialCategoricalColor> builder(MarshallingType.SDK_POJO).memberName("Categorical")
            .getter(getter(GeospatialColor::categorical)).setter(setter(Builder::categorical))
            .constructor(GeospatialCategoricalColor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categorical").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLID_FIELD, GRADIENT_FIELD,
            CATEGORICAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeospatialSolidColor solid;

    private final GeospatialGradientColor gradient;

    private final GeospatialCategoricalColor categorical;

    private GeospatialColor(BuilderImpl builder) {
        this.solid = builder.solid;
        this.gradient = builder.gradient;
        this.categorical = builder.categorical;
    }

    /**
     * <p>
     * The visualization properties for the solid color.
     * </p>
     * 
     * @return The visualization properties for the solid color.
     */
    public final GeospatialSolidColor solid() {
        return solid;
    }

    /**
     * <p>
     * The visualization properties for the gradient color.
     * </p>
     * 
     * @return The visualization properties for the gradient color.
     */
    public final GeospatialGradientColor gradient() {
        return gradient;
    }

    /**
     * <p>
     * The visualization properties for the categorical color.
     * </p>
     * 
     * @return The visualization properties for the categorical color.
     */
    public final GeospatialCategoricalColor categorical() {
        return categorical;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(solid());
        hashCode = 31 * hashCode + Objects.hashCode(gradient());
        hashCode = 31 * hashCode + Objects.hashCode(categorical());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialColor)) {
            return false;
        }
        GeospatialColor other = (GeospatialColor) obj;
        return Objects.equals(solid(), other.solid()) && Objects.equals(gradient(), other.gradient())
                && Objects.equals(categorical(), other.categorical());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialColor").add("Solid", solid()).add("Gradient", gradient())
                .add("Categorical", categorical()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Solid":
            return Optional.ofNullable(clazz.cast(solid()));
        case "Gradient":
            return Optional.ofNullable(clazz.cast(gradient()));
        case "Categorical":
            return Optional.ofNullable(clazz.cast(categorical()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Solid", SOLID_FIELD);
        map.put("Gradient", GRADIENT_FIELD);
        map.put("Categorical", CATEGORICAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialColor, T> g) {
        return obj -> g.apply((GeospatialColor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialColor> {
        /**
         * <p>
         * The visualization properties for the solid color.
         * </p>
         * 
         * @param solid
         *        The visualization properties for the solid color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solid(GeospatialSolidColor solid);

        /**
         * <p>
         * The visualization properties for the solid color.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialSolidColor.Builder} avoiding
         * the need to create one manually via {@link GeospatialSolidColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialSolidColor.Builder#build()} is called immediately and
         * its result is passed to {@link #solid(GeospatialSolidColor)}.
         * 
         * @param solid
         *        a consumer that will call methods on {@link GeospatialSolidColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #solid(GeospatialSolidColor)
         */
        default Builder solid(Consumer<GeospatialSolidColor.Builder> solid) {
            return solid(GeospatialSolidColor.builder().applyMutation(solid).build());
        }

        /**
         * <p>
         * The visualization properties for the gradient color.
         * </p>
         * 
         * @param gradient
         *        The visualization properties for the gradient color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gradient(GeospatialGradientColor gradient);

        /**
         * <p>
         * The visualization properties for the gradient color.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialGradientColor.Builder} avoiding
         * the need to create one manually via {@link GeospatialGradientColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialGradientColor.Builder#build()} is called immediately
         * and its result is passed to {@link #gradient(GeospatialGradientColor)}.
         * 
         * @param gradient
         *        a consumer that will call methods on {@link GeospatialGradientColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gradient(GeospatialGradientColor)
         */
        default Builder gradient(Consumer<GeospatialGradientColor.Builder> gradient) {
            return gradient(GeospatialGradientColor.builder().applyMutation(gradient).build());
        }

        /**
         * <p>
         * The visualization properties for the categorical color.
         * </p>
         * 
         * @param categorical
         *        The visualization properties for the categorical color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categorical(GeospatialCategoricalColor categorical);

        /**
         * <p>
         * The visualization properties for the categorical color.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialCategoricalColor.Builder}
         * avoiding the need to create one manually via {@link GeospatialCategoricalColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialCategoricalColor.Builder#build()} is called immediately
         * and its result is passed to {@link #categorical(GeospatialCategoricalColor)}.
         * 
         * @param categorical
         *        a consumer that will call methods on {@link GeospatialCategoricalColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categorical(GeospatialCategoricalColor)
         */
        default Builder categorical(Consumer<GeospatialCategoricalColor.Builder> categorical) {
            return categorical(GeospatialCategoricalColor.builder().applyMutation(categorical).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeospatialSolidColor solid;

        private GeospatialGradientColor gradient;

        private GeospatialCategoricalColor categorical;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialColor model) {
            solid(model.solid);
            gradient(model.gradient);
            categorical(model.categorical);
        }

        public final GeospatialSolidColor.Builder getSolid() {
            return solid != null ? solid.toBuilder() : null;
        }

        public final void setSolid(GeospatialSolidColor.BuilderImpl solid) {
            this.solid = solid != null ? solid.build() : null;
        }

        @Override
        public final Builder solid(GeospatialSolidColor solid) {
            this.solid = solid;
            return this;
        }

        public final GeospatialGradientColor.Builder getGradient() {
            return gradient != null ? gradient.toBuilder() : null;
        }

        public final void setGradient(GeospatialGradientColor.BuilderImpl gradient) {
            this.gradient = gradient != null ? gradient.build() : null;
        }

        @Override
        public final Builder gradient(GeospatialGradientColor gradient) {
            this.gradient = gradient;
            return this;
        }

        public final GeospatialCategoricalColor.Builder getCategorical() {
            return categorical != null ? categorical.toBuilder() : null;
        }

        public final void setCategorical(GeospatialCategoricalColor.BuilderImpl categorical) {
            this.categorical = categorical != null ? categorical.build() : null;
        }

        @Override
        public final Builder categorical(GeospatialCategoricalColor categorical) {
            this.categorical = categorical;
            return this;
        }

        @Override
        public GeospatialColor build() {
            return new GeospatialColor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
