/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Conditional formatting options of a <code>GaugeChartVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GaugeChartConditionalFormattingOption implements SdkPojo, Serializable,
        ToCopyableBuilder<GaugeChartConditionalFormattingOption.Builder, GaugeChartConditionalFormattingOption> {
    private static final SdkField<GaugeChartPrimaryValueConditionalFormatting> PRIMARY_VALUE_FIELD = SdkField
            .<GaugeChartPrimaryValueConditionalFormatting> builder(MarshallingType.SDK_POJO).memberName("PrimaryValue")
            .getter(getter(GaugeChartConditionalFormattingOption::primaryValue)).setter(setter(Builder::primaryValue))
            .constructor(GaugeChartPrimaryValueConditionalFormatting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValue").build()).build();

    private static final SdkField<GaugeChartArcConditionalFormatting> ARC_FIELD = SdkField
            .<GaugeChartArcConditionalFormatting> builder(MarshallingType.SDK_POJO).memberName("Arc")
            .getter(getter(GaugeChartConditionalFormattingOption::arc)).setter(setter(Builder::arc))
            .constructor(GaugeChartArcConditionalFormatting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PRIMARY_VALUE_FIELD, ARC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GaugeChartPrimaryValueConditionalFormatting primaryValue;

    private final GaugeChartArcConditionalFormatting arc;

    private GaugeChartConditionalFormattingOption(BuilderImpl builder) {
        this.primaryValue = builder.primaryValue;
        this.arc = builder.arc;
    }

    /**
     * <p>
     * The conditional formatting for the primary value of a <code>GaugeChartVisual</code>.
     * </p>
     * 
     * @return The conditional formatting for the primary value of a <code>GaugeChartVisual</code>.
     */
    public final GaugeChartPrimaryValueConditionalFormatting primaryValue() {
        return primaryValue;
    }

    /**
     * <p>
     * The options that determine the presentation of the arc of a <code>GaugeChartVisual</code>.
     * </p>
     * 
     * @return The options that determine the presentation of the arc of a <code>GaugeChartVisual</code>.
     */
    public final GaugeChartArcConditionalFormatting arc() {
        return arc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryValue());
        hashCode = 31 * hashCode + Objects.hashCode(arc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GaugeChartConditionalFormattingOption)) {
            return false;
        }
        GaugeChartConditionalFormattingOption other = (GaugeChartConditionalFormattingOption) obj;
        return Objects.equals(primaryValue(), other.primaryValue()) && Objects.equals(arc(), other.arc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GaugeChartConditionalFormattingOption").add("PrimaryValue", primaryValue()).add("Arc", arc())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryValue":
            return Optional.ofNullable(clazz.cast(primaryValue()));
        case "Arc":
            return Optional.ofNullable(clazz.cast(arc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrimaryValue", PRIMARY_VALUE_FIELD);
        map.put("Arc", ARC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GaugeChartConditionalFormattingOption, T> g) {
        return obj -> g.apply((GaugeChartConditionalFormattingOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GaugeChartConditionalFormattingOption> {
        /**
         * <p>
         * The conditional formatting for the primary value of a <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param primaryValue
         *        The conditional formatting for the primary value of a <code>GaugeChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValue(GaugeChartPrimaryValueConditionalFormatting primaryValue);

        /**
         * <p>
         * The conditional formatting for the primary value of a <code>GaugeChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GaugeChartPrimaryValueConditionalFormatting.Builder} avoiding the need to create one manually via
         * {@link GaugeChartPrimaryValueConditionalFormatting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GaugeChartPrimaryValueConditionalFormatting.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #primaryValue(GaugeChartPrimaryValueConditionalFormatting)}.
         * 
         * @param primaryValue
         *        a consumer that will call methods on {@link GaugeChartPrimaryValueConditionalFormatting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryValue(GaugeChartPrimaryValueConditionalFormatting)
         */
        default Builder primaryValue(Consumer<GaugeChartPrimaryValueConditionalFormatting.Builder> primaryValue) {
            return primaryValue(GaugeChartPrimaryValueConditionalFormatting.builder().applyMutation(primaryValue).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the arc of a <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param arc
         *        The options that determine the presentation of the arc of a <code>GaugeChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arc(GaugeChartArcConditionalFormatting arc);

        /**
         * <p>
         * The options that determine the presentation of the arc of a <code>GaugeChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GaugeChartArcConditionalFormatting.Builder} avoiding the need to create one manually via
         * {@link GaugeChartArcConditionalFormatting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GaugeChartArcConditionalFormatting.Builder#build()} is called
         * immediately and its result is passed to {@link #arc(GaugeChartArcConditionalFormatting)}.
         * 
         * @param arc
         *        a consumer that will call methods on {@link GaugeChartArcConditionalFormatting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arc(GaugeChartArcConditionalFormatting)
         */
        default Builder arc(Consumer<GaugeChartArcConditionalFormatting.Builder> arc) {
            return arc(GaugeChartArcConditionalFormatting.builder().applyMutation(arc).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GaugeChartPrimaryValueConditionalFormatting primaryValue;

        private GaugeChartArcConditionalFormatting arc;

        private BuilderImpl() {
        }

        private BuilderImpl(GaugeChartConditionalFormattingOption model) {
            primaryValue(model.primaryValue);
            arc(model.arc);
        }

        public final GaugeChartPrimaryValueConditionalFormatting.Builder getPrimaryValue() {
            return primaryValue != null ? primaryValue.toBuilder() : null;
        }

        public final void setPrimaryValue(GaugeChartPrimaryValueConditionalFormatting.BuilderImpl primaryValue) {
            this.primaryValue = primaryValue != null ? primaryValue.build() : null;
        }

        @Override
        public final Builder primaryValue(GaugeChartPrimaryValueConditionalFormatting primaryValue) {
            this.primaryValue = primaryValue;
            return this;
        }

        public final GaugeChartArcConditionalFormatting.Builder getArc() {
            return arc != null ? arc.toBuilder() : null;
        }

        public final void setArc(GaugeChartArcConditionalFormatting.BuilderImpl arc) {
            this.arc = arc != null ? arc.build() : null;
        }

        @Override
        public final Builder arc(GaugeChartArcConditionalFormatting arc) {
            this.arc = arc;
            return this;
        }

        @Override
        public GaugeChartConditionalFormattingOption build() {
            return new GaugeChartConditionalFormattingOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
