/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the display properties of the given text.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FontConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FontConfiguration.Builder, FontConfiguration> {
    private static final SdkField<FontSize> FONT_SIZE_FIELD = SdkField.<FontSize> builder(MarshallingType.SDK_POJO)
            .memberName("FontSize").getter(getter(FontConfiguration::fontSize)).setter(setter(Builder::fontSize))
            .constructor(FontSize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontSize").build()).build();

    private static final SdkField<String> FONT_DECORATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FontDecoration").getter(getter(FontConfiguration::fontDecorationAsString))
            .setter(setter(Builder::fontDecoration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontDecoration").build()).build();

    private static final SdkField<String> FONT_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FontColor").getter(getter(FontConfiguration::fontColor)).setter(setter(Builder::fontColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontColor").build()).build();

    private static final SdkField<FontWeight> FONT_WEIGHT_FIELD = SdkField.<FontWeight> builder(MarshallingType.SDK_POJO)
            .memberName("FontWeight").getter(getter(FontConfiguration::fontWeight)).setter(setter(Builder::fontWeight))
            .constructor(FontWeight::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontWeight").build()).build();

    private static final SdkField<String> FONT_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FontStyle").getter(getter(FontConfiguration::fontStyleAsString)).setter(setter(Builder::fontStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontStyle").build()).build();

    private static final SdkField<String> FONT_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FontFamily").getter(getter(FontConfiguration::fontFamily)).setter(setter(Builder::fontFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontFamily").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_SIZE_FIELD,
            FONT_DECORATION_FIELD, FONT_COLOR_FIELD, FONT_WEIGHT_FIELD, FONT_STYLE_FIELD, FONT_FAMILY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FontSize fontSize;

    private final String fontDecoration;

    private final String fontColor;

    private final FontWeight fontWeight;

    private final String fontStyle;

    private final String fontFamily;

    private FontConfiguration(BuilderImpl builder) {
        this.fontSize = builder.fontSize;
        this.fontDecoration = builder.fontDecoration;
        this.fontColor = builder.fontColor;
        this.fontWeight = builder.fontWeight;
        this.fontStyle = builder.fontStyle;
        this.fontFamily = builder.fontFamily;
    }

    /**
     * <p>
     * The option that determines the text display size.
     * </p>
     * 
     * @return The option that determines the text display size.
     */
    public final FontSize fontSize() {
        return fontSize;
    }

    /**
     * <p>
     * Determines the appearance of decorative lines on the text.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fontDecoration}
     * will return {@link FontDecoration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fontDecorationAsString}.
     * </p>
     * 
     * @return Determines the appearance of decorative lines on the text.
     * @see FontDecoration
     */
    public final FontDecoration fontDecoration() {
        return FontDecoration.fromValue(fontDecoration);
    }

    /**
     * <p>
     * Determines the appearance of decorative lines on the text.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fontDecoration}
     * will return {@link FontDecoration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fontDecorationAsString}.
     * </p>
     * 
     * @return Determines the appearance of decorative lines on the text.
     * @see FontDecoration
     */
    public final String fontDecorationAsString() {
        return fontDecoration;
    }

    /**
     * <p>
     * Determines the color of the text.
     * </p>
     * 
     * @return Determines the color of the text.
     */
    public final String fontColor() {
        return fontColor;
    }

    /**
     * <p>
     * The option that determines the text display weight, or boldness.
     * </p>
     * 
     * @return The option that determines the text display weight, or boldness.
     */
    public final FontWeight fontWeight() {
        return fontWeight;
    }

    /**
     * <p>
     * Determines the text display face that is inherited by the given font family.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fontStyle} will
     * return {@link FontStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fontStyleAsString}.
     * </p>
     * 
     * @return Determines the text display face that is inherited by the given font family.
     * @see FontStyle
     */
    public final FontStyle fontStyle() {
        return FontStyle.fromValue(fontStyle);
    }

    /**
     * <p>
     * Determines the text display face that is inherited by the given font family.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fontStyle} will
     * return {@link FontStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fontStyleAsString}.
     * </p>
     * 
     * @return Determines the text display face that is inherited by the given font family.
     * @see FontStyle
     */
    public final String fontStyleAsString() {
        return fontStyle;
    }

    /**
     * <p>
     * The font family that you want to use.
     * </p>
     * 
     * @return The font family that you want to use.
     */
    public final String fontFamily() {
        return fontFamily;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fontSize());
        hashCode = 31 * hashCode + Objects.hashCode(fontDecorationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fontColor());
        hashCode = 31 * hashCode + Objects.hashCode(fontWeight());
        hashCode = 31 * hashCode + Objects.hashCode(fontStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fontFamily());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FontConfiguration)) {
            return false;
        }
        FontConfiguration other = (FontConfiguration) obj;
        return Objects.equals(fontSize(), other.fontSize())
                && Objects.equals(fontDecorationAsString(), other.fontDecorationAsString())
                && Objects.equals(fontColor(), other.fontColor()) && Objects.equals(fontWeight(), other.fontWeight())
                && Objects.equals(fontStyleAsString(), other.fontStyleAsString())
                && Objects.equals(fontFamily(), other.fontFamily());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FontConfiguration").add("FontSize", fontSize()).add("FontDecoration", fontDecorationAsString())
                .add("FontColor", fontColor()).add("FontWeight", fontWeight()).add("FontStyle", fontStyleAsString())
                .add("FontFamily", fontFamily()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FontSize":
            return Optional.ofNullable(clazz.cast(fontSize()));
        case "FontDecoration":
            return Optional.ofNullable(clazz.cast(fontDecorationAsString()));
        case "FontColor":
            return Optional.ofNullable(clazz.cast(fontColor()));
        case "FontWeight":
            return Optional.ofNullable(clazz.cast(fontWeight()));
        case "FontStyle":
            return Optional.ofNullable(clazz.cast(fontStyleAsString()));
        case "FontFamily":
            return Optional.ofNullable(clazz.cast(fontFamily()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FontSize", FONT_SIZE_FIELD);
        map.put("FontDecoration", FONT_DECORATION_FIELD);
        map.put("FontColor", FONT_COLOR_FIELD);
        map.put("FontWeight", FONT_WEIGHT_FIELD);
        map.put("FontStyle", FONT_STYLE_FIELD);
        map.put("FontFamily", FONT_FAMILY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FontConfiguration, T> g) {
        return obj -> g.apply((FontConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FontConfiguration> {
        /**
         * <p>
         * The option that determines the text display size.
         * </p>
         * 
         * @param fontSize
         *        The option that determines the text display size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontSize(FontSize fontSize);

        /**
         * <p>
         * The option that determines the text display size.
         * </p>
         * This is a convenience method that creates an instance of the {@link FontSize.Builder} avoiding the need to
         * create one manually via {@link FontSize#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FontSize.Builder#build()} is called immediately and its result is
         * passed to {@link #fontSize(FontSize)}.
         * 
         * @param fontSize
         *        a consumer that will call methods on {@link FontSize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fontSize(FontSize)
         */
        default Builder fontSize(Consumer<FontSize.Builder> fontSize) {
            return fontSize(FontSize.builder().applyMutation(fontSize).build());
        }

        /**
         * <p>
         * Determines the appearance of decorative lines on the text.
         * </p>
         * 
         * @param fontDecoration
         *        Determines the appearance of decorative lines on the text.
         * @see FontDecoration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FontDecoration
         */
        Builder fontDecoration(String fontDecoration);

        /**
         * <p>
         * Determines the appearance of decorative lines on the text.
         * </p>
         * 
         * @param fontDecoration
         *        Determines the appearance of decorative lines on the text.
         * @see FontDecoration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FontDecoration
         */
        Builder fontDecoration(FontDecoration fontDecoration);

        /**
         * <p>
         * Determines the color of the text.
         * </p>
         * 
         * @param fontColor
         *        Determines the color of the text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontColor(String fontColor);

        /**
         * <p>
         * The option that determines the text display weight, or boldness.
         * </p>
         * 
         * @param fontWeight
         *        The option that determines the text display weight, or boldness.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontWeight(FontWeight fontWeight);

        /**
         * <p>
         * The option that determines the text display weight, or boldness.
         * </p>
         * This is a convenience method that creates an instance of the {@link FontWeight.Builder} avoiding the need to
         * create one manually via {@link FontWeight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FontWeight.Builder#build()} is called immediately and its result
         * is passed to {@link #fontWeight(FontWeight)}.
         * 
         * @param fontWeight
         *        a consumer that will call methods on {@link FontWeight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fontWeight(FontWeight)
         */
        default Builder fontWeight(Consumer<FontWeight.Builder> fontWeight) {
            return fontWeight(FontWeight.builder().applyMutation(fontWeight).build());
        }

        /**
         * <p>
         * Determines the text display face that is inherited by the given font family.
         * </p>
         * 
         * @param fontStyle
         *        Determines the text display face that is inherited by the given font family.
         * @see FontStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FontStyle
         */
        Builder fontStyle(String fontStyle);

        /**
         * <p>
         * Determines the text display face that is inherited by the given font family.
         * </p>
         * 
         * @param fontStyle
         *        Determines the text display face that is inherited by the given font family.
         * @see FontStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FontStyle
         */
        Builder fontStyle(FontStyle fontStyle);

        /**
         * <p>
         * The font family that you want to use.
         * </p>
         * 
         * @param fontFamily
         *        The font family that you want to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontFamily(String fontFamily);
    }

    static final class BuilderImpl implements Builder {
        private FontSize fontSize;

        private String fontDecoration;

        private String fontColor;

        private FontWeight fontWeight;

        private String fontStyle;

        private String fontFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(FontConfiguration model) {
            fontSize(model.fontSize);
            fontDecoration(model.fontDecoration);
            fontColor(model.fontColor);
            fontWeight(model.fontWeight);
            fontStyle(model.fontStyle);
            fontFamily(model.fontFamily);
        }

        public final FontSize.Builder getFontSize() {
            return fontSize != null ? fontSize.toBuilder() : null;
        }

        public final void setFontSize(FontSize.BuilderImpl fontSize) {
            this.fontSize = fontSize != null ? fontSize.build() : null;
        }

        @Override
        public final Builder fontSize(FontSize fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public final String getFontDecoration() {
            return fontDecoration;
        }

        public final void setFontDecoration(String fontDecoration) {
            this.fontDecoration = fontDecoration;
        }

        @Override
        public final Builder fontDecoration(String fontDecoration) {
            this.fontDecoration = fontDecoration;
            return this;
        }

        @Override
        public final Builder fontDecoration(FontDecoration fontDecoration) {
            this.fontDecoration(fontDecoration == null ? null : fontDecoration.toString());
            return this;
        }

        public final String getFontColor() {
            return fontColor;
        }

        public final void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        @Override
        public final Builder fontColor(String fontColor) {
            this.fontColor = fontColor;
            return this;
        }

        public final FontWeight.Builder getFontWeight() {
            return fontWeight != null ? fontWeight.toBuilder() : null;
        }

        public final void setFontWeight(FontWeight.BuilderImpl fontWeight) {
            this.fontWeight = fontWeight != null ? fontWeight.build() : null;
        }

        @Override
        public final Builder fontWeight(FontWeight fontWeight) {
            this.fontWeight = fontWeight;
            return this;
        }

        public final String getFontStyle() {
            return fontStyle;
        }

        public final void setFontStyle(String fontStyle) {
            this.fontStyle = fontStyle;
        }

        @Override
        public final Builder fontStyle(String fontStyle) {
            this.fontStyle = fontStyle;
            return this;
        }

        @Override
        public final Builder fontStyle(FontStyle fontStyle) {
            this.fontStyle(fontStyle == null ? null : fontStyle.toString());
            return this;
        }

        public final String getFontFamily() {
            return fontFamily;
        }

        public final void setFontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
        }

        @Override
        public final Builder fontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
            return this;
        }

        @Override
        public FontConfiguration build() {
            return new FontConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
