/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A control to display a text box that is used to enter a single entry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterTextFieldControl implements SdkPojo, Serializable,
        ToCopyableBuilder<FilterTextFieldControl.Builder, FilterTextFieldControl> {
    private static final SdkField<String> FILTER_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterControlId").getter(getter(FilterTextFieldControl::filterControlId))
            .setter(setter(Builder::filterControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterControlId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(FilterTextFieldControl::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> SOURCE_FILTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceFilterId").getter(getter(FilterTextFieldControl::sourceFilterId))
            .setter(setter(Builder::sourceFilterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFilterId").build()).build();

    private static final SdkField<TextFieldControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField
            .<TextFieldControlDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayOptions")
            .getter(getter(FilterTextFieldControl::displayOptions)).setter(setter(Builder::displayOptions))
            .constructor(TextFieldControlDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CONTROL_ID_FIELD,
            TITLE_FIELD, SOURCE_FILTER_ID_FIELD, DISPLAY_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filterControlId;

    private final String title;

    private final String sourceFilterId;

    private final TextFieldControlDisplayOptions displayOptions;

    private FilterTextFieldControl(BuilderImpl builder) {
        this.filterControlId = builder.filterControlId;
        this.title = builder.title;
        this.sourceFilterId = builder.sourceFilterId;
        this.displayOptions = builder.displayOptions;
    }

    /**
     * <p>
     * The ID of the <code>FilterTextFieldControl</code>.
     * </p>
     * 
     * @return The ID of the <code>FilterTextFieldControl</code>.
     */
    public final String filterControlId() {
        return filterControlId;
    }

    /**
     * <p>
     * The title of the <code>FilterTextFieldControl</code>.
     * </p>
     * 
     * @return The title of the <code>FilterTextFieldControl</code>.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The source filter ID of the <code>FilterTextFieldControl</code>.
     * </p>
     * 
     * @return The source filter ID of the <code>FilterTextFieldControl</code>.
     */
    public final String sourceFilterId() {
        return sourceFilterId;
    }

    /**
     * <p>
     * The display options of a control.
     * </p>
     * 
     * @return The display options of a control.
     */
    public final TextFieldControlDisplayOptions displayOptions() {
        return displayOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterControlId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(displayOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterTextFieldControl)) {
            return false;
        }
        FilterTextFieldControl other = (FilterTextFieldControl) obj;
        return Objects.equals(filterControlId(), other.filterControlId()) && Objects.equals(title(), other.title())
                && Objects.equals(sourceFilterId(), other.sourceFilterId())
                && Objects.equals(displayOptions(), other.displayOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterTextFieldControl").add("FilterControlId", filterControlId()).add("Title", title())
                .add("SourceFilterId", sourceFilterId()).add("DisplayOptions", displayOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterControlId":
            return Optional.ofNullable(clazz.cast(filterControlId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "SourceFilterId":
            return Optional.ofNullable(clazz.cast(sourceFilterId()));
        case "DisplayOptions":
            return Optional.ofNullable(clazz.cast(displayOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FilterControlId", FILTER_CONTROL_ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("SourceFilterId", SOURCE_FILTER_ID_FIELD);
        map.put("DisplayOptions", DISPLAY_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterTextFieldControl, T> g) {
        return obj -> g.apply((FilterTextFieldControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterTextFieldControl> {
        /**
         * <p>
         * The ID of the <code>FilterTextFieldControl</code>.
         * </p>
         * 
         * @param filterControlId
         *        The ID of the <code>FilterTextFieldControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterControlId(String filterControlId);

        /**
         * <p>
         * The title of the <code>FilterTextFieldControl</code>.
         * </p>
         * 
         * @param title
         *        The title of the <code>FilterTextFieldControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The source filter ID of the <code>FilterTextFieldControl</code>.
         * </p>
         * 
         * @param sourceFilterId
         *        The source filter ID of the <code>FilterTextFieldControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFilterId(String sourceFilterId);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * 
         * @param displayOptions
         *        The display options of a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOptions(TextFieldControlDisplayOptions displayOptions);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextFieldControlDisplayOptions.Builder}
         * avoiding the need to create one manually via {@link TextFieldControlDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextFieldControlDisplayOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #displayOptions(TextFieldControlDisplayOptions)}.
         * 
         * @param displayOptions
         *        a consumer that will call methods on {@link TextFieldControlDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayOptions(TextFieldControlDisplayOptions)
         */
        default Builder displayOptions(Consumer<TextFieldControlDisplayOptions.Builder> displayOptions) {
            return displayOptions(TextFieldControlDisplayOptions.builder().applyMutation(displayOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filterControlId;

        private String title;

        private String sourceFilterId;

        private TextFieldControlDisplayOptions displayOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterTextFieldControl model) {
            filterControlId(model.filterControlId);
            title(model.title);
            sourceFilterId(model.sourceFilterId);
            displayOptions(model.displayOptions);
        }

        public final String getFilterControlId() {
            return filterControlId;
        }

        public final void setFilterControlId(String filterControlId) {
            this.filterControlId = filterControlId;
        }

        @Override
        public final Builder filterControlId(String filterControlId) {
            this.filterControlId = filterControlId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSourceFilterId() {
            return sourceFilterId;
        }

        public final void setSourceFilterId(String sourceFilterId) {
            this.sourceFilterId = sourceFilterId;
        }

        @Override
        public final Builder sourceFilterId(String sourceFilterId) {
            this.sourceFilterId = sourceFilterId;
            return this;
        }

        public final TextFieldControlDisplayOptions.Builder getDisplayOptions() {
            return displayOptions != null ? displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(TextFieldControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(TextFieldControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        @Override
        public FilterTextFieldControl build() {
            return new FilterTextFieldControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
