/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIngestionResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeIngestionResponse.Builder, DescribeIngestionResponse> {
    private static final SdkField<Ingestion> INGESTION_FIELD = SdkField.<Ingestion> builder(MarshallingType.SDK_POJO)
            .memberName("Ingestion").getter(getter(DescribeIngestionResponse::ingestion)).setter(setter(Builder::ingestion))
            .constructor(Ingestion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ingestion").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeIngestionResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeIngestionResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGESTION_FIELD,
            REQUEST_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Ingestion ingestion;

    private final String requestId;

    private final Integer status;

    private DescribeIngestionResponse(BuilderImpl builder) {
        super(builder);
        this.ingestion = builder.ingestion;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * Information about the ingestion.
     * </p>
     * 
     * @return Information about the ingestion.
     */
    public final Ingestion ingestion() {
        return ingestion;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ingestion());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIngestionResponse)) {
            return false;
        }
        DescribeIngestionResponse other = (DescribeIngestionResponse) obj;
        return Objects.equals(ingestion(), other.ingestion()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIngestionResponse").add("Ingestion", ingestion()).add("RequestId", requestId())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ingestion":
            return Optional.ofNullable(clazz.cast(ingestion()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Ingestion", INGESTION_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeIngestionResponse, T> g) {
        return obj -> g.apply((DescribeIngestionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIngestionResponse> {
        /**
         * <p>
         * Information about the ingestion.
         * </p>
         * 
         * @param ingestion
         *        Information about the ingestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestion(Ingestion ingestion);

        /**
         * <p>
         * Information about the ingestion.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ingestion.Builder} avoiding the need to
         * create one manually via {@link Ingestion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ingestion.Builder#build()} is called immediately and its result
         * is passed to {@link #ingestion(Ingestion)}.
         * 
         * @param ingestion
         *        a consumer that will call methods on {@link Ingestion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestion(Ingestion)
         */
        default Builder ingestion(Consumer<Ingestion.Builder> ingestion) {
            return ingestion(Ingestion.builder().applyMutation(ingestion).build());
        }

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private Ingestion ingestion;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIngestionResponse model) {
            super(model);
            ingestion(model.ingestion);
            requestId(model.requestId);
            status(model.status);
        }

        public final Ingestion.Builder getIngestion() {
            return ingestion != null ? ingestion.toBuilder() : null;
        }

        public final void setIngestion(Ingestion.BuilderImpl ingestion) {
            this.ingestion = ingestion != null ? ingestion.build() : null;
        }

        @Override
        public final Builder ingestion(Ingestion ingestion) {
            this.ingestion = ingestion;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeIngestionResponse build() {
            return new DescribeIngestionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
