/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetIdentifierDeclaration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetIdentifierDeclaration.Builder, DataSetIdentifierDeclaration> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(DataSetIdentifierDeclaration::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> DATA_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetArn").getter(getter(DataSetIdentifierDeclaration::dataSetArn))
            .setter(setter(Builder::dataSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            DATA_SET_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String identifier;

    private final String dataSetArn;

    private DataSetIdentifierDeclaration(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.dataSetArn = builder.dataSetArn;
    }

    /**
     * <p>
     * The identifier of the data set, typically the data set's name.
     * </p>
     * 
     * @return The identifier of the data set, typically the data set's name.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the data set.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the data set.
     */
    public final String dataSetArn() {
        return dataSetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetIdentifierDeclaration)) {
            return false;
        }
        DataSetIdentifierDeclaration other = (DataSetIdentifierDeclaration) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(dataSetArn(), other.dataSetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetIdentifierDeclaration").add("Identifier", identifier()).add("DataSetArn", dataSetArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "DataSetArn":
            return Optional.ofNullable(clazz.cast(dataSetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("DataSetArn", DATA_SET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetIdentifierDeclaration, T> g) {
        return obj -> g.apply((DataSetIdentifierDeclaration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetIdentifierDeclaration> {
        /**
         * <p>
         * The identifier of the data set, typically the data set's name.
         * </p>
         * 
         * @param identifier
         *        The identifier of the data set, typically the data set's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the data set.
         * </p>
         * 
         * @param dataSetArn
         *        The Amazon Resource Name (ARN) of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetArn(String dataSetArn);
    }

    static final class BuilderImpl implements Builder {
        private String identifier;

        private String dataSetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetIdentifierDeclaration model) {
            identifier(model.identifier);
            dataSetArn(model.dataSetArn);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getDataSetArn() {
            return dataSetArn;
        }

        public final void setDataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
        }

        @Override
        public final Builder dataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
            return this;
        }

        @Override
        public DataSetIdentifierDeclaration build() {
            return new DataSetIdentifierDeclaration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
