/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A column of a data set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<ColumnIdentifier.Builder, ColumnIdentifier> {
    private static final SdkField<String> DATA_SET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetIdentifier").getter(getter(ColumnIdentifier::dataSetIdentifier))
            .setter(setter(Builder::dataSetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetIdentifier").build()).build();

    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnName").getter(getter(ColumnIdentifier::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_IDENTIFIER_FIELD,
            COLUMN_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataSetIdentifier;

    private final String columnName;

    private ColumnIdentifier(BuilderImpl builder) {
        this.dataSetIdentifier = builder.dataSetIdentifier;
        this.columnName = builder.columnName;
    }

    /**
     * <p>
     * The data set that the column belongs to.
     * </p>
     * 
     * @return The data set that the column belongs to.
     */
    public final String dataSetIdentifier() {
        return dataSetIdentifier;
    }

    /**
     * <p>
     * The name of the column.
     * </p>
     * 
     * @return The name of the column.
     */
    public final String columnName() {
        return columnName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnIdentifier)) {
            return false;
        }
        ColumnIdentifier other = (ColumnIdentifier) obj;
        return Objects.equals(dataSetIdentifier(), other.dataSetIdentifier()) && Objects.equals(columnName(), other.columnName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnIdentifier").add("DataSetIdentifier", dataSetIdentifier()).add("ColumnName", columnName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSetIdentifier":
            return Optional.ofNullable(clazz.cast(dataSetIdentifier()));
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSetIdentifier", DATA_SET_IDENTIFIER_FIELD);
        map.put("ColumnName", COLUMN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnIdentifier, T> g) {
        return obj -> g.apply((ColumnIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnIdentifier> {
        /**
         * <p>
         * The data set that the column belongs to.
         * </p>
         * 
         * @param dataSetIdentifier
         *        The data set that the column belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetIdentifier(String dataSetIdentifier);

        /**
         * <p>
         * The name of the column.
         * </p>
         * 
         * @param columnName
         *        The name of the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);
    }

    static final class BuilderImpl implements Builder {
        private String dataSetIdentifier;

        private String columnName;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnIdentifier model) {
            dataSetIdentifier(model.dataSetIdentifier);
            columnName(model.columnName);
        }

        public final String getDataSetIdentifier() {
            return dataSetIdentifier;
        }

        public final void setDataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
        }

        @Override
        public final Builder dataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
            return this;
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        @Override
        public ColumnIdentifier build() {
            return new ColumnIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
