/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The aggregated field well for a box plot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BoxPlotAggregatedFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<BoxPlotAggregatedFieldWells.Builder, BoxPlotAggregatedFieldWells> {
    private static final SdkField<List<DimensionField>> GROUP_BY_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("GroupBy")
            .getter(getter(BoxPlotAggregatedFieldWells::groupBy))
            .setter(setter(Builder::groupBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MeasureField>> VALUES_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(BoxPlotAggregatedFieldWells::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_FIELD, VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DimensionField> groupBy;

    private final List<MeasureField> values;

    private BoxPlotAggregatedFieldWells(BuilderImpl builder) {
        this.groupBy = builder.groupBy;
        this.values = builder.values;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupBy() {
        return groupBy != null && !(groupBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The group by field well of a box plot chart. Values are grouped based on group by fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupBy} method.
     * </p>
     * 
     * @return The group by field well of a box plot chart. Values are grouped based on group by fields.
     */
    public final List<DimensionField> groupBy() {
        return groupBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value field well of a box plot chart. Values are aggregated based on group by fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The value field well of a box plot chart. Values are aggregated based on group by fields.
     */
    public final List<MeasureField> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupBy() ? groupBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BoxPlotAggregatedFieldWells)) {
            return false;
        }
        BoxPlotAggregatedFieldWells other = (BoxPlotAggregatedFieldWells) obj;
        return hasGroupBy() == other.hasGroupBy() && Objects.equals(groupBy(), other.groupBy())
                && hasValues() == other.hasValues() && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BoxPlotAggregatedFieldWells").add("GroupBy", hasGroupBy() ? groupBy() : null)
                .add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupBy":
            return Optional.ofNullable(clazz.cast(groupBy()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupBy", GROUP_BY_FIELD);
        map.put("Values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BoxPlotAggregatedFieldWells, T> g) {
        return obj -> g.apply((BoxPlotAggregatedFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BoxPlotAggregatedFieldWells> {
        /**
         * <p>
         * The group by field well of a box plot chart. Values are grouped based on group by fields.
         * </p>
         * 
         * @param groupBy
         *        The group by field well of a box plot chart. Values are grouped based on group by fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(Collection<DimensionField> groupBy);

        /**
         * <p>
         * The group by field well of a box plot chart. Values are grouped based on group by fields.
         * </p>
         * 
         * @param groupBy
         *        The group by field well of a box plot chart. Values are grouped based on group by fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(DimensionField... groupBy);

        /**
         * <p>
         * The group by field well of a box plot chart. Values are grouped based on group by fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #groupBy(List<DimensionField>)}.
         * 
         * @param groupBy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupBy(java.util.Collection<DimensionField>)
         */
        Builder groupBy(Consumer<DimensionField.Builder>... groupBy);

        /**
         * <p>
         * The value field well of a box plot chart. Values are aggregated based on group by fields.
         * </p>
         * 
         * @param values
         *        The value field well of a box plot chart. Values are aggregated based on group by fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<MeasureField> values);

        /**
         * <p>
         * The value field well of a box plot chart. Values are aggregated based on group by fields.
         * </p>
         * 
         * @param values
         *        The value field well of a box plot chart. Values are aggregated based on group by fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(MeasureField... values);

        /**
         * <p>
         * The value field well of a box plot chart. Values are aggregated based on group by fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #values(List<MeasureField>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<MeasureField>)
         */
        Builder values(Consumer<MeasureField.Builder>... values);
    }

    static final class BuilderImpl implements Builder {
        private List<DimensionField> groupBy = DefaultSdkAutoConstructList.getInstance();

        private List<MeasureField> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BoxPlotAggregatedFieldWells model) {
            groupBy(model.groupBy);
            values(model.values);
        }

        public final List<DimensionField.Builder> getGroupBy() {
            List<DimensionField.Builder> result = BoxPlotDimensionFieldListCopier.copyToBuilder(this.groupBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupBy(Collection<DimensionField.BuilderImpl> groupBy) {
            this.groupBy = BoxPlotDimensionFieldListCopier.copyFromBuilder(groupBy);
        }

        @Override
        public final Builder groupBy(Collection<DimensionField> groupBy) {
            this.groupBy = BoxPlotDimensionFieldListCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(DimensionField... groupBy) {
            groupBy(Arrays.asList(groupBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(Consumer<DimensionField.Builder>... groupBy) {
            groupBy(Stream.of(groupBy).map(c -> DimensionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getValues() {
            List<MeasureField.Builder> result = BoxPlotMeasureFieldListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<MeasureField.BuilderImpl> values) {
            this.values = BoxPlotMeasureFieldListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<MeasureField> values) {
            this.values = BoxPlotMeasureFieldListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(MeasureField... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<MeasureField.Builder>... values) {
            values(Stream.of(values).map(c -> MeasureField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BoxPlotAggregatedFieldWells build() {
            return new BoxPlotAggregatedFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
