/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the <b>Category</b> dataset column and constraints for the dynamic values used to repeat the contents of a
 * section.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BodySectionDynamicCategoryDimensionConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<BodySectionDynamicCategoryDimensionConfiguration.Builder, BodySectionDynamicCategoryDimensionConfiguration> {
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(BodySectionDynamicCategoryDimensionConfiguration::column))
            .setter(setter(Builder::column)).constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(BodySectionDynamicCategoryDimensionConfiguration::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<List<ColumnSort>> SORT_BY_METRICS_FIELD = SdkField
            .<List<ColumnSort>> builder(MarshallingType.LIST)
            .memberName("SortByMetrics")
            .getter(getter(BodySectionDynamicCategoryDimensionConfiguration::sortByMetrics))
            .setter(setter(Builder::sortByMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortByMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnSort> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnSort::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, LIMIT_FIELD,
            SORT_BY_METRICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ColumnIdentifier column;

    private final Integer limit;

    private final List<ColumnSort> sortByMetrics;

    private BodySectionDynamicCategoryDimensionConfiguration(BuilderImpl builder) {
        this.column = builder.column;
        this.limit = builder.limit;
        this.sortByMetrics = builder.sortByMetrics;
    }

    /**
     * Returns the value of the Column property for this object.
     * 
     * @return The value of the Column property for this object.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * Number of values to use from the column for repetition.
     * </p>
     * 
     * @return Number of values to use from the column for repetition.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * For responses, this returns true if the service returned a value for the SortByMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSortByMetrics() {
        return sortByMetrics != null && !(sortByMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Sort criteria on the column values that you use for repetition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSortByMetrics} method.
     * </p>
     * 
     * @return Sort criteria on the column values that you use for repetition.
     */
    public final List<ColumnSort> sortByMetrics() {
        return sortByMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(hasSortByMetrics() ? sortByMetrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BodySectionDynamicCategoryDimensionConfiguration)) {
            return false;
        }
        BodySectionDynamicCategoryDimensionConfiguration other = (BodySectionDynamicCategoryDimensionConfiguration) obj;
        return Objects.equals(column(), other.column()) && Objects.equals(limit(), other.limit())
                && hasSortByMetrics() == other.hasSortByMetrics() && Objects.equals(sortByMetrics(), other.sortByMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BodySectionDynamicCategoryDimensionConfiguration").add("Column", column()).add("Limit", limit())
                .add("SortByMetrics", hasSortByMetrics() ? sortByMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "SortByMetrics":
            return Optional.ofNullable(clazz.cast(sortByMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Column", COLUMN_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("SortByMetrics", SORT_BY_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BodySectionDynamicCategoryDimensionConfiguration, T> g) {
        return obj -> g.apply((BodySectionDynamicCategoryDimensionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BodySectionDynamicCategoryDimensionConfiguration> {
        /**
         * Sets the value of the Column property for this object.
         *
         * @param column
         *        The new value for the Column property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * Sets the value of the Column property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * Number of values to use from the column for repetition.
         * </p>
         * 
         * @param limit
         *        Number of values to use from the column for repetition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Sort criteria on the column values that you use for repetition.
         * </p>
         * 
         * @param sortByMetrics
         *        Sort criteria on the column values that you use for repetition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortByMetrics(Collection<ColumnSort> sortByMetrics);

        /**
         * <p>
         * Sort criteria on the column values that you use for repetition.
         * </p>
         * 
         * @param sortByMetrics
         *        Sort criteria on the column values that you use for repetition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortByMetrics(ColumnSort... sortByMetrics);

        /**
         * <p>
         * Sort criteria on the column values that you use for repetition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnSort.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.ColumnSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnSort.Builder#build()} is called immediately and
         * its result is passed to {@link #sortByMetrics(List<ColumnSort>)}.
         * 
         * @param sortByMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ColumnSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortByMetrics(java.util.Collection<ColumnSort>)
         */
        Builder sortByMetrics(Consumer<ColumnSort.Builder>... sortByMetrics);
    }

    static final class BuilderImpl implements Builder {
        private ColumnIdentifier column;

        private Integer limit;

        private List<ColumnSort> sortByMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BodySectionDynamicCategoryDimensionConfiguration model) {
            column(model.column);
            limit(model.limit);
            sortByMetrics(model.sortByMetrics);
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final List<ColumnSort.Builder> getSortByMetrics() {
            List<ColumnSort.Builder> result = BodySectionDynamicDimensionSortConfigurationListCopier
                    .copyToBuilder(this.sortByMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortByMetrics(Collection<ColumnSort.BuilderImpl> sortByMetrics) {
            this.sortByMetrics = BodySectionDynamicDimensionSortConfigurationListCopier.copyFromBuilder(sortByMetrics);
        }

        @Override
        public final Builder sortByMetrics(Collection<ColumnSort> sortByMetrics) {
            this.sortByMetrics = BodySectionDynamicDimensionSortConfigurationListCopier.copy(sortByMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortByMetrics(ColumnSort... sortByMetrics) {
            sortByMetrics(Arrays.asList(sortByMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortByMetrics(Consumer<ColumnSort.Builder>... sortByMetrics) {
            sortByMetrics(Stream.of(sortByMetrics).map(c -> ColumnSort.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BodySectionDynamicCategoryDimensionConfiguration build() {
            return new BodySectionDynamicCategoryDimensionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
