/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The logarithmic axis scale setup.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AxisLogarithmicScale implements SdkPojo, Serializable,
        ToCopyableBuilder<AxisLogarithmicScale.Builder, AxisLogarithmicScale> {
    private static final SdkField<Double> BASE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Base")
            .getter(getter(AxisLogarithmicScale::base)).setter(setter(Builder::base))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Base").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double base;

    private AxisLogarithmicScale(BuilderImpl builder) {
        this.base = builder.base;
    }

    /**
     * <p>
     * The base setup of a logarithmic axis scale.
     * </p>
     * 
     * @return The base setup of a logarithmic axis scale.
     */
    public final Double base() {
        return base;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(base());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AxisLogarithmicScale)) {
            return false;
        }
        AxisLogarithmicScale other = (AxisLogarithmicScale) obj;
        return Objects.equals(base(), other.base());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AxisLogarithmicScale").add("Base", base()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Base":
            return Optional.ofNullable(clazz.cast(base()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Base", BASE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AxisLogarithmicScale, T> g) {
        return obj -> g.apply((AxisLogarithmicScale) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AxisLogarithmicScale> {
        /**
         * <p>
         * The base setup of a logarithmic axis scale.
         * </p>
         * 
         * @param base
         *        The base setup of a logarithmic axis scale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder base(Double base);
    }

    static final class BuilderImpl implements Builder {
        private Double base;

        private BuilderImpl() {
        }

        private BuilderImpl(AxisLogarithmicScale model) {
            base(model.base);
        }

        public final Double getBase() {
            return base;
        }

        public final void setBase(Double base) {
            this.base = base;
        }

        @Override
        public final Builder base(Double base) {
            this.base = base;
            return this;
        }

        @Override
        public AxisLogarithmicScale build() {
            return new AxisLogarithmicScale(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
