/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Aggregation for attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeAggregationFunction implements SdkPojo, Serializable,
        ToCopyableBuilder<AttributeAggregationFunction.Builder, AttributeAggregationFunction> {
    private static final SdkField<String> SIMPLE_ATTRIBUTE_AGGREGATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SimpleAttributeAggregation")
            .getter(getter(AttributeAggregationFunction::simpleAttributeAggregationAsString))
            .setter(setter(Builder::simpleAttributeAggregation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimpleAttributeAggregation").build())
            .build();

    private static final SdkField<String> VALUE_FOR_MULTIPLE_VALUES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueForMultipleValues").getter(getter(AttributeAggregationFunction::valueForMultipleValues))
            .setter(setter(Builder::valueForMultipleValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueForMultipleValues").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SIMPLE_ATTRIBUTE_AGGREGATION_FIELD, VALUE_FOR_MULTIPLE_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String simpleAttributeAggregation;

    private final String valueForMultipleValues;

    private AttributeAggregationFunction(BuilderImpl builder) {
        this.simpleAttributeAggregation = builder.simpleAttributeAggregation;
        this.valueForMultipleValues = builder.valueForMultipleValues;
    }

    /**
     * <p>
     * The built-in aggregation functions for attributes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UNIQUE_VALUE</code>: Returns the unique value for a field, aggregated by the dimension fields.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #simpleAttributeAggregation} will return {@link SimpleAttributeAggregationFunction#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #simpleAttributeAggregationAsString}.
     * </p>
     * 
     * @return The built-in aggregation functions for attributes.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UNIQUE_VALUE</code>: Returns the unique value for a field, aggregated by the dimension fields.
     *         </p>
     *         </li>
     * @see SimpleAttributeAggregationFunction
     */
    public final SimpleAttributeAggregationFunction simpleAttributeAggregation() {
        return SimpleAttributeAggregationFunction.fromValue(simpleAttributeAggregation);
    }

    /**
     * <p>
     * The built-in aggregation functions for attributes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UNIQUE_VALUE</code>: Returns the unique value for a field, aggregated by the dimension fields.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #simpleAttributeAggregation} will return {@link SimpleAttributeAggregationFunction#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #simpleAttributeAggregationAsString}.
     * </p>
     * 
     * @return The built-in aggregation functions for attributes.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UNIQUE_VALUE</code>: Returns the unique value for a field, aggregated by the dimension fields.
     *         </p>
     *         </li>
     * @see SimpleAttributeAggregationFunction
     */
    public final String simpleAttributeAggregationAsString() {
        return simpleAttributeAggregation;
    }

    /**
     * <p>
     * Used by the <code>UNIQUE_VALUE</code> aggregation function. If there are multiple values for the field used by
     * the aggregation, the value for this property will be returned instead. Defaults to '*'.
     * </p>
     * 
     * @return Used by the <code>UNIQUE_VALUE</code> aggregation function. If there are multiple values for the field
     *         used by the aggregation, the value for this property will be returned instead. Defaults to '*'.
     */
    public final String valueForMultipleValues() {
        return valueForMultipleValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(simpleAttributeAggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(valueForMultipleValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeAggregationFunction)) {
            return false;
        }
        AttributeAggregationFunction other = (AttributeAggregationFunction) obj;
        return Objects.equals(simpleAttributeAggregationAsString(), other.simpleAttributeAggregationAsString())
                && Objects.equals(valueForMultipleValues(), other.valueForMultipleValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeAggregationFunction")
                .add("SimpleAttributeAggregation", simpleAttributeAggregationAsString())
                .add("ValueForMultipleValues", valueForMultipleValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SimpleAttributeAggregation":
            return Optional.ofNullable(clazz.cast(simpleAttributeAggregationAsString()));
        case "ValueForMultipleValues":
            return Optional.ofNullable(clazz.cast(valueForMultipleValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SimpleAttributeAggregation", SIMPLE_ATTRIBUTE_AGGREGATION_FIELD);
        map.put("ValueForMultipleValues", VALUE_FOR_MULTIPLE_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeAggregationFunction, T> g) {
        return obj -> g.apply((AttributeAggregationFunction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeAggregationFunction> {
        /**
         * <p>
         * The built-in aggregation functions for attributes.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UNIQUE_VALUE</code>: Returns the unique value for a field, aggregated by the dimension fields.
         * </p>
         * </li>
         * </ul>
         * 
         * @param simpleAttributeAggregation
         *        The built-in aggregation functions for attributes.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UNIQUE_VALUE</code>: Returns the unique value for a field, aggregated by the dimension fields.
         *        </p>
         *        </li>
         * @see SimpleAttributeAggregationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimpleAttributeAggregationFunction
         */
        Builder simpleAttributeAggregation(String simpleAttributeAggregation);

        /**
         * <p>
         * The built-in aggregation functions for attributes.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UNIQUE_VALUE</code>: Returns the unique value for a field, aggregated by the dimension fields.
         * </p>
         * </li>
         * </ul>
         * 
         * @param simpleAttributeAggregation
         *        The built-in aggregation functions for attributes.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UNIQUE_VALUE</code>: Returns the unique value for a field, aggregated by the dimension fields.
         *        </p>
         *        </li>
         * @see SimpleAttributeAggregationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimpleAttributeAggregationFunction
         */
        Builder simpleAttributeAggregation(SimpleAttributeAggregationFunction simpleAttributeAggregation);

        /**
         * <p>
         * Used by the <code>UNIQUE_VALUE</code> aggregation function. If there are multiple values for the field used
         * by the aggregation, the value for this property will be returned instead. Defaults to '*'.
         * </p>
         * 
         * @param valueForMultipleValues
         *        Used by the <code>UNIQUE_VALUE</code> aggregation function. If there are multiple values for the field
         *        used by the aggregation, the value for this property will be returned instead. Defaults to '*'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueForMultipleValues(String valueForMultipleValues);
    }

    static final class BuilderImpl implements Builder {
        private String simpleAttributeAggregation;

        private String valueForMultipleValues;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeAggregationFunction model) {
            simpleAttributeAggregation(model.simpleAttributeAggregation);
            valueForMultipleValues(model.valueForMultipleValues);
        }

        public final String getSimpleAttributeAggregation() {
            return simpleAttributeAggregation;
        }

        public final void setSimpleAttributeAggregation(String simpleAttributeAggregation) {
            this.simpleAttributeAggregation = simpleAttributeAggregation;
        }

        @Override
        public final Builder simpleAttributeAggregation(String simpleAttributeAggregation) {
            this.simpleAttributeAggregation = simpleAttributeAggregation;
            return this;
        }

        @Override
        public final Builder simpleAttributeAggregation(SimpleAttributeAggregationFunction simpleAttributeAggregation) {
            this.simpleAttributeAggregation(simpleAttributeAggregation == null ? null : simpleAttributeAggregation.toString());
            return this;
        }

        public final String getValueForMultipleValues() {
            return valueForMultipleValues;
        }

        public final void setValueForMultipleValues(String valueForMultipleValues) {
            this.valueForMultipleValues = valueForMultipleValues;
        }

        @Override
        public final Builder valueForMultipleValues(String valueForMultipleValues) {
            this.valueForMultipleValues = valueForMultipleValues;
            return this;
        }

        @Override
        public AttributeAggregationFunction build() {
            return new AttributeAggregationFunction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
