/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The override parameters for a single data source that is being imported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleImportJobDataSourceOverrideParameters
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AssetBundleImportJobDataSourceOverrideParameters.Builder, AssetBundleImportJobDataSourceOverrideParameters> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceId").getter(getter(AssetBundleImportJobDataSourceOverrideParameters::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AssetBundleImportJobDataSourceOverrideParameters::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<DataSourceParameters> DATA_SOURCE_PARAMETERS_FIELD = SdkField
            .<DataSourceParameters> builder(MarshallingType.SDK_POJO).memberName("DataSourceParameters")
            .getter(getter(AssetBundleImportJobDataSourceOverrideParameters::dataSourceParameters))
            .setter(setter(Builder::dataSourceParameters)).constructor(DataSourceParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceParameters").build())
            .build();

    private static final SdkField<VpcConnectionProperties> VPC_CONNECTION_PROPERTIES_FIELD = SdkField
            .<VpcConnectionProperties> builder(MarshallingType.SDK_POJO).memberName("VpcConnectionProperties")
            .getter(getter(AssetBundleImportJobDataSourceOverrideParameters::vpcConnectionProperties))
            .setter(setter(Builder::vpcConnectionProperties)).constructor(VpcConnectionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectionProperties").build())
            .build();

    private static final SdkField<SslProperties> SSL_PROPERTIES_FIELD = SdkField
            .<SslProperties> builder(MarshallingType.SDK_POJO).memberName("SslProperties")
            .getter(getter(AssetBundleImportJobDataSourceOverrideParameters::sslProperties))
            .setter(setter(Builder::sslProperties)).constructor(SslProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslProperties").build()).build();

    private static final SdkField<AssetBundleImportJobDataSourceCredentials> CREDENTIALS_FIELD = SdkField
            .<AssetBundleImportJobDataSourceCredentials> builder(MarshallingType.SDK_POJO).memberName("Credentials")
            .getter(getter(AssetBundleImportJobDataSourceOverrideParameters::credentials)).setter(setter(Builder::credentials))
            .constructor(AssetBundleImportJobDataSourceCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD,
            NAME_FIELD, DATA_SOURCE_PARAMETERS_FIELD, VPC_CONNECTION_PROPERTIES_FIELD, SSL_PROPERTIES_FIELD, CREDENTIALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataSourceId;

    private final String name;

    private final DataSourceParameters dataSourceParameters;

    private final VpcConnectionProperties vpcConnectionProperties;

    private final SslProperties sslProperties;

    private final AssetBundleImportJobDataSourceCredentials credentials;

    private AssetBundleImportJobDataSourceOverrideParameters(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.name = builder.name;
        this.dataSourceParameters = builder.dataSourceParameters;
        this.vpcConnectionProperties = builder.vpcConnectionProperties;
        this.sslProperties = builder.sslProperties;
        this.credentials = builder.credentials;
    }

    /**
     * <p>
     * The ID of the data source to apply overrides to.
     * </p>
     * 
     * @return The ID of the data source to apply overrides to.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * A new name for the data source.
     * </p>
     * 
     * @return A new name for the data source.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the DataSourceParameters property for this object.
     * 
     * @return The value of the DataSourceParameters property for this object.
     */
    public final DataSourceParameters dataSourceParameters() {
        return dataSourceParameters;
    }

    /**
     * Returns the value of the VpcConnectionProperties property for this object.
     * 
     * @return The value of the VpcConnectionProperties property for this object.
     */
    public final VpcConnectionProperties vpcConnectionProperties() {
        return vpcConnectionProperties;
    }

    /**
     * Returns the value of the SslProperties property for this object.
     * 
     * @return The value of the SslProperties property for this object.
     */
    public final SslProperties sslProperties() {
        return sslProperties;
    }

    /**
     * <p>
     * An optional structure that provides the credentials to be used to create the imported data source.
     * </p>
     * 
     * @return An optional structure that provides the credentials to be used to create the imported data source.
     */
    public final AssetBundleImportJobDataSourceCredentials credentials() {
        return credentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(sslProperties());
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobDataSourceOverrideParameters)) {
            return false;
        }
        AssetBundleImportJobDataSourceOverrideParameters other = (AssetBundleImportJobDataSourceOverrideParameters) obj;
        return Objects.equals(dataSourceId(), other.dataSourceId()) && Objects.equals(name(), other.name())
                && Objects.equals(dataSourceParameters(), other.dataSourceParameters())
                && Objects.equals(vpcConnectionProperties(), other.vpcConnectionProperties())
                && Objects.equals(sslProperties(), other.sslProperties()) && Objects.equals(credentials(), other.credentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleImportJobDataSourceOverrideParameters").add("DataSourceId", dataSourceId())
                .add("Name", name()).add("DataSourceParameters", dataSourceParameters())
                .add("VpcConnectionProperties", vpcConnectionProperties()).add("SslProperties", sslProperties())
                .add("Credentials", credentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DataSourceParameters":
            return Optional.ofNullable(clazz.cast(dataSourceParameters()));
        case "VpcConnectionProperties":
            return Optional.ofNullable(clazz.cast(vpcConnectionProperties()));
        case "SslProperties":
            return Optional.ofNullable(clazz.cast(sslProperties()));
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("DataSourceParameters", DATA_SOURCE_PARAMETERS_FIELD);
        map.put("VpcConnectionProperties", VPC_CONNECTION_PROPERTIES_FIELD);
        map.put("SslProperties", SSL_PROPERTIES_FIELD);
        map.put("Credentials", CREDENTIALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobDataSourceOverrideParameters, T> g) {
        return obj -> g.apply((AssetBundleImportJobDataSourceOverrideParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleImportJobDataSourceOverrideParameters> {
        /**
         * <p>
         * The ID of the data source to apply overrides to.
         * </p>
         * 
         * @param dataSourceId
         *        The ID of the data source to apply overrides to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * A new name for the data source.
         * </p>
         * 
         * @param name
         *        A new name for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the DataSourceParameters property for this object.
         *
         * @param dataSourceParameters
         *        The new value for the DataSourceParameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceParameters(DataSourceParameters dataSourceParameters);

        /**
         * Sets the value of the DataSourceParameters property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataSourceParameters.Builder} avoiding
         * the need to create one manually via {@link DataSourceParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSourceParameters(DataSourceParameters)}.
         * 
         * @param dataSourceParameters
         *        a consumer that will call methods on {@link DataSourceParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceParameters(DataSourceParameters)
         */
        default Builder dataSourceParameters(Consumer<DataSourceParameters.Builder> dataSourceParameters) {
            return dataSourceParameters(DataSourceParameters.builder().applyMutation(dataSourceParameters).build());
        }

        /**
         * Sets the value of the VpcConnectionProperties property for this object.
         *
         * @param vpcConnectionProperties
         *        The new value for the VpcConnectionProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectionProperties(VpcConnectionProperties vpcConnectionProperties);

        /**
         * Sets the value of the VpcConnectionProperties property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcConnectionProperties.Builder} avoiding
         * the need to create one manually via {@link VpcConnectionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConnectionProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConnectionProperties(VpcConnectionProperties)}.
         * 
         * @param vpcConnectionProperties
         *        a consumer that will call methods on {@link VpcConnectionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConnectionProperties(VpcConnectionProperties)
         */
        default Builder vpcConnectionProperties(Consumer<VpcConnectionProperties.Builder> vpcConnectionProperties) {
            return vpcConnectionProperties(VpcConnectionProperties.builder().applyMutation(vpcConnectionProperties).build());
        }

        /**
         * Sets the value of the SslProperties property for this object.
         *
         * @param sslProperties
         *        The new value for the SslProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslProperties(SslProperties sslProperties);

        /**
         * Sets the value of the SslProperties property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SslProperties.Builder} avoiding the need
         * to create one manually via {@link SslProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SslProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #sslProperties(SslProperties)}.
         * 
         * @param sslProperties
         *        a consumer that will call methods on {@link SslProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sslProperties(SslProperties)
         */
        default Builder sslProperties(Consumer<SslProperties.Builder> sslProperties) {
            return sslProperties(SslProperties.builder().applyMutation(sslProperties).build());
        }

        /**
         * <p>
         * An optional structure that provides the credentials to be used to create the imported data source.
         * </p>
         * 
         * @param credentials
         *        An optional structure that provides the credentials to be used to create the imported data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(AssetBundleImportJobDataSourceCredentials credentials);

        /**
         * <p>
         * An optional structure that provides the credentials to be used to create the imported data source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssetBundleImportJobDataSourceCredentials.Builder} avoiding the need to create one manually via
         * {@link AssetBundleImportJobDataSourceCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetBundleImportJobDataSourceCredentials.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #credentials(AssetBundleImportJobDataSourceCredentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link AssetBundleImportJobDataSourceCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(AssetBundleImportJobDataSourceCredentials)
         */
        default Builder credentials(Consumer<AssetBundleImportJobDataSourceCredentials.Builder> credentials) {
            return credentials(AssetBundleImportJobDataSourceCredentials.builder().applyMutation(credentials).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceId;

        private String name;

        private DataSourceParameters dataSourceParameters;

        private VpcConnectionProperties vpcConnectionProperties;

        private SslProperties sslProperties;

        private AssetBundleImportJobDataSourceCredentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobDataSourceOverrideParameters model) {
            dataSourceId(model.dataSourceId);
            name(model.name);
            dataSourceParameters(model.dataSourceParameters);
            vpcConnectionProperties(model.vpcConnectionProperties);
            sslProperties(model.sslProperties);
            credentials(model.credentials);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DataSourceParameters.Builder getDataSourceParameters() {
            return dataSourceParameters != null ? dataSourceParameters.toBuilder() : null;
        }

        public final void setDataSourceParameters(DataSourceParameters.BuilderImpl dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters != null ? dataSourceParameters.build() : null;
        }

        @Override
        public final Builder dataSourceParameters(DataSourceParameters dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters;
            return this;
        }

        public final VpcConnectionProperties.Builder getVpcConnectionProperties() {
            return vpcConnectionProperties != null ? vpcConnectionProperties.toBuilder() : null;
        }

        public final void setVpcConnectionProperties(VpcConnectionProperties.BuilderImpl vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties != null ? vpcConnectionProperties.build() : null;
        }

        @Override
        public final Builder vpcConnectionProperties(VpcConnectionProperties vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties;
            return this;
        }

        public final SslProperties.Builder getSslProperties() {
            return sslProperties != null ? sslProperties.toBuilder() : null;
        }

        public final void setSslProperties(SslProperties.BuilderImpl sslProperties) {
            this.sslProperties = sslProperties != null ? sslProperties.build() : null;
        }

        @Override
        public final Builder sslProperties(SslProperties sslProperties) {
            this.sslProperties = sslProperties;
            return this;
        }

        public final AssetBundleImportJobDataSourceCredentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(AssetBundleImportJobDataSourceCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(AssetBundleImportJobDataSourceCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public AssetBundleImportJobDataSourceOverrideParameters build() {
            return new AssetBundleImportJobDataSourceOverrideParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
