/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The type of experience you want to embed. For anonymous users, you can embed Amazon QuickSight dashboards.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnonymousUserEmbeddingExperienceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AnonymousUserEmbeddingExperienceConfiguration.Builder, AnonymousUserEmbeddingExperienceConfiguration> {
    private static final SdkField<AnonymousUserDashboardEmbeddingConfiguration> DASHBOARD_FIELD = SdkField
            .<AnonymousUserDashboardEmbeddingConfiguration> builder(MarshallingType.SDK_POJO).memberName("Dashboard")
            .getter(getter(AnonymousUserEmbeddingExperienceConfiguration::dashboard)).setter(setter(Builder::dashboard))
            .constructor(AnonymousUserDashboardEmbeddingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dashboard").build()).build();

    private static final SdkField<AnonymousUserDashboardVisualEmbeddingConfiguration> DASHBOARD_VISUAL_FIELD = SdkField
            .<AnonymousUserDashboardVisualEmbeddingConfiguration> builder(MarshallingType.SDK_POJO).memberName("DashboardVisual")
            .getter(getter(AnonymousUserEmbeddingExperienceConfiguration::dashboardVisual))
            .setter(setter(Builder::dashboardVisual)).constructor(AnonymousUserDashboardVisualEmbeddingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardVisual").build()).build();

    private static final SdkField<AnonymousUserQSearchBarEmbeddingConfiguration> Q_SEARCH_BAR_FIELD = SdkField
            .<AnonymousUserQSearchBarEmbeddingConfiguration> builder(MarshallingType.SDK_POJO).memberName("QSearchBar")
            .getter(getter(AnonymousUserEmbeddingExperienceConfiguration::qSearchBar)).setter(setter(Builder::qSearchBar))
            .constructor(AnonymousUserQSearchBarEmbeddingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QSearchBar").build()).build();

    private static final SdkField<AnonymousUserGenerativeQnAEmbeddingConfiguration> GENERATIVE_QNA_FIELD = SdkField
            .<AnonymousUserGenerativeQnAEmbeddingConfiguration> builder(MarshallingType.SDK_POJO).memberName("GenerativeQnA")
            .getter(getter(AnonymousUserEmbeddingExperienceConfiguration::generativeQnA)).setter(setter(Builder::generativeQnA))
            .constructor(AnonymousUserGenerativeQnAEmbeddingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerativeQnA").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_FIELD,
            DASHBOARD_VISUAL_FIELD, Q_SEARCH_BAR_FIELD, GENERATIVE_QNA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AnonymousUserDashboardEmbeddingConfiguration dashboard;

    private final AnonymousUserDashboardVisualEmbeddingConfiguration dashboardVisual;

    private final AnonymousUserQSearchBarEmbeddingConfiguration qSearchBar;

    private final AnonymousUserGenerativeQnAEmbeddingConfiguration generativeQnA;

    private AnonymousUserEmbeddingExperienceConfiguration(BuilderImpl builder) {
        this.dashboard = builder.dashboard;
        this.dashboardVisual = builder.dashboardVisual;
        this.qSearchBar = builder.qSearchBar;
        this.generativeQnA = builder.generativeQnA;
    }

    /**
     * <p>
     * The type of embedding experience. In this case, Amazon QuickSight dashboards.
     * </p>
     * 
     * @return The type of embedding experience. In this case, Amazon QuickSight dashboards.
     */
    public final AnonymousUserDashboardEmbeddingConfiguration dashboard() {
        return dashboard;
    }

    /**
     * <p>
     * The type of embedding experience. In this case, Amazon QuickSight visuals.
     * </p>
     * 
     * @return The type of embedding experience. In this case, Amazon QuickSight visuals.
     */
    public final AnonymousUserDashboardVisualEmbeddingConfiguration dashboardVisual() {
        return dashboardVisual;
    }

    /**
     * <p>
     * The Q search bar that you want to use for anonymous user embedding.
     * </p>
     * 
     * @return The Q search bar that you want to use for anonymous user embedding.
     */
    public final AnonymousUserQSearchBarEmbeddingConfiguration qSearchBar() {
        return qSearchBar;
    }

    /**
     * <p>
     * The Generative Q&amp;A experience that you want to use for anonymous user embedding.
     * </p>
     * 
     * @return The Generative Q&amp;A experience that you want to use for anonymous user embedding.
     */
    public final AnonymousUserGenerativeQnAEmbeddingConfiguration generativeQnA() {
        return generativeQnA;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashboard());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardVisual());
        hashCode = 31 * hashCode + Objects.hashCode(qSearchBar());
        hashCode = 31 * hashCode + Objects.hashCode(generativeQnA());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnonymousUserEmbeddingExperienceConfiguration)) {
            return false;
        }
        AnonymousUserEmbeddingExperienceConfiguration other = (AnonymousUserEmbeddingExperienceConfiguration) obj;
        return Objects.equals(dashboard(), other.dashboard()) && Objects.equals(dashboardVisual(), other.dashboardVisual())
                && Objects.equals(qSearchBar(), other.qSearchBar()) && Objects.equals(generativeQnA(), other.generativeQnA());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnonymousUserEmbeddingExperienceConfiguration").add("Dashboard", dashboard())
                .add("DashboardVisual", dashboardVisual()).add("QSearchBar", qSearchBar()).add("GenerativeQnA", generativeQnA())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dashboard":
            return Optional.ofNullable(clazz.cast(dashboard()));
        case "DashboardVisual":
            return Optional.ofNullable(clazz.cast(dashboardVisual()));
        case "QSearchBar":
            return Optional.ofNullable(clazz.cast(qSearchBar()));
        case "GenerativeQnA":
            return Optional.ofNullable(clazz.cast(generativeQnA()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Dashboard", DASHBOARD_FIELD);
        map.put("DashboardVisual", DASHBOARD_VISUAL_FIELD);
        map.put("QSearchBar", Q_SEARCH_BAR_FIELD);
        map.put("GenerativeQnA", GENERATIVE_QNA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnonymousUserEmbeddingExperienceConfiguration, T> g) {
        return obj -> g.apply((AnonymousUserEmbeddingExperienceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnonymousUserEmbeddingExperienceConfiguration> {
        /**
         * <p>
         * The type of embedding experience. In this case, Amazon QuickSight dashboards.
         * </p>
         * 
         * @param dashboard
         *        The type of embedding experience. In this case, Amazon QuickSight dashboards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboard(AnonymousUserDashboardEmbeddingConfiguration dashboard);

        /**
         * <p>
         * The type of embedding experience. In this case, Amazon QuickSight dashboards.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AnonymousUserDashboardEmbeddingConfiguration.Builder} avoiding the need to create one manually via
         * {@link AnonymousUserDashboardEmbeddingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnonymousUserDashboardEmbeddingConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #dashboard(AnonymousUserDashboardEmbeddingConfiguration)}.
         * 
         * @param dashboard
         *        a consumer that will call methods on {@link AnonymousUserDashboardEmbeddingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboard(AnonymousUserDashboardEmbeddingConfiguration)
         */
        default Builder dashboard(Consumer<AnonymousUserDashboardEmbeddingConfiguration.Builder> dashboard) {
            return dashboard(AnonymousUserDashboardEmbeddingConfiguration.builder().applyMutation(dashboard).build());
        }

        /**
         * <p>
         * The type of embedding experience. In this case, Amazon QuickSight visuals.
         * </p>
         * 
         * @param dashboardVisual
         *        The type of embedding experience. In this case, Amazon QuickSight visuals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardVisual(AnonymousUserDashboardVisualEmbeddingConfiguration dashboardVisual);

        /**
         * <p>
         * The type of embedding experience. In this case, Amazon QuickSight visuals.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AnonymousUserDashboardVisualEmbeddingConfiguration.Builder} avoiding the need to create one manually
         * via {@link AnonymousUserDashboardVisualEmbeddingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AnonymousUserDashboardVisualEmbeddingConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #dashboardVisual(AnonymousUserDashboardVisualEmbeddingConfiguration)}.
         * 
         * @param dashboardVisual
         *        a consumer that will call methods on
         *        {@link AnonymousUserDashboardVisualEmbeddingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboardVisual(AnonymousUserDashboardVisualEmbeddingConfiguration)
         */
        default Builder dashboardVisual(Consumer<AnonymousUserDashboardVisualEmbeddingConfiguration.Builder> dashboardVisual) {
            return dashboardVisual(AnonymousUserDashboardVisualEmbeddingConfiguration.builder().applyMutation(dashboardVisual)
                    .build());
        }

        /**
         * <p>
         * The Q search bar that you want to use for anonymous user embedding.
         * </p>
         * 
         * @param qSearchBar
         *        The Q search bar that you want to use for anonymous user embedding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qSearchBar(AnonymousUserQSearchBarEmbeddingConfiguration qSearchBar);

        /**
         * <p>
         * The Q search bar that you want to use for anonymous user embedding.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AnonymousUserQSearchBarEmbeddingConfiguration.Builder} avoiding the need to create one manually via
         * {@link AnonymousUserQSearchBarEmbeddingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnonymousUserQSearchBarEmbeddingConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #qSearchBar(AnonymousUserQSearchBarEmbeddingConfiguration)}.
         * 
         * @param qSearchBar
         *        a consumer that will call methods on {@link AnonymousUserQSearchBarEmbeddingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qSearchBar(AnonymousUserQSearchBarEmbeddingConfiguration)
         */
        default Builder qSearchBar(Consumer<AnonymousUserQSearchBarEmbeddingConfiguration.Builder> qSearchBar) {
            return qSearchBar(AnonymousUserQSearchBarEmbeddingConfiguration.builder().applyMutation(qSearchBar).build());
        }

        /**
         * <p>
         * The Generative Q&amp;A experience that you want to use for anonymous user embedding.
         * </p>
         * 
         * @param generativeQnA
         *        The Generative Q&amp;A experience that you want to use for anonymous user embedding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generativeQnA(AnonymousUserGenerativeQnAEmbeddingConfiguration generativeQnA);

        /**
         * <p>
         * The Generative Q&amp;A experience that you want to use for anonymous user embedding.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AnonymousUserGenerativeQnAEmbeddingConfiguration.Builder} avoiding the need to create one manually via
         * {@link AnonymousUserGenerativeQnAEmbeddingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnonymousUserGenerativeQnAEmbeddingConfiguration.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #generativeQnA(AnonymousUserGenerativeQnAEmbeddingConfiguration)}.
         * 
         * @param generativeQnA
         *        a consumer that will call methods on {@link AnonymousUserGenerativeQnAEmbeddingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generativeQnA(AnonymousUserGenerativeQnAEmbeddingConfiguration)
         */
        default Builder generativeQnA(Consumer<AnonymousUserGenerativeQnAEmbeddingConfiguration.Builder> generativeQnA) {
            return generativeQnA(AnonymousUserGenerativeQnAEmbeddingConfiguration.builder().applyMutation(generativeQnA).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AnonymousUserDashboardEmbeddingConfiguration dashboard;

        private AnonymousUserDashboardVisualEmbeddingConfiguration dashboardVisual;

        private AnonymousUserQSearchBarEmbeddingConfiguration qSearchBar;

        private AnonymousUserGenerativeQnAEmbeddingConfiguration generativeQnA;

        private BuilderImpl() {
        }

        private BuilderImpl(AnonymousUserEmbeddingExperienceConfiguration model) {
            dashboard(model.dashboard);
            dashboardVisual(model.dashboardVisual);
            qSearchBar(model.qSearchBar);
            generativeQnA(model.generativeQnA);
        }

        public final AnonymousUserDashboardEmbeddingConfiguration.Builder getDashboard() {
            return dashboard != null ? dashboard.toBuilder() : null;
        }

        public final void setDashboard(AnonymousUserDashboardEmbeddingConfiguration.BuilderImpl dashboard) {
            this.dashboard = dashboard != null ? dashboard.build() : null;
        }

        @Override
        public final Builder dashboard(AnonymousUserDashboardEmbeddingConfiguration dashboard) {
            this.dashboard = dashboard;
            return this;
        }

        public final AnonymousUserDashboardVisualEmbeddingConfiguration.Builder getDashboardVisual() {
            return dashboardVisual != null ? dashboardVisual.toBuilder() : null;
        }

        public final void setDashboardVisual(AnonymousUserDashboardVisualEmbeddingConfiguration.BuilderImpl dashboardVisual) {
            this.dashboardVisual = dashboardVisual != null ? dashboardVisual.build() : null;
        }

        @Override
        public final Builder dashboardVisual(AnonymousUserDashboardVisualEmbeddingConfiguration dashboardVisual) {
            this.dashboardVisual = dashboardVisual;
            return this;
        }

        public final AnonymousUserQSearchBarEmbeddingConfiguration.Builder getQSearchBar() {
            return qSearchBar != null ? qSearchBar.toBuilder() : null;
        }

        public final void setQSearchBar(AnonymousUserQSearchBarEmbeddingConfiguration.BuilderImpl qSearchBar) {
            this.qSearchBar = qSearchBar != null ? qSearchBar.build() : null;
        }

        @Override
        public final Builder qSearchBar(AnonymousUserQSearchBarEmbeddingConfiguration qSearchBar) {
            this.qSearchBar = qSearchBar;
            return this;
        }

        public final AnonymousUserGenerativeQnAEmbeddingConfiguration.Builder getGenerativeQnA() {
            return generativeQnA != null ? generativeQnA.toBuilder() : null;
        }

        public final void setGenerativeQnA(AnonymousUserGenerativeQnAEmbeddingConfiguration.BuilderImpl generativeQnA) {
            this.generativeQnA = generativeQnA != null ? generativeQnA.build() : null;
        }

        @Override
        public final Builder generativeQnA(AnonymousUserGenerativeQnAEmbeddingConfiguration generativeQnA) {
            this.generativeQnA = generativeQnA;
            return this;
        }

        @Override
        public AnonymousUserEmbeddingExperienceConfiguration build() {
            return new AnonymousUserEmbeddingExperienceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
