/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source template of an analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisSourceTemplate implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisSourceTemplate.Builder, AnalysisSourceTemplate> {
    private static final SdkField<List<DataSetReference>> DATA_SET_REFERENCES_FIELD = SdkField
            .<List<DataSetReference>> builder(MarshallingType.LIST)
            .memberName("DataSetReferences")
            .getter(getter(AnalysisSourceTemplate::dataSetReferences))
            .setter(setter(Builder::dataSetReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetReferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSetReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSetReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AnalysisSourceTemplate::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_REFERENCES_FIELD,
            ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DataSetReference> dataSetReferences;

    private final String arn;

    private AnalysisSourceTemplate(BuilderImpl builder) {
        this.dataSetReferences = builder.dataSetReferences;
        this.arn = builder.arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSetReferences property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataSetReferences() {
        return dataSetReferences != null && !(dataSetReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dataset references of the source template of an analysis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSetReferences} method.
     * </p>
     * 
     * @return The dataset references of the source template of an analysis.
     */
    public final List<DataSetReference> dataSetReferences() {
        return dataSetReferences;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source template of an analysis.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source template of an analysis.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSetReferences() ? dataSetReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisSourceTemplate)) {
            return false;
        }
        AnalysisSourceTemplate other = (AnalysisSourceTemplate) obj;
        return hasDataSetReferences() == other.hasDataSetReferences()
                && Objects.equals(dataSetReferences(), other.dataSetReferences()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisSourceTemplate")
                .add("DataSetReferences", hasDataSetReferences() ? dataSetReferences() : null).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSetReferences":
            return Optional.ofNullable(clazz.cast(dataSetReferences()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSetReferences", DATA_SET_REFERENCES_FIELD);
        map.put("Arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisSourceTemplate, T> g) {
        return obj -> g.apply((AnalysisSourceTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisSourceTemplate> {
        /**
         * <p>
         * The dataset references of the source template of an analysis.
         * </p>
         * 
         * @param dataSetReferences
         *        The dataset references of the source template of an analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetReferences(Collection<DataSetReference> dataSetReferences);

        /**
         * <p>
         * The dataset references of the source template of an analysis.
         * </p>
         * 
         * @param dataSetReferences
         *        The dataset references of the source template of an analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetReferences(DataSetReference... dataSetReferences);

        /**
         * <p>
         * The dataset references of the source template of an analysis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DataSetReference.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DataSetReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DataSetReference.Builder#build()} is called
         * immediately and its result is passed to {@link #dataSetReferences(List<DataSetReference>)}.
         * 
         * @param dataSetReferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DataSetReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSetReferences(java.util.Collection<DataSetReference>)
         */
        Builder dataSetReferences(Consumer<DataSetReference.Builder>... dataSetReferences);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source template of an analysis.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the source template of an analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private List<DataSetReference> dataSetReferences = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisSourceTemplate model) {
            dataSetReferences(model.dataSetReferences);
            arn(model.arn);
        }

        public final List<DataSetReference.Builder> getDataSetReferences() {
            List<DataSetReference.Builder> result = DataSetReferenceListCopier.copyToBuilder(this.dataSetReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSetReferences(Collection<DataSetReference.BuilderImpl> dataSetReferences) {
            this.dataSetReferences = DataSetReferenceListCopier.copyFromBuilder(dataSetReferences);
        }

        @Override
        public final Builder dataSetReferences(Collection<DataSetReference> dataSetReferences) {
            this.dataSetReferences = DataSetReferenceListCopier.copy(dataSetReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetReferences(DataSetReference... dataSetReferences) {
            dataSetReferences(Arrays.asList(dataSetReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetReferences(Consumer<DataSetReference.Builder>... dataSetReferences) {
            dataSetReferences(Stream.of(dataSetReferences).map(c -> DataSetReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public AnalysisSourceTemplate build() {
            return new AnalysisSourceTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
