/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CommitMode;
import software.amazon.awssdk.services.quicksight.model.DropDownControlDisplayOptions;
import software.amazon.awssdk.services.quicksight.model.FilterSelectableValues;
import software.amazon.awssdk.services.quicksight.model.SheetControlListType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefaultFilterDropDownControlOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DefaultFilterDropDownControlOptions> {
    private static final SdkField<DropDownControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayOptions").getter(DefaultFilterDropDownControlOptions.getter(DefaultFilterDropDownControlOptions::displayOptions)).setter(DefaultFilterDropDownControlOptions.setter(Builder::displayOptions)).constructor(DropDownControlDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DefaultFilterDropDownControlOptions.getter(DefaultFilterDropDownControlOptions::typeAsString)).setter(DefaultFilterDropDownControlOptions.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<FilterSelectableValues> SELECTABLE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelectableValues").getter(DefaultFilterDropDownControlOptions.getter(DefaultFilterDropDownControlOptions::selectableValues)).setter(DefaultFilterDropDownControlOptions.setter(Builder::selectableValues)).constructor(FilterSelectableValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectableValues").build()}).build();
    private static final SdkField<String> COMMIT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommitMode").getter(DefaultFilterDropDownControlOptions.getter(DefaultFilterDropDownControlOptions::commitModeAsString)).setter(DefaultFilterDropDownControlOptions.setter(Builder::commitMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_OPTIONS_FIELD, TYPE_FIELD, SELECTABLE_VALUES_FIELD, COMMIT_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DefaultFilterDropDownControlOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DropDownControlDisplayOptions displayOptions;
    private final String type;
    private final FilterSelectableValues selectableValues;
    private final String commitMode;

    private DefaultFilterDropDownControlOptions(BuilderImpl builder) {
        this.displayOptions = builder.displayOptions;
        this.type = builder.type;
        this.selectableValues = builder.selectableValues;
        this.commitMode = builder.commitMode;
    }

    public final DropDownControlDisplayOptions displayOptions() {
        return this.displayOptions;
    }

    public final SheetControlListType type() {
        return SheetControlListType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final FilterSelectableValues selectableValues() {
        return this.selectableValues;
    }

    public final CommitMode commitMode() {
        return CommitMode.fromValue(this.commitMode);
    }

    public final String commitModeAsString() {
        return this.commitMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.displayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectableValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultFilterDropDownControlOptions)) {
            return false;
        }
        DefaultFilterDropDownControlOptions other = (DefaultFilterDropDownControlOptions)obj;
        return Objects.equals(this.displayOptions(), other.displayOptions()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.selectableValues(), other.selectableValues()) && Objects.equals(this.commitModeAsString(), other.commitModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DefaultFilterDropDownControlOptions").add("DisplayOptions", (Object)this.displayOptions()).add("Type", (Object)this.typeAsString()).add("SelectableValues", (Object)this.selectableValues()).add("CommitMode", (Object)this.commitModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisplayOptions": {
                return Optional.ofNullable(clazz.cast(this.displayOptions()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SelectableValues": {
                return Optional.ofNullable(clazz.cast(this.selectableValues()));
            }
            case "CommitMode": {
                return Optional.ofNullable(clazz.cast(this.commitModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DisplayOptions", DISPLAY_OPTIONS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("SelectableValues", SELECTABLE_VALUES_FIELD);
        map.put("CommitMode", COMMIT_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultFilterDropDownControlOptions, T> g) {
        return obj -> g.apply((DefaultFilterDropDownControlOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DropDownControlDisplayOptions displayOptions;
        private String type;
        private FilterSelectableValues selectableValues;
        private String commitMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultFilterDropDownControlOptions model) {
            this.displayOptions(model.displayOptions);
            this.type(model.type);
            this.selectableValues(model.selectableValues);
            this.commitMode(model.commitMode);
        }

        public final DropDownControlDisplayOptions.Builder getDisplayOptions() {
            return this.displayOptions != null ? this.displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(DropDownControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(DropDownControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SheetControlListType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final FilterSelectableValues.Builder getSelectableValues() {
            return this.selectableValues != null ? this.selectableValues.toBuilder() : null;
        }

        public final void setSelectableValues(FilterSelectableValues.BuilderImpl selectableValues) {
            this.selectableValues = selectableValues != null ? selectableValues.build() : null;
        }

        @Override
        public final Builder selectableValues(FilterSelectableValues selectableValues) {
            this.selectableValues = selectableValues;
            return this;
        }

        public final String getCommitMode() {
            return this.commitMode;
        }

        public final void setCommitMode(String commitMode) {
            this.commitMode = commitMode;
        }

        @Override
        public final Builder commitMode(String commitMode) {
            this.commitMode = commitMode;
            return this;
        }

        @Override
        public final Builder commitMode(CommitMode commitMode) {
            this.commitMode(commitMode == null ? null : commitMode.toString());
            return this;
        }

        public DefaultFilterDropDownControlOptions build() {
            return new DefaultFilterDropDownControlOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DefaultFilterDropDownControlOptions> {
        public Builder displayOptions(DropDownControlDisplayOptions var1);

        default public Builder displayOptions(Consumer<DropDownControlDisplayOptions.Builder> displayOptions) {
            return this.displayOptions((DropDownControlDisplayOptions)((DropDownControlDisplayOptions.Builder)DropDownControlDisplayOptions.builder().applyMutation(displayOptions)).build());
        }

        public Builder type(String var1);

        public Builder type(SheetControlListType var1);

        public Builder selectableValues(FilterSelectableValues var1);

        default public Builder selectableValues(Consumer<FilterSelectableValues.Builder> selectableValues) {
            return this.selectableValues((FilterSelectableValues)((FilterSelectableValues.Builder)FilterSelectableValues.builder().applyMutation(selectableValues)).build());
        }

        public Builder commitMode(String var1);

        public Builder commitMode(CommitMode var1);
    }
}

