/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.CustomPermissions;
import software.amazon.awssdk.services.quicksight.model.ListCustomPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListCustomPermissionsResponse;

public class ListCustomPermissionsIterable
implements SdkIterable<ListCustomPermissionsResponse> {
    private final QuickSightClient client;
    private final ListCustomPermissionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomPermissionsIterable(QuickSightClient client, ListCustomPermissionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCustomPermissionsResponseFetcher();
    }

    public Iterator<ListCustomPermissionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CustomPermissions> customPermissionsList() {
        Function<ListCustomPermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.customPermissionsList() != null) {
                return response.customPermissionsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCustomPermissionsResponseFetcher
    implements SyncPageFetcher<ListCustomPermissionsResponse> {
        private ListCustomPermissionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomPermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomPermissionsResponse nextPage(ListCustomPermissionsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomPermissionsIterable.this.client.listCustomPermissions(ListCustomPermissionsIterable.this.firstRequest);
            }
            return ListCustomPermissionsIterable.this.client.listCustomPermissions((ListCustomPermissionsRequest)((Object)ListCustomPermissionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

