/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteThemeRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, DeleteThemeRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(DeleteThemeRequest.getter(DeleteThemeRequest::awsAccountId)).setter(DeleteThemeRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> THEME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeId").getter(DeleteThemeRequest.getter(DeleteThemeRequest::themeId)).setter(DeleteThemeRequest.setter(Builder::themeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ThemeId").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VersionNumber").getter(DeleteThemeRequest.getter(DeleteThemeRequest::versionNumber)).setter(DeleteThemeRequest.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version-number").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, THEME_ID_FIELD, VERSION_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteThemeRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String themeId;
    private final Long versionNumber;

    private DeleteThemeRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.themeId = builder.themeId;
        this.versionNumber = builder.versionNumber;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String themeId() {
        return this.themeId;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteThemeRequest)) {
            return false;
        }
        DeleteThemeRequest other = (DeleteThemeRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.themeId(), other.themeId()) && Objects.equals(this.versionNumber(), other.versionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteThemeRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("ThemeId", (Object)this.themeId()).add("VersionNumber", (Object)this.versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "ThemeId": {
                return Optional.ofNullable(clazz.cast(this.themeId()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("ThemeId", THEME_ID_FIELD);
        map.put("version-number", VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteThemeRequest, T> g) {
        return obj -> g.apply((DeleteThemeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String themeId;
        private Long versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteThemeRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.themeId(model.themeId);
            this.versionNumber(model.versionNumber);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getThemeId() {
            return this.themeId;
        }

        public final void setThemeId(String themeId) {
            this.themeId = themeId;
        }

        @Override
        public final Builder themeId(String themeId) {
            this.themeId = themeId;
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteThemeRequest build() {
            return new DeleteThemeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteThemeRequest> {
        public Builder awsAccountId(String var1);

        public Builder themeId(String var1);

        public Builder versionNumber(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

