/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePublicSharingSettingsRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdatePublicSharingSettingsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdatePublicSharingSettingsRequest.getter(UpdatePublicSharingSettingsRequest::awsAccountId)).setter(UpdatePublicSharingSettingsRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<Boolean> PUBLIC_SHARING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PublicSharingEnabled").getter(UpdatePublicSharingSettingsRequest.getter(UpdatePublicSharingSettingsRequest::publicSharingEnabled)).setter(UpdatePublicSharingSettingsRequest.setter(Builder::publicSharingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicSharingEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, PUBLIC_SHARING_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("PublicSharingEnabled", PUBLIC_SHARING_ENABLED_FIELD);
        }
    });
    private final String awsAccountId;
    private final Boolean publicSharingEnabled;

    private UpdatePublicSharingSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.publicSharingEnabled = builder.publicSharingEnabled;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final Boolean publicSharingEnabled() {
        return this.publicSharingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicSharingEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePublicSharingSettingsRequest)) {
            return false;
        }
        UpdatePublicSharingSettingsRequest other = (UpdatePublicSharingSettingsRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.publicSharingEnabled(), other.publicSharingEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePublicSharingSettingsRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("PublicSharingEnabled", (Object)this.publicSharingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "PublicSharingEnabled": {
                return Optional.ofNullable(clazz.cast(this.publicSharingEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePublicSharingSettingsRequest, T> g) {
        return obj -> g.apply((UpdatePublicSharingSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private Boolean publicSharingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePublicSharingSettingsRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.publicSharingEnabled(model.publicSharingEnabled);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Boolean getPublicSharingEnabled() {
            return this.publicSharingEnabled;
        }

        public final void setPublicSharingEnabled(Boolean publicSharingEnabled) {
            this.publicSharingEnabled = publicSharingEnabled;
        }

        @Override
        public final Builder publicSharingEnabled(Boolean publicSharingEnabled) {
            this.publicSharingEnabled = publicSharingEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePublicSharingSettingsRequest build() {
            return new UpdatePublicSharingSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePublicSharingSettingsRequest> {
        public Builder awsAccountId(String var1);

        public Builder publicSharingEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

