/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.FontDecoration;
import software.amazon.awssdk.services.quicksight.model.FontSize;
import software.amazon.awssdk.services.quicksight.model.FontStyle;
import software.amazon.awssdk.services.quicksight.model.FontWeight;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FontConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FontConfiguration> {
    private static final SdkField<FontSize> FONT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FontSize").getter(FontConfiguration.getter(FontConfiguration::fontSize)).setter(FontConfiguration.setter(Builder::fontSize)).constructor(FontSize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontSize").build()}).build();
    private static final SdkField<String> FONT_DECORATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontDecoration").getter(FontConfiguration.getter(FontConfiguration::fontDecorationAsString)).setter(FontConfiguration.setter(Builder::fontDecoration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontDecoration").build()}).build();
    private static final SdkField<String> FONT_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontColor").getter(FontConfiguration.getter(FontConfiguration::fontColor)).setter(FontConfiguration.setter(Builder::fontColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontColor").build()}).build();
    private static final SdkField<FontWeight> FONT_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FontWeight").getter(FontConfiguration.getter(FontConfiguration::fontWeight)).setter(FontConfiguration.setter(Builder::fontWeight)).constructor(FontWeight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontWeight").build()}).build();
    private static final SdkField<String> FONT_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontStyle").getter(FontConfiguration.getter(FontConfiguration::fontStyleAsString)).setter(FontConfiguration.setter(Builder::fontStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontStyle").build()}).build();
    private static final SdkField<String> FONT_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontFamily").getter(FontConfiguration.getter(FontConfiguration::fontFamily)).setter(FontConfiguration.setter(Builder::fontFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontFamily").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_SIZE_FIELD, FONT_DECORATION_FIELD, FONT_COLOR_FIELD, FONT_WEIGHT_FIELD, FONT_STYLE_FIELD, FONT_FAMILY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FontSize", FONT_SIZE_FIELD);
            this.put("FontDecoration", FONT_DECORATION_FIELD);
            this.put("FontColor", FONT_COLOR_FIELD);
            this.put("FontWeight", FONT_WEIGHT_FIELD);
            this.put("FontStyle", FONT_STYLE_FIELD);
            this.put("FontFamily", FONT_FAMILY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final FontSize fontSize;
    private final String fontDecoration;
    private final String fontColor;
    private final FontWeight fontWeight;
    private final String fontStyle;
    private final String fontFamily;

    private FontConfiguration(BuilderImpl builder) {
        this.fontSize = builder.fontSize;
        this.fontDecoration = builder.fontDecoration;
        this.fontColor = builder.fontColor;
        this.fontWeight = builder.fontWeight;
        this.fontStyle = builder.fontStyle;
        this.fontFamily = builder.fontFamily;
    }

    public final FontSize fontSize() {
        return this.fontSize;
    }

    public final FontDecoration fontDecoration() {
        return FontDecoration.fromValue(this.fontDecoration);
    }

    public final String fontDecorationAsString() {
        return this.fontDecoration;
    }

    public final String fontColor() {
        return this.fontColor;
    }

    public final FontWeight fontWeight() {
        return this.fontWeight;
    }

    public final FontStyle fontStyle() {
        return FontStyle.fromValue(this.fontStyle);
    }

    public final String fontStyleAsString() {
        return this.fontStyle;
    }

    public final String fontFamily() {
        return this.fontFamily;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fontSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontDecorationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontWeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontFamily());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FontConfiguration)) {
            return false;
        }
        FontConfiguration other = (FontConfiguration)obj;
        return Objects.equals(this.fontSize(), other.fontSize()) && Objects.equals(this.fontDecorationAsString(), other.fontDecorationAsString()) && Objects.equals(this.fontColor(), other.fontColor()) && Objects.equals(this.fontWeight(), other.fontWeight()) && Objects.equals(this.fontStyleAsString(), other.fontStyleAsString()) && Objects.equals(this.fontFamily(), other.fontFamily());
    }

    public final String toString() {
        return ToString.builder((String)"FontConfiguration").add("FontSize", (Object)this.fontSize()).add("FontDecoration", (Object)this.fontDecorationAsString()).add("FontColor", (Object)this.fontColor()).add("FontWeight", (Object)this.fontWeight()).add("FontStyle", (Object)this.fontStyleAsString()).add("FontFamily", (Object)this.fontFamily()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FontSize": {
                return Optional.ofNullable(clazz.cast(this.fontSize()));
            }
            case "FontDecoration": {
                return Optional.ofNullable(clazz.cast(this.fontDecorationAsString()));
            }
            case "FontColor": {
                return Optional.ofNullable(clazz.cast(this.fontColor()));
            }
            case "FontWeight": {
                return Optional.ofNullable(clazz.cast(this.fontWeight()));
            }
            case "FontStyle": {
                return Optional.ofNullable(clazz.cast(this.fontStyleAsString()));
            }
            case "FontFamily": {
                return Optional.ofNullable(clazz.cast(this.fontFamily()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FontConfiguration, T> g) {
        return obj -> g.apply((FontConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FontSize fontSize;
        private String fontDecoration;
        private String fontColor;
        private FontWeight fontWeight;
        private String fontStyle;
        private String fontFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(FontConfiguration model) {
            this.fontSize(model.fontSize);
            this.fontDecoration(model.fontDecoration);
            this.fontColor(model.fontColor);
            this.fontWeight(model.fontWeight);
            this.fontStyle(model.fontStyle);
            this.fontFamily(model.fontFamily);
        }

        public final FontSize.Builder getFontSize() {
            return this.fontSize != null ? this.fontSize.toBuilder() : null;
        }

        public final void setFontSize(FontSize.BuilderImpl fontSize) {
            this.fontSize = fontSize != null ? fontSize.build() : null;
        }

        @Override
        public final Builder fontSize(FontSize fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public final String getFontDecoration() {
            return this.fontDecoration;
        }

        public final void setFontDecoration(String fontDecoration) {
            this.fontDecoration = fontDecoration;
        }

        @Override
        public final Builder fontDecoration(String fontDecoration) {
            this.fontDecoration = fontDecoration;
            return this;
        }

        @Override
        public final Builder fontDecoration(FontDecoration fontDecoration) {
            this.fontDecoration(fontDecoration == null ? null : fontDecoration.toString());
            return this;
        }

        public final String getFontColor() {
            return this.fontColor;
        }

        public final void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        @Override
        public final Builder fontColor(String fontColor) {
            this.fontColor = fontColor;
            return this;
        }

        public final FontWeight.Builder getFontWeight() {
            return this.fontWeight != null ? this.fontWeight.toBuilder() : null;
        }

        public final void setFontWeight(FontWeight.BuilderImpl fontWeight) {
            this.fontWeight = fontWeight != null ? fontWeight.build() : null;
        }

        @Override
        public final Builder fontWeight(FontWeight fontWeight) {
            this.fontWeight = fontWeight;
            return this;
        }

        public final String getFontStyle() {
            return this.fontStyle;
        }

        public final void setFontStyle(String fontStyle) {
            this.fontStyle = fontStyle;
        }

        @Override
        public final Builder fontStyle(String fontStyle) {
            this.fontStyle = fontStyle;
            return this;
        }

        @Override
        public final Builder fontStyle(FontStyle fontStyle) {
            this.fontStyle(fontStyle == null ? null : fontStyle.toString());
            return this;
        }

        public final String getFontFamily() {
            return this.fontFamily;
        }

        public final void setFontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
        }

        @Override
        public final Builder fontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
            return this;
        }

        public FontConfiguration build() {
            return new FontConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FontConfiguration> {
        public Builder fontSize(FontSize var1);

        default public Builder fontSize(Consumer<FontSize.Builder> fontSize) {
            return this.fontSize((FontSize)((FontSize.Builder)FontSize.builder().applyMutation(fontSize)).build());
        }

        public Builder fontDecoration(String var1);

        public Builder fontDecoration(FontDecoration var1);

        public Builder fontColor(String var1);

        public Builder fontWeight(FontWeight var1);

        default public Builder fontWeight(Consumer<FontWeight.Builder> fontWeight) {
            return this.fontWeight((FontWeight)((FontWeight.Builder)FontWeight.builder().applyMutation(fontWeight)).build());
        }

        public Builder fontStyle(String var1);

        public Builder fontStyle(FontStyle var1);

        public Builder fontFamily(String var1);
    }
}

