/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.SortDirection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FieldSort
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FieldSort> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldId").getter(FieldSort.getter(FieldSort::fieldId)).setter(FieldSort.setter(Builder::fieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()}).build();
    private static final SdkField<String> DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Direction").getter(FieldSort.getter(FieldSort::directionAsString)).setter(FieldSort.setter(Builder::direction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD, DIRECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FieldId", FIELD_ID_FIELD);
            this.put("Direction", DIRECTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String fieldId;
    private final String direction;

    private FieldSort(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.direction = builder.direction;
    }

    public final String fieldId() {
        return this.fieldId;
    }

    public final SortDirection direction() {
        return SortDirection.fromValue(this.direction);
    }

    public final String directionAsString() {
        return this.direction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldSort)) {
            return false;
        }
        FieldSort other = (FieldSort)obj;
        return Objects.equals(this.fieldId(), other.fieldId()) && Objects.equals(this.directionAsString(), other.directionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FieldSort").add("FieldId", (Object)this.fieldId()).add("Direction", (Object)this.directionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldId": {
                return Optional.ofNullable(clazz.cast(this.fieldId()));
            }
            case "Direction": {
                return Optional.ofNullable(clazz.cast(this.directionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FieldSort, T> g) {
        return obj -> g.apply((FieldSort)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldId;
        private String direction;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldSort model) {
            this.fieldId(model.fieldId);
            this.direction(model.direction);
        }

        public final String getFieldId() {
            return this.fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getDirection() {
            return this.direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(SortDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public FieldSort build() {
            return new FieldSort(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FieldSort> {
        public Builder fieldId(String var1);

        public Builder direction(String var1);

        public Builder direction(SortDirection var1);
    }
}

