/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.TooltipItem;
import software.amazon.awssdk.services.quicksight.model.TooltipItemListCopier;
import software.amazon.awssdk.services.quicksight.model.TooltipTitleType;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FieldBasedTooltip
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FieldBasedTooltip> {
    private static final SdkField<String> AGGREGATION_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregationVisibility").getter(FieldBasedTooltip.getter(FieldBasedTooltip::aggregationVisibilityAsString)).setter(FieldBasedTooltip.setter(Builder::aggregationVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationVisibility").build()}).build();
    private static final SdkField<String> TOOLTIP_TITLE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TooltipTitleType").getter(FieldBasedTooltip.getter(FieldBasedTooltip::tooltipTitleTypeAsString)).setter(FieldBasedTooltip.setter(Builder::tooltipTitleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TooltipTitleType").build()}).build();
    private static final SdkField<List<TooltipItem>> TOOLTIP_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TooltipFields").getter(FieldBasedTooltip.getter(FieldBasedTooltip::tooltipFields)).setter(FieldBasedTooltip.setter(Builder::tooltipFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TooltipFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TooltipItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_VISIBILITY_FIELD, TOOLTIP_TITLE_TYPE_FIELD, TOOLTIP_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AggregationVisibility", AGGREGATION_VISIBILITY_FIELD);
            this.put("TooltipTitleType", TOOLTIP_TITLE_TYPE_FIELD);
            this.put("TooltipFields", TOOLTIP_FIELDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String aggregationVisibility;
    private final String tooltipTitleType;
    private final List<TooltipItem> tooltipFields;

    private FieldBasedTooltip(BuilderImpl builder) {
        this.aggregationVisibility = builder.aggregationVisibility;
        this.tooltipTitleType = builder.tooltipTitleType;
        this.tooltipFields = builder.tooltipFields;
    }

    public final Visibility aggregationVisibility() {
        return Visibility.fromValue(this.aggregationVisibility);
    }

    public final String aggregationVisibilityAsString() {
        return this.aggregationVisibility;
    }

    public final TooltipTitleType tooltipTitleType() {
        return TooltipTitleType.fromValue(this.tooltipTitleType);
    }

    public final String tooltipTitleTypeAsString() {
        return this.tooltipTitleType;
    }

    public final boolean hasTooltipFields() {
        return this.tooltipFields != null && !(this.tooltipFields instanceof SdkAutoConstructList);
    }

    public final List<TooltipItem> tooltipFields() {
        return this.tooltipFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tooltipTitleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTooltipFields() ? this.tooltipFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldBasedTooltip)) {
            return false;
        }
        FieldBasedTooltip other = (FieldBasedTooltip)obj;
        return Objects.equals(this.aggregationVisibilityAsString(), other.aggregationVisibilityAsString()) && Objects.equals(this.tooltipTitleTypeAsString(), other.tooltipTitleTypeAsString()) && this.hasTooltipFields() == other.hasTooltipFields() && Objects.equals(this.tooltipFields(), other.tooltipFields());
    }

    public final String toString() {
        return ToString.builder((String)"FieldBasedTooltip").add("AggregationVisibility", (Object)this.aggregationVisibilityAsString()).add("TooltipTitleType", (Object)this.tooltipTitleTypeAsString()).add("TooltipFields", this.hasTooltipFields() ? this.tooltipFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AggregationVisibility": {
                return Optional.ofNullable(clazz.cast(this.aggregationVisibilityAsString()));
            }
            case "TooltipTitleType": {
                return Optional.ofNullable(clazz.cast(this.tooltipTitleTypeAsString()));
            }
            case "TooltipFields": {
                return Optional.ofNullable(clazz.cast(this.tooltipFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FieldBasedTooltip, T> g) {
        return obj -> g.apply((FieldBasedTooltip)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aggregationVisibility;
        private String tooltipTitleType;
        private List<TooltipItem> tooltipFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FieldBasedTooltip model) {
            this.aggregationVisibility(model.aggregationVisibility);
            this.tooltipTitleType(model.tooltipTitleType);
            this.tooltipFields(model.tooltipFields);
        }

        public final String getAggregationVisibility() {
            return this.aggregationVisibility;
        }

        public final void setAggregationVisibility(String aggregationVisibility) {
            this.aggregationVisibility = aggregationVisibility;
        }

        @Override
        public final Builder aggregationVisibility(String aggregationVisibility) {
            this.aggregationVisibility = aggregationVisibility;
            return this;
        }

        @Override
        public final Builder aggregationVisibility(Visibility aggregationVisibility) {
            this.aggregationVisibility(aggregationVisibility == null ? null : aggregationVisibility.toString());
            return this;
        }

        public final String getTooltipTitleType() {
            return this.tooltipTitleType;
        }

        public final void setTooltipTitleType(String tooltipTitleType) {
            this.tooltipTitleType = tooltipTitleType;
        }

        @Override
        public final Builder tooltipTitleType(String tooltipTitleType) {
            this.tooltipTitleType = tooltipTitleType;
            return this;
        }

        @Override
        public final Builder tooltipTitleType(TooltipTitleType tooltipTitleType) {
            this.tooltipTitleType(tooltipTitleType == null ? null : tooltipTitleType.toString());
            return this;
        }

        public final List<TooltipItem.Builder> getTooltipFields() {
            List<TooltipItem.Builder> result = TooltipItemListCopier.copyToBuilder(this.tooltipFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTooltipFields(Collection<TooltipItem.BuilderImpl> tooltipFields) {
            this.tooltipFields = TooltipItemListCopier.copyFromBuilder(tooltipFields);
        }

        @Override
        public final Builder tooltipFields(Collection<TooltipItem> tooltipFields) {
            this.tooltipFields = TooltipItemListCopier.copy(tooltipFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tooltipFields(TooltipItem ... tooltipFields) {
            this.tooltipFields(Arrays.asList(tooltipFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tooltipFields(Consumer<TooltipItem.Builder> ... tooltipFields) {
            this.tooltipFields(Stream.of(tooltipFields).map(c -> (TooltipItem)((TooltipItem.Builder)TooltipItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FieldBasedTooltip build() {
            return new FieldBasedTooltip(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FieldBasedTooltip> {
        public Builder aggregationVisibility(String var1);

        public Builder aggregationVisibility(Visibility var1);

        public Builder tooltipTitleType(String var1);

        public Builder tooltipTitleType(TooltipTitleType var1);

        public Builder tooltipFields(Collection<TooltipItem> var1);

        public Builder tooltipFields(TooltipItem ... var1);

        public Builder tooltipFields(Consumer<TooltipItem.Builder> ... var1);
    }
}

