/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AnonymousUserDashboardEmbeddingConfigurationDisabledFeature;
import software.amazon.awssdk.services.quicksight.model.AnonymousUserDashboardEmbeddingConfigurationDisabledFeaturesCopier;
import software.amazon.awssdk.services.quicksight.model.AnonymousUserDashboardEmbeddingConfigurationEnabledFeature;
import software.amazon.awssdk.services.quicksight.model.AnonymousUserDashboardEmbeddingConfigurationEnabledFeaturesCopier;
import software.amazon.awssdk.services.quicksight.model.AnonymousUserDashboardFeatureConfigurations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnonymousUserDashboardEmbeddingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnonymousUserDashboardEmbeddingConfiguration> {
    private static final SdkField<String> INITIAL_DASHBOARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitialDashboardId").getter(AnonymousUserDashboardEmbeddingConfiguration.getter(AnonymousUserDashboardEmbeddingConfiguration::initialDashboardId)).setter(AnonymousUserDashboardEmbeddingConfiguration.setter(Builder::initialDashboardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialDashboardId").build()}).build();
    private static final SdkField<List<String>> ENABLED_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledFeatures").getter(AnonymousUserDashboardEmbeddingConfiguration.getter(AnonymousUserDashboardEmbeddingConfiguration::enabledFeaturesAsStrings)).setter(AnonymousUserDashboardEmbeddingConfiguration.setter(Builder::enabledFeaturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledFeatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DISABLED_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DisabledFeatures").getter(AnonymousUserDashboardEmbeddingConfiguration.getter(AnonymousUserDashboardEmbeddingConfiguration::disabledFeaturesAsStrings)).setter(AnonymousUserDashboardEmbeddingConfiguration.setter(Builder::disabledFeaturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledFeatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AnonymousUserDashboardFeatureConfigurations> FEATURE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FeatureConfigurations").getter(AnonymousUserDashboardEmbeddingConfiguration.getter(AnonymousUserDashboardEmbeddingConfiguration::featureConfigurations)).setter(AnonymousUserDashboardEmbeddingConfiguration.setter(Builder::featureConfigurations)).constructor(AnonymousUserDashboardFeatureConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureConfigurations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_DASHBOARD_ID_FIELD, ENABLED_FEATURES_FIELD, DISABLED_FEATURES_FIELD, FEATURE_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InitialDashboardId", INITIAL_DASHBOARD_ID_FIELD);
            this.put("EnabledFeatures", ENABLED_FEATURES_FIELD);
            this.put("DisabledFeatures", DISABLED_FEATURES_FIELD);
            this.put("FeatureConfigurations", FEATURE_CONFIGURATIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String initialDashboardId;
    private final List<String> enabledFeatures;
    private final List<String> disabledFeatures;
    private final AnonymousUserDashboardFeatureConfigurations featureConfigurations;

    private AnonymousUserDashboardEmbeddingConfiguration(BuilderImpl builder) {
        this.initialDashboardId = builder.initialDashboardId;
        this.enabledFeatures = builder.enabledFeatures;
        this.disabledFeatures = builder.disabledFeatures;
        this.featureConfigurations = builder.featureConfigurations;
    }

    public final String initialDashboardId() {
        return this.initialDashboardId;
    }

    public final List<AnonymousUserDashboardEmbeddingConfigurationEnabledFeature> enabledFeatures() {
        return AnonymousUserDashboardEmbeddingConfigurationEnabledFeaturesCopier.copyStringToEnum(this.enabledFeatures);
    }

    public final boolean hasEnabledFeatures() {
        return this.enabledFeatures != null && !(this.enabledFeatures instanceof SdkAutoConstructList);
    }

    public final List<String> enabledFeaturesAsStrings() {
        return this.enabledFeatures;
    }

    public final List<AnonymousUserDashboardEmbeddingConfigurationDisabledFeature> disabledFeatures() {
        return AnonymousUserDashboardEmbeddingConfigurationDisabledFeaturesCopier.copyStringToEnum(this.disabledFeatures);
    }

    public final boolean hasDisabledFeatures() {
        return this.disabledFeatures != null && !(this.disabledFeatures instanceof SdkAutoConstructList);
    }

    public final List<String> disabledFeaturesAsStrings() {
        return this.disabledFeatures;
    }

    public final AnonymousUserDashboardFeatureConfigurations featureConfigurations() {
        return this.featureConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.initialDashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledFeatures() ? this.enabledFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisabledFeatures() ? this.disabledFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.featureConfigurations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnonymousUserDashboardEmbeddingConfiguration)) {
            return false;
        }
        AnonymousUserDashboardEmbeddingConfiguration other = (AnonymousUserDashboardEmbeddingConfiguration)obj;
        return Objects.equals(this.initialDashboardId(), other.initialDashboardId()) && this.hasEnabledFeatures() == other.hasEnabledFeatures() && Objects.equals(this.enabledFeaturesAsStrings(), other.enabledFeaturesAsStrings()) && this.hasDisabledFeatures() == other.hasDisabledFeatures() && Objects.equals(this.disabledFeaturesAsStrings(), other.disabledFeaturesAsStrings()) && Objects.equals(this.featureConfigurations(), other.featureConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"AnonymousUserDashboardEmbeddingConfiguration").add("InitialDashboardId", (Object)this.initialDashboardId()).add("EnabledFeatures", this.hasEnabledFeatures() ? this.enabledFeaturesAsStrings() : null).add("DisabledFeatures", this.hasDisabledFeatures() ? this.disabledFeaturesAsStrings() : null).add("FeatureConfigurations", (Object)this.featureConfigurations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InitialDashboardId": {
                return Optional.ofNullable(clazz.cast(this.initialDashboardId()));
            }
            case "EnabledFeatures": {
                return Optional.ofNullable(clazz.cast(this.enabledFeaturesAsStrings()));
            }
            case "DisabledFeatures": {
                return Optional.ofNullable(clazz.cast(this.disabledFeaturesAsStrings()));
            }
            case "FeatureConfigurations": {
                return Optional.ofNullable(clazz.cast(this.featureConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AnonymousUserDashboardEmbeddingConfiguration, T> g) {
        return obj -> g.apply((AnonymousUserDashboardEmbeddingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String initialDashboardId;
        private List<String> enabledFeatures = DefaultSdkAutoConstructList.getInstance();
        private List<String> disabledFeatures = DefaultSdkAutoConstructList.getInstance();
        private AnonymousUserDashboardFeatureConfigurations featureConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(AnonymousUserDashboardEmbeddingConfiguration model) {
            this.initialDashboardId(model.initialDashboardId);
            this.enabledFeaturesWithStrings(model.enabledFeatures);
            this.disabledFeaturesWithStrings(model.disabledFeatures);
            this.featureConfigurations(model.featureConfigurations);
        }

        public final String getInitialDashboardId() {
            return this.initialDashboardId;
        }

        public final void setInitialDashboardId(String initialDashboardId) {
            this.initialDashboardId = initialDashboardId;
        }

        @Override
        public final Builder initialDashboardId(String initialDashboardId) {
            this.initialDashboardId = initialDashboardId;
            return this;
        }

        public final Collection<String> getEnabledFeatures() {
            if (this.enabledFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledFeatures;
        }

        public final void setEnabledFeatures(Collection<String> enabledFeatures) {
            this.enabledFeatures = AnonymousUserDashboardEmbeddingConfigurationEnabledFeaturesCopier.copy(enabledFeatures);
        }

        @Override
        public final Builder enabledFeaturesWithStrings(Collection<String> enabledFeatures) {
            this.enabledFeatures = AnonymousUserDashboardEmbeddingConfigurationEnabledFeaturesCopier.copy(enabledFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledFeaturesWithStrings(String ... enabledFeatures) {
            this.enabledFeaturesWithStrings(Arrays.asList(enabledFeatures));
            return this;
        }

        @Override
        public final Builder enabledFeatures(Collection<AnonymousUserDashboardEmbeddingConfigurationEnabledFeature> enabledFeatures) {
            this.enabledFeatures = AnonymousUserDashboardEmbeddingConfigurationEnabledFeaturesCopier.copyEnumToString(enabledFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledFeatures(AnonymousUserDashboardEmbeddingConfigurationEnabledFeature ... enabledFeatures) {
            this.enabledFeatures(Arrays.asList(enabledFeatures));
            return this;
        }

        public final Collection<String> getDisabledFeatures() {
            if (this.disabledFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.disabledFeatures;
        }

        public final void setDisabledFeatures(Collection<String> disabledFeatures) {
            this.disabledFeatures = AnonymousUserDashboardEmbeddingConfigurationDisabledFeaturesCopier.copy(disabledFeatures);
        }

        @Override
        public final Builder disabledFeaturesWithStrings(Collection<String> disabledFeatures) {
            this.disabledFeatures = AnonymousUserDashboardEmbeddingConfigurationDisabledFeaturesCopier.copy(disabledFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disabledFeaturesWithStrings(String ... disabledFeatures) {
            this.disabledFeaturesWithStrings(Arrays.asList(disabledFeatures));
            return this;
        }

        @Override
        public final Builder disabledFeatures(Collection<AnonymousUserDashboardEmbeddingConfigurationDisabledFeature> disabledFeatures) {
            this.disabledFeatures = AnonymousUserDashboardEmbeddingConfigurationDisabledFeaturesCopier.copyEnumToString(disabledFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disabledFeatures(AnonymousUserDashboardEmbeddingConfigurationDisabledFeature ... disabledFeatures) {
            this.disabledFeatures(Arrays.asList(disabledFeatures));
            return this;
        }

        public final AnonymousUserDashboardFeatureConfigurations.Builder getFeatureConfigurations() {
            return this.featureConfigurations != null ? this.featureConfigurations.toBuilder() : null;
        }

        public final void setFeatureConfigurations(AnonymousUserDashboardFeatureConfigurations.BuilderImpl featureConfigurations) {
            this.featureConfigurations = featureConfigurations != null ? featureConfigurations.build() : null;
        }

        @Override
        public final Builder featureConfigurations(AnonymousUserDashboardFeatureConfigurations featureConfigurations) {
            this.featureConfigurations = featureConfigurations;
            return this;
        }

        public AnonymousUserDashboardEmbeddingConfiguration build() {
            return new AnonymousUserDashboardEmbeddingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnonymousUserDashboardEmbeddingConfiguration> {
        public Builder initialDashboardId(String var1);

        public Builder enabledFeaturesWithStrings(Collection<String> var1);

        public Builder enabledFeaturesWithStrings(String ... var1);

        public Builder enabledFeatures(Collection<AnonymousUserDashboardEmbeddingConfigurationEnabledFeature> var1);

        public Builder enabledFeatures(AnonymousUserDashboardEmbeddingConfigurationEnabledFeature ... var1);

        public Builder disabledFeaturesWithStrings(Collection<String> var1);

        public Builder disabledFeaturesWithStrings(String ... var1);

        public Builder disabledFeatures(Collection<AnonymousUserDashboardEmbeddingConfigurationDisabledFeature> var1);

        public Builder disabledFeatures(AnonymousUserDashboardEmbeddingConfigurationDisabledFeature ... var1);

        public Builder featureConfigurations(AnonymousUserDashboardFeatureConfigurations var1);

        default public Builder featureConfigurations(Consumer<AnonymousUserDashboardFeatureConfigurations.Builder> featureConfigurations) {
            return this.featureConfigurations((AnonymousUserDashboardFeatureConfigurations)((AnonymousUserDashboardFeatureConfigurations.Builder)AnonymousUserDashboardFeatureConfigurations.builder().applyMutation(featureConfigurations)).build());
        }
    }
}

