/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.UserRole;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateUserRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(UpdateUserRequest.getter(UpdateUserRequest::userName)).setter(UpdateUserRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("UserName").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateUserRequest.getter(UpdateUserRequest::awsAccountId)).setter(UpdateUserRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(UpdateUserRequest.getter(UpdateUserRequest::namespace)).setter(UpdateUserRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Email").getter(UpdateUserRequest.getter(UpdateUserRequest::email)).setter(UpdateUserRequest.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(UpdateUserRequest.getter(UpdateUserRequest::roleAsString)).setter(UpdateUserRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> CUSTOM_PERMISSIONS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomPermissionsName").getter(UpdateUserRequest.getter(UpdateUserRequest::customPermissionsName)).setter(UpdateUserRequest.setter(Builder::customPermissionsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPermissionsName").build()}).build();
    private static final SdkField<Boolean> UNAPPLY_CUSTOM_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UnapplyCustomPermissions").getter(UpdateUserRequest.getter(UpdateUserRequest::unapplyCustomPermissions)).setter(UpdateUserRequest.setter(Builder::unapplyCustomPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnapplyCustomPermissions").build()}).build();
    private static final SdkField<String> EXTERNAL_LOGIN_FEDERATION_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalLoginFederationProviderType").getter(UpdateUserRequest.getter(UpdateUserRequest::externalLoginFederationProviderType)).setter(UpdateUserRequest.setter(Builder::externalLoginFederationProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalLoginFederationProviderType").build()}).build();
    private static final SdkField<String> CUSTOM_FEDERATION_PROVIDER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomFederationProviderUrl").getter(UpdateUserRequest.getter(UpdateUserRequest::customFederationProviderUrl)).setter(UpdateUserRequest.setter(Builder::customFederationProviderUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomFederationProviderUrl").build()}).build();
    private static final SdkField<String> EXTERNAL_LOGIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalLoginId").getter(UpdateUserRequest.getter(UpdateUserRequest::externalLoginId)).setter(UpdateUserRequest.setter(Builder::externalLoginId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalLoginId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, AWS_ACCOUNT_ID_FIELD, NAMESPACE_FIELD, EMAIL_FIELD, ROLE_FIELD, CUSTOM_PERMISSIONS_NAME_FIELD, UNAPPLY_CUSTOM_PERMISSIONS_FIELD, EXTERNAL_LOGIN_FEDERATION_PROVIDER_TYPE_FIELD, CUSTOM_FEDERATION_PROVIDER_URL_FIELD, EXTERNAL_LOGIN_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UserName", USER_NAME_FIELD);
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("Namespace", NAMESPACE_FIELD);
            this.put("Email", EMAIL_FIELD);
            this.put("Role", ROLE_FIELD);
            this.put("CustomPermissionsName", CUSTOM_PERMISSIONS_NAME_FIELD);
            this.put("UnapplyCustomPermissions", UNAPPLY_CUSTOM_PERMISSIONS_FIELD);
            this.put("ExternalLoginFederationProviderType", EXTERNAL_LOGIN_FEDERATION_PROVIDER_TYPE_FIELD);
            this.put("CustomFederationProviderUrl", CUSTOM_FEDERATION_PROVIDER_URL_FIELD);
            this.put("ExternalLoginId", EXTERNAL_LOGIN_ID_FIELD);
        }
    });
    private final String userName;
    private final String awsAccountId;
    private final String namespace;
    private final String email;
    private final String role;
    private final String customPermissionsName;
    private final Boolean unapplyCustomPermissions;
    private final String externalLoginFederationProviderType;
    private final String customFederationProviderUrl;
    private final String externalLoginId;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
        this.email = builder.email;
        this.role = builder.role;
        this.customPermissionsName = builder.customPermissionsName;
        this.unapplyCustomPermissions = builder.unapplyCustomPermissions;
        this.externalLoginFederationProviderType = builder.externalLoginFederationProviderType;
        this.customFederationProviderUrl = builder.customFederationProviderUrl;
        this.externalLoginId = builder.externalLoginId;
    }

    public final String userName() {
        return this.userName;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String email() {
        return this.email;
    }

    public final UserRole role() {
        return UserRole.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    public final String customPermissionsName() {
        return this.customPermissionsName;
    }

    public final Boolean unapplyCustomPermissions() {
        return this.unapplyCustomPermissions;
    }

    public final String externalLoginFederationProviderType() {
        return this.externalLoginFederationProviderType;
    }

    public final String customFederationProviderUrl() {
        return this.customFederationProviderUrl;
    }

    public final String externalLoginId() {
        return this.externalLoginId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPermissionsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.unapplyCustomPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalLoginFederationProviderType());
        hashCode = 31 * hashCode + Objects.hashCode(this.customFederationProviderUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalLoginId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.roleAsString(), other.roleAsString()) && Objects.equals(this.customPermissionsName(), other.customPermissionsName()) && Objects.equals(this.unapplyCustomPermissions(), other.unapplyCustomPermissions()) && Objects.equals(this.externalLoginFederationProviderType(), other.externalLoginFederationProviderType()) && Objects.equals(this.customFederationProviderUrl(), other.customFederationProviderUrl()) && Objects.equals(this.externalLoginId(), other.externalLoginId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserRequest").add("UserName", (Object)this.userName()).add("AwsAccountId", (Object)this.awsAccountId()).add("Namespace", (Object)this.namespace()).add("Email", (Object)this.email()).add("Role", (Object)this.roleAsString()).add("CustomPermissionsName", (Object)this.customPermissionsName()).add("UnapplyCustomPermissions", (Object)this.unapplyCustomPermissions()).add("ExternalLoginFederationProviderType", (Object)this.externalLoginFederationProviderType()).add("CustomFederationProviderUrl", (Object)this.customFederationProviderUrl()).add("ExternalLoginId", (Object)this.externalLoginId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "CustomPermissionsName": {
                return Optional.ofNullable(clazz.cast(this.customPermissionsName()));
            }
            case "UnapplyCustomPermissions": {
                return Optional.ofNullable(clazz.cast(this.unapplyCustomPermissions()));
            }
            case "ExternalLoginFederationProviderType": {
                return Optional.ofNullable(clazz.cast(this.externalLoginFederationProviderType()));
            }
            case "CustomFederationProviderUrl": {
                return Optional.ofNullable(clazz.cast(this.customFederationProviderUrl()));
            }
            case "ExternalLoginId": {
                return Optional.ofNullable(clazz.cast(this.externalLoginId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String awsAccountId;
        private String namespace;
        private String email;
        private String role;
        private String customPermissionsName;
        private Boolean unapplyCustomPermissions;
        private String externalLoginFederationProviderType;
        private String customFederationProviderUrl;
        private String externalLoginId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            this.userName(model.userName);
            this.awsAccountId(model.awsAccountId);
            this.namespace(model.namespace);
            this.email(model.email);
            this.role(model.role);
            this.customPermissionsName(model.customPermissionsName);
            this.unapplyCustomPermissions(model.unapplyCustomPermissions);
            this.externalLoginFederationProviderType(model.externalLoginFederationProviderType);
            this.customFederationProviderUrl(model.customFederationProviderUrl);
            this.externalLoginId(model.externalLoginId);
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(UserRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getCustomPermissionsName() {
            return this.customPermissionsName;
        }

        public final void setCustomPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
        }

        @Override
        public final Builder customPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
            return this;
        }

        public final Boolean getUnapplyCustomPermissions() {
            return this.unapplyCustomPermissions;
        }

        public final void setUnapplyCustomPermissions(Boolean unapplyCustomPermissions) {
            this.unapplyCustomPermissions = unapplyCustomPermissions;
        }

        @Override
        public final Builder unapplyCustomPermissions(Boolean unapplyCustomPermissions) {
            this.unapplyCustomPermissions = unapplyCustomPermissions;
            return this;
        }

        public final String getExternalLoginFederationProviderType() {
            return this.externalLoginFederationProviderType;
        }

        public final void setExternalLoginFederationProviderType(String externalLoginFederationProviderType) {
            this.externalLoginFederationProviderType = externalLoginFederationProviderType;
        }

        @Override
        public final Builder externalLoginFederationProviderType(String externalLoginFederationProviderType) {
            this.externalLoginFederationProviderType = externalLoginFederationProviderType;
            return this;
        }

        public final String getCustomFederationProviderUrl() {
            return this.customFederationProviderUrl;
        }

        public final void setCustomFederationProviderUrl(String customFederationProviderUrl) {
            this.customFederationProviderUrl = customFederationProviderUrl;
        }

        @Override
        public final Builder customFederationProviderUrl(String customFederationProviderUrl) {
            this.customFederationProviderUrl = customFederationProviderUrl;
            return this;
        }

        public final String getExternalLoginId() {
            return this.externalLoginId;
        }

        public final void setExternalLoginId(String externalLoginId) {
            this.externalLoginId = externalLoginId;
        }

        @Override
        public final Builder externalLoginId(String externalLoginId) {
            this.externalLoginId = externalLoginId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserRequest> {
        public Builder userName(String var1);

        public Builder awsAccountId(String var1);

        public Builder namespace(String var1);

        public Builder email(String var1);

        public Builder role(String var1);

        public Builder role(UserRole var1);

        public Builder customPermissionsName(String var1);

        public Builder unapplyCustomPermissions(Boolean var1);

        public Builder externalLoginFederationProviderType(String var1);

        public Builder customFederationProviderUrl(String var1);

        public Builder externalLoginId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

