/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AnalysisDefaults;
import software.amazon.awssdk.services.quicksight.model.AssetOptions;
import software.amazon.awssdk.services.quicksight.model.CalculatedField;
import software.amazon.awssdk.services.quicksight.model.CalculatedFieldsCopier;
import software.amazon.awssdk.services.quicksight.model.ColumnConfiguration;
import software.amazon.awssdk.services.quicksight.model.ColumnConfigurationListCopier;
import software.amazon.awssdk.services.quicksight.model.DataSetConfiguration;
import software.amazon.awssdk.services.quicksight.model.DataSetConfigurationListCopier;
import software.amazon.awssdk.services.quicksight.model.FilterGroup;
import software.amazon.awssdk.services.quicksight.model.FilterGroupListCopier;
import software.amazon.awssdk.services.quicksight.model.ParameterDeclaration;
import software.amazon.awssdk.services.quicksight.model.ParameterDeclarationListCopier;
import software.amazon.awssdk.services.quicksight.model.QueryExecutionOptions;
import software.amazon.awssdk.services.quicksight.model.SheetDefinition;
import software.amazon.awssdk.services.quicksight.model.SheetDefinitionListCopier;
import software.amazon.awssdk.services.quicksight.model.StaticFile;
import software.amazon.awssdk.services.quicksight.model.StaticFileListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateVersionDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateVersionDefinition> {
    private static final SdkField<List<DataSetConfiguration>> DATA_SET_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataSetConfigurations").getter(TemplateVersionDefinition.getter(TemplateVersionDefinition::dataSetConfigurations)).setter(TemplateVersionDefinition.setter(Builder::dataSetConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SheetDefinition>> SHEETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sheets").getter(TemplateVersionDefinition.getter(TemplateVersionDefinition::sheets)).setter(TemplateVersionDefinition.setter(Builder::sheets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sheets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SheetDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CalculatedField>> CALCULATED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CalculatedFields").getter(TemplateVersionDefinition.getter(TemplateVersionDefinition::calculatedFields)).setter(TemplateVersionDefinition.setter(Builder::calculatedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CalculatedField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ParameterDeclaration>> PARAMETER_DECLARATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParameterDeclarations").getter(TemplateVersionDefinition.getter(TemplateVersionDefinition::parameterDeclarations)).setter(TemplateVersionDefinition.setter(Builder::parameterDeclarations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterDeclarations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterDeclaration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FilterGroup>> FILTER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterGroups").getter(TemplateVersionDefinition.getter(TemplateVersionDefinition::filterGroups)).setter(TemplateVersionDefinition.setter(Builder::filterGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ColumnConfiguration>> COLUMN_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnConfigurations").getter(TemplateVersionDefinition.getter(TemplateVersionDefinition::columnConfigurations)).setter(TemplateVersionDefinition.setter(Builder::columnConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AnalysisDefaults> ANALYSIS_DEFAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnalysisDefaults").getter(TemplateVersionDefinition.getter(TemplateVersionDefinition::analysisDefaults)).setter(TemplateVersionDefinition.setter(Builder::analysisDefaults)).constructor(AnalysisDefaults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisDefaults").build()}).build();
    private static final SdkField<AssetOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(TemplateVersionDefinition.getter(TemplateVersionDefinition::options)).setter(TemplateVersionDefinition.setter(Builder::options)).constructor(AssetOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final SdkField<QueryExecutionOptions> QUERY_EXECUTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryExecutionOptions").getter(TemplateVersionDefinition.getter(TemplateVersionDefinition::queryExecutionOptions)).setter(TemplateVersionDefinition.setter(Builder::queryExecutionOptions)).constructor(QueryExecutionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryExecutionOptions").build()}).build();
    private static final SdkField<List<StaticFile>> STATIC_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StaticFiles").getter(TemplateVersionDefinition.getter(TemplateVersionDefinition::staticFiles)).setter(TemplateVersionDefinition.setter(Builder::staticFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticFiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StaticFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_CONFIGURATIONS_FIELD, SHEETS_FIELD, CALCULATED_FIELDS_FIELD, PARAMETER_DECLARATIONS_FIELD, FILTER_GROUPS_FIELD, COLUMN_CONFIGURATIONS_FIELD, ANALYSIS_DEFAULTS_FIELD, OPTIONS_FIELD, QUERY_EXECUTION_OPTIONS_FIELD, STATIC_FILES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataSetConfigurations", DATA_SET_CONFIGURATIONS_FIELD);
            this.put("Sheets", SHEETS_FIELD);
            this.put("CalculatedFields", CALCULATED_FIELDS_FIELD);
            this.put("ParameterDeclarations", PARAMETER_DECLARATIONS_FIELD);
            this.put("FilterGroups", FILTER_GROUPS_FIELD);
            this.put("ColumnConfigurations", COLUMN_CONFIGURATIONS_FIELD);
            this.put("AnalysisDefaults", ANALYSIS_DEFAULTS_FIELD);
            this.put("Options", OPTIONS_FIELD);
            this.put("QueryExecutionOptions", QUERY_EXECUTION_OPTIONS_FIELD);
            this.put("StaticFiles", STATIC_FILES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<DataSetConfiguration> dataSetConfigurations;
    private final List<SheetDefinition> sheets;
    private final List<CalculatedField> calculatedFields;
    private final List<ParameterDeclaration> parameterDeclarations;
    private final List<FilterGroup> filterGroups;
    private final List<ColumnConfiguration> columnConfigurations;
    private final AnalysisDefaults analysisDefaults;
    private final AssetOptions options;
    private final QueryExecutionOptions queryExecutionOptions;
    private final List<StaticFile> staticFiles;

    private TemplateVersionDefinition(BuilderImpl builder) {
        this.dataSetConfigurations = builder.dataSetConfigurations;
        this.sheets = builder.sheets;
        this.calculatedFields = builder.calculatedFields;
        this.parameterDeclarations = builder.parameterDeclarations;
        this.filterGroups = builder.filterGroups;
        this.columnConfigurations = builder.columnConfigurations;
        this.analysisDefaults = builder.analysisDefaults;
        this.options = builder.options;
        this.queryExecutionOptions = builder.queryExecutionOptions;
        this.staticFiles = builder.staticFiles;
    }

    public final boolean hasDataSetConfigurations() {
        return this.dataSetConfigurations != null && !(this.dataSetConfigurations instanceof SdkAutoConstructList);
    }

    public final List<DataSetConfiguration> dataSetConfigurations() {
        return this.dataSetConfigurations;
    }

    public final boolean hasSheets() {
        return this.sheets != null && !(this.sheets instanceof SdkAutoConstructList);
    }

    public final List<SheetDefinition> sheets() {
        return this.sheets;
    }

    public final boolean hasCalculatedFields() {
        return this.calculatedFields != null && !(this.calculatedFields instanceof SdkAutoConstructList);
    }

    public final List<CalculatedField> calculatedFields() {
        return this.calculatedFields;
    }

    public final boolean hasParameterDeclarations() {
        return this.parameterDeclarations != null && !(this.parameterDeclarations instanceof SdkAutoConstructList);
    }

    public final List<ParameterDeclaration> parameterDeclarations() {
        return this.parameterDeclarations;
    }

    public final boolean hasFilterGroups() {
        return this.filterGroups != null && !(this.filterGroups instanceof SdkAutoConstructList);
    }

    public final List<FilterGroup> filterGroups() {
        return this.filterGroups;
    }

    public final boolean hasColumnConfigurations() {
        return this.columnConfigurations != null && !(this.columnConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ColumnConfiguration> columnConfigurations() {
        return this.columnConfigurations;
    }

    public final AnalysisDefaults analysisDefaults() {
        return this.analysisDefaults;
    }

    public final AssetOptions options() {
        return this.options;
    }

    public final QueryExecutionOptions queryExecutionOptions() {
        return this.queryExecutionOptions;
    }

    public final boolean hasStaticFiles() {
        return this.staticFiles != null && !(this.staticFiles instanceof SdkAutoConstructList);
    }

    public final List<StaticFile> staticFiles() {
        return this.staticFiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSetConfigurations() ? this.dataSetConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSheets() ? this.sheets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCalculatedFields() ? this.calculatedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterDeclarations() ? this.parameterDeclarations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterGroups() ? this.filterGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnConfigurations() ? this.columnConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisDefaults());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryExecutionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStaticFiles() ? this.staticFiles() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateVersionDefinition)) {
            return false;
        }
        TemplateVersionDefinition other = (TemplateVersionDefinition)obj;
        return this.hasDataSetConfigurations() == other.hasDataSetConfigurations() && Objects.equals(this.dataSetConfigurations(), other.dataSetConfigurations()) && this.hasSheets() == other.hasSheets() && Objects.equals(this.sheets(), other.sheets()) && this.hasCalculatedFields() == other.hasCalculatedFields() && Objects.equals(this.calculatedFields(), other.calculatedFields()) && this.hasParameterDeclarations() == other.hasParameterDeclarations() && Objects.equals(this.parameterDeclarations(), other.parameterDeclarations()) && this.hasFilterGroups() == other.hasFilterGroups() && Objects.equals(this.filterGroups(), other.filterGroups()) && this.hasColumnConfigurations() == other.hasColumnConfigurations() && Objects.equals(this.columnConfigurations(), other.columnConfigurations()) && Objects.equals(this.analysisDefaults(), other.analysisDefaults()) && Objects.equals(this.options(), other.options()) && Objects.equals(this.queryExecutionOptions(), other.queryExecutionOptions()) && this.hasStaticFiles() == other.hasStaticFiles() && Objects.equals(this.staticFiles(), other.staticFiles());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateVersionDefinition").add("DataSetConfigurations", this.hasDataSetConfigurations() ? this.dataSetConfigurations() : null).add("Sheets", this.hasSheets() ? this.sheets() : null).add("CalculatedFields", this.hasCalculatedFields() ? this.calculatedFields() : null).add("ParameterDeclarations", this.hasParameterDeclarations() ? this.parameterDeclarations() : null).add("FilterGroups", this.hasFilterGroups() ? this.filterGroups() : null).add("ColumnConfigurations", this.hasColumnConfigurations() ? this.columnConfigurations() : null).add("AnalysisDefaults", (Object)this.analysisDefaults()).add("Options", (Object)this.options()).add("QueryExecutionOptions", (Object)this.queryExecutionOptions()).add("StaticFiles", this.hasStaticFiles() ? this.staticFiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetConfigurations": {
                return Optional.ofNullable(clazz.cast(this.dataSetConfigurations()));
            }
            case "Sheets": {
                return Optional.ofNullable(clazz.cast(this.sheets()));
            }
            case "CalculatedFields": {
                return Optional.ofNullable(clazz.cast(this.calculatedFields()));
            }
            case "ParameterDeclarations": {
                return Optional.ofNullable(clazz.cast(this.parameterDeclarations()));
            }
            case "FilterGroups": {
                return Optional.ofNullable(clazz.cast(this.filterGroups()));
            }
            case "ColumnConfigurations": {
                return Optional.ofNullable(clazz.cast(this.columnConfigurations()));
            }
            case "AnalysisDefaults": {
                return Optional.ofNullable(clazz.cast(this.analysisDefaults()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "QueryExecutionOptions": {
                return Optional.ofNullable(clazz.cast(this.queryExecutionOptions()));
            }
            case "StaticFiles": {
                return Optional.ofNullable(clazz.cast(this.staticFiles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TemplateVersionDefinition, T> g) {
        return obj -> g.apply((TemplateVersionDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DataSetConfiguration> dataSetConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<SheetDefinition> sheets = DefaultSdkAutoConstructList.getInstance();
        private List<CalculatedField> calculatedFields = DefaultSdkAutoConstructList.getInstance();
        private List<ParameterDeclaration> parameterDeclarations = DefaultSdkAutoConstructList.getInstance();
        private List<FilterGroup> filterGroups = DefaultSdkAutoConstructList.getInstance();
        private List<ColumnConfiguration> columnConfigurations = DefaultSdkAutoConstructList.getInstance();
        private AnalysisDefaults analysisDefaults;
        private AssetOptions options;
        private QueryExecutionOptions queryExecutionOptions;
        private List<StaticFile> staticFiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateVersionDefinition model) {
            this.dataSetConfigurations(model.dataSetConfigurations);
            this.sheets(model.sheets);
            this.calculatedFields(model.calculatedFields);
            this.parameterDeclarations(model.parameterDeclarations);
            this.filterGroups(model.filterGroups);
            this.columnConfigurations(model.columnConfigurations);
            this.analysisDefaults(model.analysisDefaults);
            this.options(model.options);
            this.queryExecutionOptions(model.queryExecutionOptions);
            this.staticFiles(model.staticFiles);
        }

        public final List<DataSetConfiguration.Builder> getDataSetConfigurations() {
            List<DataSetConfiguration.Builder> result = DataSetConfigurationListCopier.copyToBuilder(this.dataSetConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSetConfigurations(Collection<DataSetConfiguration.BuilderImpl> dataSetConfigurations) {
            this.dataSetConfigurations = DataSetConfigurationListCopier.copyFromBuilder(dataSetConfigurations);
        }

        @Override
        public final Builder dataSetConfigurations(Collection<DataSetConfiguration> dataSetConfigurations) {
            this.dataSetConfigurations = DataSetConfigurationListCopier.copy(dataSetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetConfigurations(DataSetConfiguration ... dataSetConfigurations) {
            this.dataSetConfigurations(Arrays.asList(dataSetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetConfigurations(Consumer<DataSetConfiguration.Builder> ... dataSetConfigurations) {
            this.dataSetConfigurations(Stream.of(dataSetConfigurations).map(c -> (DataSetConfiguration)((DataSetConfiguration.Builder)DataSetConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SheetDefinition.Builder> getSheets() {
            List<SheetDefinition.Builder> result = SheetDefinitionListCopier.copyToBuilder(this.sheets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSheets(Collection<SheetDefinition.BuilderImpl> sheets) {
            this.sheets = SheetDefinitionListCopier.copyFromBuilder(sheets);
        }

        @Override
        public final Builder sheets(Collection<SheetDefinition> sheets) {
            this.sheets = SheetDefinitionListCopier.copy(sheets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheets(SheetDefinition ... sheets) {
            this.sheets(Arrays.asList(sheets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheets(Consumer<SheetDefinition.Builder> ... sheets) {
            this.sheets(Stream.of(sheets).map(c -> (SheetDefinition)((SheetDefinition.Builder)SheetDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CalculatedField.Builder> getCalculatedFields() {
            List<CalculatedField.Builder> result = CalculatedFieldsCopier.copyToBuilder(this.calculatedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCalculatedFields(Collection<CalculatedField.BuilderImpl> calculatedFields) {
            this.calculatedFields = CalculatedFieldsCopier.copyFromBuilder(calculatedFields);
        }

        @Override
        public final Builder calculatedFields(Collection<CalculatedField> calculatedFields) {
            this.calculatedFields = CalculatedFieldsCopier.copy(calculatedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFields(CalculatedField ... calculatedFields) {
            this.calculatedFields(Arrays.asList(calculatedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFields(Consumer<CalculatedField.Builder> ... calculatedFields) {
            this.calculatedFields(Stream.of(calculatedFields).map(c -> (CalculatedField)((CalculatedField.Builder)CalculatedField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ParameterDeclaration.Builder> getParameterDeclarations() {
            List<ParameterDeclaration.Builder> result = ParameterDeclarationListCopier.copyToBuilder(this.parameterDeclarations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterDeclarations(Collection<ParameterDeclaration.BuilderImpl> parameterDeclarations) {
            this.parameterDeclarations = ParameterDeclarationListCopier.copyFromBuilder(parameterDeclarations);
        }

        @Override
        public final Builder parameterDeclarations(Collection<ParameterDeclaration> parameterDeclarations) {
            this.parameterDeclarations = ParameterDeclarationListCopier.copy(parameterDeclarations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDeclarations(ParameterDeclaration ... parameterDeclarations) {
            this.parameterDeclarations(Arrays.asList(parameterDeclarations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDeclarations(Consumer<ParameterDeclaration.Builder> ... parameterDeclarations) {
            this.parameterDeclarations(Stream.of(parameterDeclarations).map(c -> (ParameterDeclaration)((ParameterDeclaration.Builder)ParameterDeclaration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FilterGroup.Builder> getFilterGroups() {
            List<FilterGroup.Builder> result = FilterGroupListCopier.copyToBuilder(this.filterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterGroups(Collection<FilterGroup.BuilderImpl> filterGroups) {
            this.filterGroups = FilterGroupListCopier.copyFromBuilder(filterGroups);
        }

        @Override
        public final Builder filterGroups(Collection<FilterGroup> filterGroups) {
            this.filterGroups = FilterGroupListCopier.copy(filterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterGroups(FilterGroup ... filterGroups) {
            this.filterGroups(Arrays.asList(filterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterGroups(Consumer<FilterGroup.Builder> ... filterGroups) {
            this.filterGroups(Stream.of(filterGroups).map(c -> (FilterGroup)((FilterGroup.Builder)FilterGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ColumnConfiguration.Builder> getColumnConfigurations() {
            List<ColumnConfiguration.Builder> result = ColumnConfigurationListCopier.copyToBuilder(this.columnConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnConfigurations(Collection<ColumnConfiguration.BuilderImpl> columnConfigurations) {
            this.columnConfigurations = ColumnConfigurationListCopier.copyFromBuilder(columnConfigurations);
        }

        @Override
        public final Builder columnConfigurations(Collection<ColumnConfiguration> columnConfigurations) {
            this.columnConfigurations = ColumnConfigurationListCopier.copy(columnConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnConfigurations(ColumnConfiguration ... columnConfigurations) {
            this.columnConfigurations(Arrays.asList(columnConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnConfigurations(Consumer<ColumnConfiguration.Builder> ... columnConfigurations) {
            this.columnConfigurations(Stream.of(columnConfigurations).map(c -> (ColumnConfiguration)((ColumnConfiguration.Builder)ColumnConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AnalysisDefaults.Builder getAnalysisDefaults() {
            return this.analysisDefaults != null ? this.analysisDefaults.toBuilder() : null;
        }

        public final void setAnalysisDefaults(AnalysisDefaults.BuilderImpl analysisDefaults) {
            this.analysisDefaults = analysisDefaults != null ? analysisDefaults.build() : null;
        }

        @Override
        public final Builder analysisDefaults(AnalysisDefaults analysisDefaults) {
            this.analysisDefaults = analysisDefaults;
            return this;
        }

        public final AssetOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(AssetOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(AssetOptions options) {
            this.options = options;
            return this;
        }

        public final QueryExecutionOptions.Builder getQueryExecutionOptions() {
            return this.queryExecutionOptions != null ? this.queryExecutionOptions.toBuilder() : null;
        }

        public final void setQueryExecutionOptions(QueryExecutionOptions.BuilderImpl queryExecutionOptions) {
            this.queryExecutionOptions = queryExecutionOptions != null ? queryExecutionOptions.build() : null;
        }

        @Override
        public final Builder queryExecutionOptions(QueryExecutionOptions queryExecutionOptions) {
            this.queryExecutionOptions = queryExecutionOptions;
            return this;
        }

        public final List<StaticFile.Builder> getStaticFiles() {
            List<StaticFile.Builder> result = StaticFileListCopier.copyToBuilder(this.staticFiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStaticFiles(Collection<StaticFile.BuilderImpl> staticFiles) {
            this.staticFiles = StaticFileListCopier.copyFromBuilder(staticFiles);
        }

        @Override
        public final Builder staticFiles(Collection<StaticFile> staticFiles) {
            this.staticFiles = StaticFileListCopier.copy(staticFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticFiles(StaticFile ... staticFiles) {
            this.staticFiles(Arrays.asList(staticFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticFiles(Consumer<StaticFile.Builder> ... staticFiles) {
            this.staticFiles(Stream.of(staticFiles).map(c -> (StaticFile)((StaticFile.Builder)StaticFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TemplateVersionDefinition build() {
            return new TemplateVersionDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateVersionDefinition> {
        public Builder dataSetConfigurations(Collection<DataSetConfiguration> var1);

        public Builder dataSetConfigurations(DataSetConfiguration ... var1);

        public Builder dataSetConfigurations(Consumer<DataSetConfiguration.Builder> ... var1);

        public Builder sheets(Collection<SheetDefinition> var1);

        public Builder sheets(SheetDefinition ... var1);

        public Builder sheets(Consumer<SheetDefinition.Builder> ... var1);

        public Builder calculatedFields(Collection<CalculatedField> var1);

        public Builder calculatedFields(CalculatedField ... var1);

        public Builder calculatedFields(Consumer<CalculatedField.Builder> ... var1);

        public Builder parameterDeclarations(Collection<ParameterDeclaration> var1);

        public Builder parameterDeclarations(ParameterDeclaration ... var1);

        public Builder parameterDeclarations(Consumer<ParameterDeclaration.Builder> ... var1);

        public Builder filterGroups(Collection<FilterGroup> var1);

        public Builder filterGroups(FilterGroup ... var1);

        public Builder filterGroups(Consumer<FilterGroup.Builder> ... var1);

        public Builder columnConfigurations(Collection<ColumnConfiguration> var1);

        public Builder columnConfigurations(ColumnConfiguration ... var1);

        public Builder columnConfigurations(Consumer<ColumnConfiguration.Builder> ... var1);

        public Builder analysisDefaults(AnalysisDefaults var1);

        default public Builder analysisDefaults(Consumer<AnalysisDefaults.Builder> analysisDefaults) {
            return this.analysisDefaults((AnalysisDefaults)((AnalysisDefaults.Builder)AnalysisDefaults.builder().applyMutation(analysisDefaults)).build());
        }

        public Builder options(AssetOptions var1);

        default public Builder options(Consumer<AssetOptions.Builder> options) {
            return this.options((AssetOptions)((AssetOptions.Builder)AssetOptions.builder().applyMutation(options)).build());
        }

        public Builder queryExecutionOptions(QueryExecutionOptions var1);

        default public Builder queryExecutionOptions(Consumer<QueryExecutionOptions.Builder> queryExecutionOptions) {
            return this.queryExecutionOptions((QueryExecutionOptions)((QueryExecutionOptions.Builder)QueryExecutionOptions.builder().applyMutation(queryExecutionOptions)).build());
        }

        public Builder staticFiles(Collection<StaticFile> var1);

        public Builder staticFiles(StaticFile ... var1);

        public Builder staticFiles(Consumer<StaticFile.Builder> ... var1);
    }
}

